/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.providers;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.ui.providers.GridModelContentProvider;
import eu.geclipse.ui.providers.IConfigurationListener;
import eu.geclipse.ui.providers.ProgressTreeNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;

public class ConfigurableContentProvider
extends GridModelContentProvider {
    public static final int MODE_FLAT = 1;
    public static final int MODE_HIERARCHICAL = 2;
    private int mode = 1;
    private Object rootElement;
    private List<IConfigurationListener> listeners = new ArrayList<IConfigurationListener>();

    public void addConfigurationListener(IConfigurationListener listener) {
        this.listeners.add(listener);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = super.getChildren(parentElement);
        if (this.mode == 2) {
            children = this.filterChildren(children);
        }
        return children;
    }

    public Object[] getElements(Object inputElement) {
        this.rootElement = inputElement;
        Object[] elements = super.getElements(inputElement);
        switch (this.mode) {
            case 2: {
                elements = this.remapElements(inputElement, elements);
                break;
            }
            case 1: {
                elements = this.filterHierarchicalChildrens(elements);
            }
        }
        return elements;
    }

    public void setMode(int m) {
        if (this.mode != m) {
            this.mode = m;
            this.fireConfigurationChanged();
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void removeConfigurationListener(IConfigurationListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireConfigurationChanged() {
        for (IConfigurationListener listener : this.listeners) {
            listener.configurationChanged(this);
        }
    }

    protected boolean isVisible(IGridElement element) {
        boolean result = false;
        Object[] rootChildren = super.getChildren(this.rootElement);
        IPath elementPath = element.getPath();
        Object[] objectArray = rootChildren;
        int n = rootChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IPath rootPath;
            Object obj = objectArray[n2];
            if (obj instanceof IGridElement && (elementPath.isPrefixOf(rootPath = ((IGridElement)obj).getPath()) || rootPath.isPrefixOf(elementPath))) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }

    private Object[] filterChildren(Object[] children) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (children != null) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof IGridElement && this.isVisible((IGridElement)child) || child instanceof ProgressTreeNode) {
                    result.add(child);
                }
                ++n2;
            }
        }
        return result.toArray(new Object[result.size()]);
    }

    private Object[] remapElements(Object parent, Object[] elements) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IGridElement && parent instanceof IGridContainer) {
                element = this.remapElement((IGridContainer)parent, (IGridElement)element);
            }
            if (!result.contains(element)) {
                result.add(element);
            }
            ++n2;
        }
        return result.toArray(new Object[result.size()]);
    }

    protected Object remapElement(IGridContainer container, IGridElement element) {
        IGridElement result = element;
        IPath parentPath = container.getPath();
        IPath childPath = element.getPath();
        int childSegments = childPath.segmentCount();
        int matchingSegments = childPath.matchingFirstSegments(parentPath);
        if (matchingSegments != childSegments - 1) {
            IPath remappedPath = childPath.removeLastSegments(childSegments - matchingSegments - 1);
            result = GridModel.getRoot().findElement(remappedPath);
        }
        return result;
    }

    private Object[] filterHierarchicalChildrens(Object[] elements) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IGridElement) {
                IGridElement gridElement = (IGridElement)object;
                IGridContainer parent = gridElement.getParent();
                if (!this.isOnList(elements, parent)) {
                    result.add(object);
                }
            } else if (object instanceof ProgressTreeNode) {
                result.add(object);
            }
            ++n2;
        }
        return result.toArray(new Object[result.size()]);
    }

    private boolean isOnList(Object[] elements, Object object) {
        boolean onList = false;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object curObject = objectArray[n2];
            if (curObject == object) {
                onList = true;
                break;
            }
            ++n2;
        }
        return onList;
    }
}

