/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.providers;

import eu.geclipse.core.model.IGridConnection;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.providers.ElementManagerLabelProvider;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.runtime.CoreException;

public class ConnectionViewLabelProvider
extends ElementManagerLabelProvider {
    private static final String[] prefixes = new String[]{"", "k", "M", "G", "T", "P", "E"};
    private static final String FILE_SIZE_UNIT = "B";
    private static final String FILE_SIZE_FORMAT = "0.#";
    private DateFormat dateFormat = new SimpleDateFormat();
    private DecimalFormat sizeFormat = new DecimalFormat("0.#");

    protected String getColumnText(IGridElement element, int columnIndex) {
        String text = "";
        if (element instanceof IGridConnectionElement && !(element instanceof IGridConnection)) {
            IGridConnectionElement connection = (IGridConnectionElement)element;
            IFileInfo fileInfo = null;
            try {
                fileInfo = connection.getConnectionFileInfo();
            }
            catch (CoreException cExc) {
                Activator.logException(cExc);
            }
            if (fileInfo != null) {
                switch (columnIndex) {
                    case 2: {
                        text = this.getSizeString(fileInfo);
                        break;
                    }
                    case 3: {
                        text = this.getModificationString(fileInfo);
                    }
                }
            }
        }
        return text;
    }

    private String getModificationString(IFileInfo fileInfo) {
        long time;
        String result = "N/A";
        if (fileInfo != null && (time = fileInfo.getLastModified()) != 0L) {
            Date date = new Date(time);
            result = this.dateFormat.format(date);
        }
        return result;
    }

    private String getSizeString(IFileInfo fileInfo) {
        String result = "N/A";
        if (fileInfo != null) {
            long length = fileInfo.getLength();
            if (length == 0L) {
                result = "0 B";
            } else if (length > 0L) {
                double mag = Math.floor(Math.log(length) / Math.log(1024.0));
                if (mag >= (double)prefixes.length) {
                    mag = prefixes.length - 1;
                }
                double ref = Math.pow(1024.0, mag);
                double value = (double)length / ref;
                result = String.valueOf(this.sizeFormat.format(value)) + " " + prefixes[(int)mag] + FILE_SIZE_UNIT;
            }
        }
        return result;
    }
}

