/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.providers;

import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.providers.FetchChildrenJob;
import eu.geclipse.ui.providers.GridModelComparator;
import eu.geclipse.ui.providers.Messages;
import eu.geclipse.ui.providers.ProgressTreeNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;

public class GridModelContentProvider
implements ITreeContentProvider,
ITreeViewerListener {
    protected TreeViewer treeViewer;
    private Hashtable<IGridContainer, ProgressTreeNode> progressNodes = new Hashtable();
    private GridModelComparator comparator = new GridModelComparator();

    public Object[] getChildren(Object parentElement) {
        Object[] children = null;
        if (this.hasChildren(parentElement)) {
            children = this.getChildren((IGridContainer)parentElement);
        }
        if (children != null) {
            Arrays.sort(children, this.comparator);
        }
        return children;
    }

    public Object getParent(Object element) {
        IGridContainer parent = null;
        if (element instanceof IGridElement) {
            parent = ((IGridElement)element).getParent();
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        boolean result = false;
        if (element instanceof IGridContainer) {
            result = ((IGridContainer)element).hasChildren();
        }
        return result;
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements = this.getChildren(inputElement);
        if (elements == null) {
            elements = new Object[]{};
        }
        return elements;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TreeViewer) {
            this.treeViewerChanged(this.treeViewer, (TreeViewer)viewer);
        }
    }

    protected Object[] getChildren(IGridContainer container) {
        Object[] children = null;
        if (container.isLazy() && container.isDirty()) {
            ProgressTreeNode monitor = this.progressNodes.get(container);
            if (monitor == null) {
                FetchChildrenJob fetcher = new FetchChildrenJob(container, this.treeViewer.getControl().getShell());
                monitor = new ProgressTreeNode(this.treeViewer);
                this.progressNodes.put(container, monitor);
                fetcher.setExternalMonitor(monitor);
                fetcher.setSystem(true);
                fetcher.schedule();
            }
            children = new Object[]{monitor};
        } else {
            this.progressNodes.remove(container);
            try {
                IGridElement[] childElements = container.getChildren(null);
                ArrayList<IGridElement> visibleChildren = new ArrayList<IGridElement>();
                IGridElement[] iGridElementArray = childElements;
                int n = childElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridElement child = iGridElementArray[n2];
                    if (!child.isHidden()) {
                        visibleChildren.add(child);
                    }
                    ++n2;
                }
                children = visibleChildren.toArray(new IGridElement[visibleChildren.size()]);
            }
            catch (ProblemException pExc) {
                if (this.treeViewer != null) {
                    Shell shell = this.treeViewer.getControl().getShell();
                    ProblemDialog.openProblem(shell, Messages.getString("GridModelContentProvider.problem_title"), String.valueOf(Messages.getString("GridModelContentProvider.problem_text")) + container.getName(), pExc);
                }
                Activator.logException(pExc);
            }
        }
        return children;
    }

    protected void treeViewerChanged(TreeViewer oldViewer, TreeViewer newViewer) {
        if (oldViewer != newViewer) {
            this.treeViewer = newViewer;
            if (oldViewer != null) {
                oldViewer.removeTreeListener((ITreeViewerListener)this);
            }
            if (newViewer != null) {
                newViewer.addTreeListener((ITreeViewerListener)this);
            }
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        Object element = event.getElement();
        if (element instanceof IGridContainer && ((IGridContainer)element).isLazy()) {
            IGridContainer container = (IGridContainer)element;
            this.progressNodes.remove(container);
            container.setDirty();
            try {
                container.deleteAll();
            }
            catch (ProblemException pExc) {
                Activator.logException(pExc);
            }
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
    }
}

