/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.providers;

import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobStatus;
import eu.geclipse.ui.providers.ElementManagerLabelProvider;
import java.text.DateFormat;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class JobViewLabelProvider
extends DecoratingLabelProvider
implements ITableLabelProvider {
    ITableLabelProvider tableLabelProvider = (ITableLabelProvider)this.getLabelProvider();

    public JobViewLabelProvider() {
        super(JobViewLabelProvider.createPureLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
    }

    private static ILabelProvider createPureLabelProvider() {
        return new ElementManagerLabelProvider(){

            protected String getColumnText(IGridElement element, int columnIndex) {
                String text = "";
                if (element instanceof IGridJob) {
                    IGridJob job = (IGridJob)element;
                    switch (columnIndex) {
                        case 2: {
                            IGridJobStatus status = job.getJobStatus();
                            if (status == null) break;
                            text = status.getName();
                            break;
                        }
                        case 3: {
                            IGridJobStatus status = job.getJobStatus();
                            if (status == null) break;
                            text = status.getReason();
                            break;
                        }
                        case 4: {
                            if (job.getSubmissionTime() == null) break;
                            text = DateFormat.getDateTimeInstance().format(job.getSubmissionTime());
                            break;
                        }
                        case 5: {
                            if (job.getJobStatus() == null || job.getJobStatus().getLastUpdateTime() == null) break;
                            text = DateFormat.getDateTimeInstance().format(job.getJobStatus().getLastUpdateTime());
                            break;
                        }
                        case 6: {
                            text = job.getID().getJobID();
                        }
                    }
                }
                if (text == null) {
                    text = "";
                }
                return text;
            }
        };
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        if (columnIndex == 0) {
            image = this.getImage(element);
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        text = columnIndex == 0 && element instanceof IGridJob ? ((IGridJob)element).getJobName() : this.tableLabelProvider.getColumnText(element, columnIndex);
        return text;
    }
}

