/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.simpleTest;

import eu.geclipse.core.model.IGridResource;
import eu.geclipse.core.simpleTest.ISimpleTest;
import eu.geclipse.ui.dialogs.AbstractSimpleTestDialog;
import eu.geclipse.ui.simpleTest.Messages;
import eu.geclipse.ui.simpleTest.PortRange;
import eu.geclipse.ui.simpleTest.PortScanJob;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortScanDialog
extends AbstractSimpleTestDialog {
    protected Button port21chk;
    protected Button port22chk;
    protected Button port23chk;
    protected Button port25chk;
    protected Button port80chk;
    protected Button addKnown;
    protected Button addRange;
    protected Button addSpecific;
    protected Button scan;
    protected Button stop;
    protected Button multiThreadButton;
    protected Label wellKnownPortsLbl;
    protected Label rangeLbl;
    protected Label portLbl;
    protected Label specificLbl;
    protected Label portsScannedLabel;
    protected Spinner from;
    protected Spinner to;
    protected Spinner specificTxt;
    protected Label dashlbl;
    protected org.eclipse.swt.widgets.List portList;
    protected TreeMap<Integer, Boolean> portMap;
    protected ArrayList<PortRange> list;
    protected int portsScanned = 0;
    protected int portsOpen = 0;
    protected int portsClosed = 0;
    protected Integer[] ports;
    protected PortScanJob job;
    protected String ip;
    protected boolean port21_entered = false;
    protected boolean port22_entered = false;
    protected boolean port23_entered = false;
    protected boolean port25_entered = false;
    protected boolean port80_entered = false;
    protected ArrayList<PortScanJob> scanJobs = new ArrayList();
    protected StyledText results;
    private Composite mainComp;
    private Composite portComp;
    private Composite resultsComp;
    private Composite listComp;
    private ArrayList<String> hostNames = new ArrayList();
    private ArrayList<TreeItem> treeItem = new ArrayList();

    public PortScanDialog(ISimpleTest test, List<IGridResource> resources, Shell parentShell) {
        super(test, resources, parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setMinimumSize(500, 500);
        newShell.setText(Messages.getString("PortScanDialog.dialogTitle"));
    }

    protected Control createDialogArea(Composite parent) {
        int i = 0;
        while (i < this.resources.size()) {
            this.ip = ((IGridResource)this.resources.get(i)).getHostName();
            if (this.ip != null) {
                this.hostNames.add(this.ip);
            }
            ++i;
        }
        this.list = new ArrayList();
        this.portMap = new TreeMap();
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 4;
        GridData gridData2 = new GridData(64);
        gridData2.horizontalSpan = 3;
        GridData gridData3 = new GridData(256);
        gridData3.horizontalSpan = 4;
        GridData gridData4 = new GridData(128);
        gridData4.horizontalSpan = 3;
        GridData gridData5 = new GridData(32);
        gridData5.horizontalSpan = 2;
        GridData listData = new GridData(64);
        listData.horizontalSpan = 3;
        listData.verticalSpan = 7;
        listData.widthHint = 150;
        listData.heightHint = 150;
        this.mainComp = new Composite(parent, 4);
        this.mainComp.setLayout((Layout)new GridLayout(1, false));
        GridData gData = new GridData(4, 4, true, true);
        this.mainComp.setLayoutData((Object)gData);
        Group settingsGroup = new Group(this.mainComp, 4);
        settingsGroup.setLayout((Layout)new GridLayout(2, false));
        settingsGroup.setText(Messages.getString("PortScanDialog.selectionGroup"));
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        settingsGroup.setLayoutData((Object)gData);
        Group resultsGroup = new Group(this.mainComp, 4);
        resultsGroup.setLayout((Layout)new GridLayout(2, false));
        resultsGroup.setText(Messages.getString("PortScanDialog.resultsGroup"));
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        resultsGroup.setLayoutData((Object)gData);
        this.portComp = new Composite((Composite)settingsGroup, 4);
        this.portComp.setLayout((Layout)new GridLayout(4, false));
        this.wellKnownPortsLbl = new Label(this.portComp, 0);
        this.portLbl = new Label(this.portComp, 0);
        this.portLbl.setLayoutData((Object)gridData2);
        this.portLbl.setText(Messages.getString("PortScanDialog.selectedPortsLbl"));
        this.port21chk = new Button(this.portComp, 32);
        this.portList = new org.eclipse.swt.widgets.List(this.portComp, 2818);
        this.portList.setLayoutData((Object)listData);
        this.port22chk = new Button(this.portComp, 32);
        this.port23chk = new Button(this.portComp, 32);
        this.port25chk = new Button(this.portComp, 32);
        this.port80chk = new Button(this.portComp, 32);
        this.wellKnownPortsLbl.setText(Messages.getString("PortScanDialog.wellKnownPortsLbl"));
        this.port21chk.setText(Messages.getString("PortScanDialog.port21"));
        this.port22chk.setText(Messages.getString("PortScanDialog.port22"));
        this.port23chk.setText(Messages.getString("PortScanDialog.port23"));
        this.port25chk.setText(Messages.getString("PortScanDialog.port25"));
        this.port80chk.setText(Messages.getString("PortScanDialog.port80"));
        this.addKnown = new Button(this.portComp, 26);
        this.addKnown.setText(Messages.getString("PortScanDialog.addSelectedButton"));
        this.addKnown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PortScanDialog.this.port21chk.getSelection() && !PortScanDialog.this.port21_entered) {
                    PortScanDialog.this.port21_entered = true;
                    PortScanDialog.this.portList.add(PortScanDialog.this.port21chk.getText());
                    PortScanDialog.this.list.add(new PortRange(21));
                }
                if (PortScanDialog.this.port22chk.getSelection() && !PortScanDialog.this.port22_entered) {
                    PortScanDialog.this.port22_entered = true;
                    PortScanDialog.this.portList.add(PortScanDialog.this.port22chk.getText());
                    PortScanDialog.this.list.add(new PortRange(22));
                }
                if (PortScanDialog.this.port23chk.getSelection() && !PortScanDialog.this.port23_entered) {
                    PortScanDialog.this.port23_entered = true;
                    PortScanDialog.this.portList.add(PortScanDialog.this.port23chk.getText());
                    PortScanDialog.this.list.add(new PortRange(23));
                }
                if (PortScanDialog.this.port25chk.getSelection() && !PortScanDialog.this.port25_entered) {
                    PortScanDialog.this.port25_entered = true;
                    PortScanDialog.this.portList.add(PortScanDialog.this.port25chk.getText());
                    PortScanDialog.this.list.add(new PortRange(25));
                }
                if (PortScanDialog.this.port80chk.getSelection() && !PortScanDialog.this.port80_entered) {
                    PortScanDialog.this.port80_entered = true;
                    PortScanDialog.this.portList.add(PortScanDialog.this.port80chk.getText());
                    PortScanDialog.this.list.add(new PortRange(80));
                }
            }
        });
        new Label(this.portComp, 256);
        new Label(this.portComp, 256);
        Button removeButton = new Button(this.portComp, 0);
        removeButton.setText(Messages.getString("PortScanDialog.removeButton"));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!PortScanDialog.this.list.isEmpty() && PortScanDialog.this.portList.getFocusIndex() != -1) {
                    if (PortScanDialog.this.list.get(PortScanDialog.this.portList.getSelectionIndex()).getFinish() == 0 && PortScanDialog.this.list.get(PortScanDialog.this.portList.getSelectionIndex()).getStart() == 21) {
                        PortScanDialog.this.port21_entered = false;
                    } else if (PortScanDialog.this.list.get(PortScanDialog.this.portList.getSelectionIndex()).getFinish() == 0 && PortScanDialog.this.list.get(PortScanDialog.this.portList.getSelectionIndex()).getStart() == 22) {
                        PortScanDialog.this.port22_entered = false;
                    } else if (PortScanDialog.this.list.get(PortScanDialog.this.portList.getSelectionIndex()).getFinish() == 0 && PortScanDialog.this.list.get(PortScanDialog.this.portList.getSelectionIndex()).getStart() == 23) {
                        PortScanDialog.this.port23_entered = false;
                    } else if (PortScanDialog.this.list.get(PortScanDialog.this.portList.getSelectionIndex()).getFinish() == 0 && PortScanDialog.this.list.get(PortScanDialog.this.portList.getSelectionIndex()).getStart() == 25) {
                        PortScanDialog.this.port25_entered = false;
                    } else if (PortScanDialog.this.list.get(PortScanDialog.this.portList.getSelectionIndex()).getFinish() == 0 && PortScanDialog.this.list.get(PortScanDialog.this.portList.getSelectionIndex()).getStart() == 80) {
                        PortScanDialog.this.port80_entered = false;
                    }
                    PortScanDialog.this.list.remove(PortScanDialog.this.portList.getSelectionIndex());
                    PortScanDialog.this.portList.remove(PortScanDialog.this.portList.getSelectionIndex());
                }
            }
        });
        Button removeAll = new Button(this.portComp, 0);
        removeAll.setText(Messages.getString("PortScanDialog.removeAllButton"));
        removeAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!PortScanDialog.this.list.isEmpty()) {
                    PortScanDialog.this.port21_entered = false;
                    PortScanDialog.this.port22_entered = false;
                    PortScanDialog.this.port23_entered = false;
                    PortScanDialog.this.port25_entered = false;
                    PortScanDialog.this.port80_entered = false;
                    PortScanDialog.this.list.clear();
                    PortScanDialog.this.portList.removeAll();
                }
            }
        });
        this.listComp = new Composite((Composite)settingsGroup, 4);
        this.listComp.setLayout((Layout)new GridLayout(4, false));
        this.rangeLbl = new Label(this.listComp, 0);
        this.rangeLbl.setText(Messages.getString("PortScanDialog.rangeLbl"));
        this.rangeLbl.setLayoutData((Object)gridData3);
        this.from = new Spinner(this.listComp, 18436);
        this.from.setValues(1, 1, 65535, 0, 1, 65535);
        this.dashlbl = new Label(this.listComp, 0);
        this.dashlbl.setText("-");
        this.to = new Spinner(this.listComp, 18436);
        this.to.setValues(65535, 1, 65535, 0, 1, 65535);
        this.addRange = new Button(this.listComp, 26);
        this.addRange.setText(Messages.getString("PortScanDialog.addRangeButton"));
        this.dashlbl = new Label(this.listComp, 256);
        this.addRange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String toBeAdded = "";
                boolean toExit = false;
                int fromInt = 0;
                int toInt = 0;
                try {
                    fromInt = PortScanDialog.this.from.getSelection();
                    toInt = PortScanDialog.this.to.getSelection();
                }
                catch (NumberFormatException numberFormatException) {
                    toExit = true;
                }
                if (fromInt > toInt || fromInt <= 0 || toInt <= 0 || fromInt > 65535 || toInt > 65535) {
                    toExit = true;
                }
                if (!toExit) {
                    toBeAdded = String.valueOf(PortScanDialog.this.from.getSelection()) + " - " + PortScanDialog.this.to.getSelection();
                    if (PortScanDialog.this.portList.getItemCount() == 0) {
                        PortScanDialog.this.portList.add(toBeAdded);
                        PortScanDialog.this.list.add(new PortRange(PortScanDialog.this.from.getSelection(), PortScanDialog.this.to.getSelection()));
                        toExit = true;
                    }
                } else {
                    return;
                }
                int count = 0;
                int i = 0;
                while (i < PortScanDialog.this.portList.getItemCount()) {
                    if (PortScanDialog.this.portList.getItem(i).compareTo(toBeAdded) == 0) {
                        ++count;
                    }
                    ++i;
                }
                if (count == 0) {
                    PortScanDialog.this.portList.add(toBeAdded);
                    PortScanDialog.this.list.add(new PortRange(PortScanDialog.this.from.getSelection(), PortScanDialog.this.to.getSelection()));
                }
            }
        });
        this.specificLbl = new Label(this.listComp, 0);
        this.specificLbl.setText(Messages.getString("PortScanDialog.addSpecificLbl"));
        this.specificLbl.setLayoutData((Object)gridData3);
        this.specificTxt = new Spinner(this.listComp, 18436);
        this.specificTxt.setLayoutData((Object)gridData5);
        this.specificTxt.setValues(1, 1, 65535, 0, 1, 65535);
        this.addSpecific = new Button(this.listComp, 26);
        this.addSpecific.setText(Messages.getString("PortScanDialog.addPortButton"));
        this.addSpecific.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int portInt = 0;
                int counter = 0;
                portInt = PortScanDialog.this.specificTxt.getSelection();
                int i = 0;
                while (i < PortScanDialog.this.list.size()) {
                    if (PortScanDialog.this.list.get(i).getStart() == portInt && PortScanDialog.this.list.get(i).getFinish() == 0) {
                        ++counter;
                    }
                    ++i;
                }
                if (counter > 0) {
                    return;
                }
                PortScanDialog.this.list.add(new PortRange(portInt, 0));
                PortScanDialog.this.portList.add("" + portInt);
            }
        });
        new Label(this.listComp, 256);
        new Label(this.listComp, 256);
        new Label(this.listComp, 256);
        this.resultsComp = new Composite((Composite)resultsGroup, 0);
        this.resultsComp.setLayout((Layout)new GridLayout(2, false));
        GridData resultsData = new GridData(1808);
        resultsData.horizontalSpan = 3;
        resultsData.verticalSpan = 1;
        resultsData.grabExcessHorizontalSpace = true;
        resultsData.grabExcessVerticalSpace = true;
        resultsData.heightHint = 300;
        resultsGroup.setLayoutData((Object)resultsData);
        this.resultsComp.setLayoutData((Object)resultsData);
        TabFolder tabFolder = new TabFolder(this.resultsComp, 0);
        tabFolder.setLayoutData((Object)resultsData);
        TabItem itemTree = new TabItem(tabFolder, 0);
        itemTree.setText(Messages.getString("PortScanDialog.resultsList"));
        Tree tree = new Tree((Composite)tabFolder, 2816);
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)resultsData);
        TreeColumn hostColumn = new TreeColumn(tree, 16384);
        hostColumn.setText(Messages.getString("PortScanDialog.hostColumn"));
        hostColumn.setWidth(200);
        TreeColumn statusColumn = new TreeColumn(tree, 0x1000000);
        statusColumn.setText(Messages.getString("PortScanDialog.statusColumn"));
        statusColumn.setWidth(70);
        int i2 = 0;
        while (i2 < this.hostNames.size()) {
            this.treeItem.add(new TreeItem(tree, 0));
            this.treeItem.get(i2).setText(new String[]{this.hostNames.get(i2), "N/A"});
            ++i2;
        }
        itemTree.setControl((Control)tree);
        TabItem itemResults = new TabItem(tabFolder, 0);
        itemResults.setText(Messages.getString("PortScanDialog.logItem"));
        this.results = new StyledText((Composite)tabFolder, 768);
        this.results.setLayoutData((Object)resultsData);
        itemResults.setControl((Control)this.results);
        this.scan = new Button(this.resultsComp, 26);
        this.scan.setText(Messages.getString("PortScanDialog.scanButton"));
        this.stop = new Button(this.resultsComp, 512);
        this.stop.setText(Messages.getString("PortScanDialog.stopButton"));
        this.stop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < PortScanDialog.this.scanJobs.size()) {
                    if (PortScanDialog.this.scanJobs.get(i) != null) {
                        PortScanDialog.this.scanJobs.get(i).cancel();
                    }
                    ++i;
                }
                if (PortScanDialog.this.scanJobs.size() > 0) {
                    PortScanDialog.this.results.append("Scanning Stopped.\n\n");
                }
                PortScanDialog.this.scanJobs.clear();
            }
        });
        this.scan.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean done = true;
                for (PortScanJob portJob : PortScanDialog.this.scanJobs) {
                    if (portJob.getResult() != null) continue;
                    done = false;
                }
                if (done) {
                    PortScanDialog.this.scan.setEnabled(false);
                    PortScanDialog.this.generatePortList();
                    PortScanDialog.this.portScan();
                }
                PortScanDialog.this.scan.setEnabled(true);
            }
        });
        return this.mainComp;
    }

    protected void portScan() {
        InetAddress ia = null;
        this.results.setText("");
        this.results.append("Scanning the following hosts:\n");
        int i = 0;
        while (i < this.hostNames.size()) {
            try {
                ia = InetAddress.getByName(this.hostNames.get(i));
                if (ia != null) {
                    this.results.append(String.valueOf(this.hostNames.get(i)) + "\n");
                    this.treeItem.get(i).removeAll();
                    this.job = new PortScanJob(ia, this.portMap, this.results, this.treeItem.get(i));
                    this.job.schedule();
                    this.scanJobs.add(this.job);
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.results.append("Cannot connect to " + this.hostNames.get(i));
            }
            ++i;
        }
        this.results.append("\n");
    }

    protected void generatePortList() {
        int i = 0;
        while (i < this.list.size()) {
            if (this.list.get(i).getFinish() == 0) {
                this.portMap.put(this.list.get(i).getStart(), false);
            } else {
                int j = this.list.get(i).getStart();
                while (j <= this.list.get(i).getFinish()) {
                    this.portMap.put(j, false);
                    ++j;
                }
            }
            ++i;
        }
    }
}

