/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views;

import eu.geclipse.core.ExtensionManager;
import eu.geclipse.core.auth.AuthenticationException;
import eu.geclipse.core.auth.AuthenticationTokenManager;
import eu.geclipse.core.auth.IAuthenticationToken;
import eu.geclipse.core.security.ISecurityManager;
import eu.geclipse.core.security.ISecurityManagerListener;
import eu.geclipse.ui.AbstractAuthTokenUIFactory;
import eu.geclipse.ui.IAuthTokenUIFactory;
import eu.geclipse.ui.UIAuthTokenProvider;
import eu.geclipse.ui.cheatsheets.OpenAuthTokenDialogAction;
import eu.geclipse.ui.comparators.TableColumnComparator;
import eu.geclipse.ui.dialogs.AuthTokenInfoDialog;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.listeners.TableColumnListener;
import eu.geclipse.ui.views.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthTokenView
extends ViewPart
implements ISecurityManagerListener {
    protected Table tokenTable;
    protected CheckboxTableViewer tokenList;
    protected IContributionItem newWizardMenu;
    private Action newAction;
    private Action deleteAction;
    private Action activateAction;
    private Action deactivateAction;
    private Action infoAction;
    private Action refreshAction;
    private IMenuCreator newActionMenuCreator = new IMenuCreator(){
        private MenuManager dropDownMenuMgr;

        private void createDropDownMenuMgr() {
            if (this.dropDownMenuMgr == null) {
                this.dropDownMenuMgr = new MenuManager();
                this.dropDownMenuMgr.add(AuthTokenView.this.newWizardMenu);
            }
        }

        public void dispose() {
            if (this.dropDownMenuMgr != null) {
                this.dropDownMenuMgr.dispose();
                this.dropDownMenuMgr = null;
            }
        }

        public Menu getMenu(Control parent) {
            this.createDropDownMenuMgr();
            return this.dropDownMenuMgr.createContextMenu(parent);
        }

        public Menu getMenu(Menu parent) {
            this.createDropDownMenuMgr();
            Menu menu = new Menu(parent);
            IContributionItem[] items = this.dropDownMenuMgr.getItems();
            int i = 0;
            while (i < items.length) {
                IContributionItem item;
                IContributionItem newItem = item = items[i];
                if (item instanceof ActionContributionItem) {
                    newItem = new ActionContributionItem(((ActionContributionItem)item).getAction());
                }
                newItem.fill(menu, -1);
                ++i;
            }
            return menu;
        }
    };

    public void createPartControl(Composite parent) {
        this.tokenTable = new Table(parent, 65570);
        this.tokenTable.setHeaderVisible(true);
        this.tokenTable.setLinesVisible(true);
        AuthenticationTokenManager manager = AuthenticationTokenManager.getManager();
        this.tokenList = new CheckboxTableViewer(this.tokenTable);
        this.tokenList.setLabelProvider((IBaseLabelProvider)new AuthenticationTokenLabelProvider());
        this.tokenList.setContentProvider((IContentProvider)new AuthenticationTokenContentProvider());
        TableColumnListener columnListener = new TableColumnListener((TableViewer)this.tokenList);
        TableColumn idColumn = new TableColumn(this.tokenTable, 16384);
        idColumn.setText(Messages.getString("AuthTokenView.id_column_label"));
        idColumn.setWidth(300);
        idColumn.setAlignment(16384);
        idColumn.addSelectionListener((SelectionListener)columnListener);
        TableColumn typeColumn = new TableColumn(this.tokenTable, 0x1000000);
        typeColumn.setText(Messages.getString("AuthTokenView.type_column_label"));
        typeColumn.setWidth(150);
        typeColumn.setAlignment(0x1000000);
        typeColumn.addSelectionListener((SelectionListener)columnListener);
        TableColumn stateColumn = new TableColumn(this.tokenTable, 0x1000000);
        stateColumn.setText(Messages.getString("AuthTokenView.state_column_label"));
        stateColumn.setWidth(100);
        stateColumn.setAlignment(0x1000000);
        stateColumn.addSelectionListener((SelectionListener)columnListener);
        TableColumn lifetimeColumn = new TableColumn(this.tokenTable, 0x1000000);
        lifetimeColumn.setText(Messages.getString("AuthTokenView.lifetime_column_label"));
        lifetimeColumn.setWidth(150);
        lifetimeColumn.setAlignment(0x1000000);
        lifetimeColumn.addSelectionListener((SelectionListener)columnListener);
        this.tokenTable.setSortColumn(idColumn);
        this.tokenTable.setSortDirection(128);
        this.tokenList.setComparator((ViewerComparator)new TableColumnComparator(idColumn));
        this.tokenList.setInput((Object)manager);
        IAuthenticationToken defaultToken = manager.getDefaultToken();
        if (defaultToken != null) {
            this.tokenList.setCheckedElements(new Object[]{defaultToken});
        }
        this.tokenList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AuthTokenView.this.updateActions();
            }
        });
        this.tokenList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof IAuthenticationToken) {
                    IAuthenticationToken token = (IAuthenticationToken)element;
                    AuthenticationTokenManager innerManager = AuthenticationTokenManager.getManager();
                    if (!event.getChecked()) {
                        innerManager.setDefaultToken(null);
                    }
                    innerManager.setDefaultToken(token);
                }
            }
        });
        this.tokenList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                AuthTokenView.this.showSelectedTokenInfo();
            }
        });
        this.tokenTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    AuthTokenView.this.removeSelectedTokens();
                }
            }
        });
        manager.addListener((ISecurityManagerListener)this);
        this.createActions();
        this.createToolbar();
        this.createContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.tokenList);
    }

    public void dispose() {
        AuthenticationTokenManager manager = AuthenticationTokenManager.getManager();
        manager.removeListener((ISecurityManagerListener)this);
    }

    public void contentChanged(ISecurityManager manager) {
        Runnable runnable = new Runnable(){

            public void run() {
                AuthTokenView.this.tokenList.refresh();
                AuthenticationTokenManager innerManager = AuthenticationTokenManager.getManager();
                IAuthenticationToken innerDefaultToken = innerManager.getDefaultToken();
                if (innerDefaultToken != null) {
                    AuthTokenView.this.tokenList.setCheckedElements(new Object[]{innerDefaultToken});
                }
                AuthTokenView.this.updateActions();
            }
        };
        this.getViewSite().getShell().getDisplay().syncExec(runnable);
    }

    public void setFocus() {
        this.tokenTable.setFocus();
    }

    public IAuthenticationToken getSelectedToken() {
        IAuthenticationToken resultToken = null;
        IStructuredSelection selection = (IStructuredSelection)this.tokenList.getSelection();
        Object o = selection.getFirstElement();
        if (o instanceof IAuthenticationToken) {
            resultToken = (IAuthenticationToken)o;
        }
        return resultToken;
    }

    public List<IAuthenticationToken> getSelectedTokens() {
        IStructuredSelection selection = (IStructuredSelection)this.tokenList.getSelection();
        List selectionList = selection.toList();
        ArrayList<IAuthenticationToken> result = new ArrayList<IAuthenticationToken>();
        for (Object element : selectionList) {
            if (!(element instanceof IAuthenticationToken)) continue;
            IAuthenticationToken token = (IAuthenticationToken)element;
            result.add(token);
        }
        return result;
    }

    protected void setSelectedTokenActive(final boolean active) {
        final IAuthenticationToken token = this.getSelectedToken();
        if (active == token.isActive()) {
            return;
        }
        ProgressMonitorDialog progMon = new ProgressMonitorDialog(this.getSite().getShell());
        Throwable exc = null;
        try {
            progMon.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        token.setActive(active, monitor);
                    }
                    catch (AuthenticationException authExc) {
                        throw new InvocationTargetException(authExc);
                    }
                }
            });
        }
        catch (InvocationTargetException itExc) {
            exc = itExc.getCause();
        }
        catch (InterruptedException intExc) {
            exc = intExc;
        }
        if (exc != null) {
            String errMsg = active ? Messages.getString("AuthTokenView.token_activation_error") : Messages.getString("AuthTokenView.token_deactivation_error");
            ProblemDialog.openProblem(this.getSite().getShell(), Messages.getString("AuthTokenView.token_activation_error_title"), errMsg, exc);
        }
    }

    protected void removeSelectedTokens() {
        List<IAuthenticationToken> tokens = this.getSelectedTokens();
        if (!tokens.isEmpty()) {
            boolean confirm;
            boolean bl = confirm = !MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)Messages.getString("AuthTokenView.confirm_delete_title"), (String)Messages.getString("AuthTokenView.confirm_delete_message"));
            if (!confirm) {
                AuthenticationTokenManager manager = AuthenticationTokenManager.getManager();
                for (IAuthenticationToken token : tokens) {
                    try {
                        manager.destroyToken(token);
                    }
                    catch (AuthenticationException authExc) {
                        Activator.logException(authExc);
                    }
                }
                this.updateActions();
            }
        }
    }

    protected void showSelectedTokenInfo() {
        IAuthTokenUIFactory factory;
        IAuthenticationToken token = this.getSelectedToken();
        if (token != null && (factory = AbstractAuthTokenUIFactory.findFactory(token)) != null) {
            AuthTokenInfoDialog infoDialog = factory.getInfoDialog(token, this.getSite().getShell());
            infoDialog.open();
        }
    }

    protected void updateActions() {
        IAuthenticationToken token = this.getSelectedToken();
        boolean selected = token != null;
        this.newAction.setEnabled(true);
        this.deleteAction.setEnabled(selected);
        this.activateAction.setEnabled(selected && !token.isActive());
        this.deactivateAction.setEnabled(selected && token.isActive());
        this.infoAction.setEnabled(selected);
        this.refreshAction.setEnabled(true);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        if (this.newAction.isEnabled()) {
            mgr.add((IAction)this.newAction);
        }
        if (this.deleteAction.isEnabled() || this.activateAction.isEnabled() || this.deactivateAction.isEnabled() || this.infoAction.isEnabled() || this.refreshAction.isEnabled()) {
            mgr.add((IContributionItem)new Separator());
            if (this.deleteAction.isEnabled()) {
                mgr.add((IAction)this.deleteAction);
            }
            if (this.activateAction.isEnabled()) {
                mgr.add((IAction)this.activateAction);
            }
            if (this.deactivateAction.isEnabled()) {
                mgr.add((IAction)this.deactivateAction);
            }
            if (this.infoAction.isEnabled()) {
                mgr.add((IAction)this.infoAction);
            }
            if (this.deleteAction.isEnabled() || this.activateAction.isEnabled() || this.deactivateAction.isEnabled() || this.infoAction.isEnabled()) {
                mgr.add((IContributionItem)new Separator());
            }
            if (this.refreshAction.isEnabled()) {
                mgr.add((IAction)this.refreshAction);
            }
        }
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    private void createActions() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ImageRegistry imgReg = Activator.getDefault().getImageRegistry();
        ImageDescriptor newImage = sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD");
        ImageDescriptor deleteImage = sharedImages.getImageDescriptor("IMG_TOOL_DELETE");
        Image image = imgReg.get("activestate");
        ImageDescriptor activateImage = ImageDescriptor.createFromImage((Image)image);
        image = imgReg.get("inactivestate");
        ImageDescriptor deactivateImage = ImageDescriptor.createFromImage((Image)image);
        ImageDescriptor infoImage = sharedImages.getImageDescriptor("IMG_OBJS_INFO_TSK");
        image = imgReg.get("refresh");
        ImageDescriptor refreshImage = ImageDescriptor.createFromImage((Image)image);
        this.infoAction = new Action(){

            public void run() {
                AuthTokenView.this.showSelectedTokenInfo();
            }
        };
        this.infoAction.setText(Messages.getString("AuthTokenView.info_text"));
        this.infoAction.setToolTipText(Messages.getString("AuthTokenView.info_tooltip"));
        this.infoAction.setImageDescriptor(infoImage);
        this.refreshAction = new Action(){

            public void run() {
                AuthenticationTokenManager innerManager = AuthenticationTokenManager.getManager();
                AuthTokenView.this.tokenList.refresh();
                IAuthenticationToken innerDefaultToken = innerManager.getDefaultToken();
                if (innerDefaultToken != null) {
                    AuthTokenView.this.tokenList.setCheckedElements(new Object[]{innerDefaultToken});
                }
            }
        };
        this.refreshAction.setText(Messages.getString("AuthTokenView.refresh_text"));
        this.refreshAction.setToolTipText(Messages.getString("AuthTokenView.refresh_tooltip"));
        this.refreshAction.setImageDescriptor(refreshImage);
        this.deleteAction = new Action(){

            public void run() {
                AuthTokenView.this.removeSelectedTokens();
            }
        };
        this.deleteAction.setText(Messages.getString("AuthTokenView.delete_text"));
        this.deleteAction.setToolTipText(Messages.getString("AuthTokenView.delete_tooltip"));
        this.deleteAction.setImageDescriptor(deleteImage);
        this.activateAction = new Action(){

            public void run() {
                AuthTokenView.this.setSelectedTokenActive(true);
            }
        };
        this.activateAction.setText(Messages.getString("AuthTokenView.activate_text"));
        this.activateAction.setToolTipText(Messages.getString("AuthTokenView.activate_tooltip"));
        this.activateAction.setImageDescriptor(activateImage);
        this.deactivateAction = new Action(){

            public void run() {
                AuthTokenView.this.setSelectedTokenActive(false);
            }
        };
        this.deactivateAction.setText(Messages.getString("AuthTokenView.deactivate_text"));
        this.deactivateAction.setToolTipText(Messages.getString("AuthTokenView.deactivate_tooltip"));
        this.deactivateAction.setImageDescriptor(deactivateImage);
        this.newAction = new OpenAuthTokenDialogAction();
        this.newAction.setText(Messages.getString("AuthTokenView.create_text"));
        this.newAction.setToolTipText(Messages.getString("AuthTokenView.create_tooltip"));
        this.newAction.setImageDescriptor(newImage);
        this.newAction.setMenuCreator(this.newActionMenuCreator);
        this.newWizardMenu = new CompoundContributionItem(){

            protected IContributionItem[] getContributionItems() {
                LinkedList<ActionContributionItem> itemList = new LinkedList<ActionContributionItem>();
                ExtensionManager manager = new ExtensionManager();
                List cElements = manager.getConfigurationElements("eu.geclipse.core.authTokens", "token");
                for (IConfigurationElement element : cElements) {
                    String name = element.getAttribute("name");
                    final String wizardId = element.getAttribute("wizard");
                    if (name == null || wizardId == null) continue;
                    Action action = new Action(){

                        public void run() {
                            UIAuthTokenProvider tokenProvider = new UIAuthTokenProvider(AuthTokenView.this.getSite().getShell());
                            tokenProvider.showNewTokenWizard(wizardId, true, null);
                        }
                    };
                    action.setText(name);
                    itemList.add(new ActionContributionItem((IAction)action));
                }
                return itemList.toArray(new IContributionItem[0]);
            }
        };
        this.updateActions();
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.newAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.deleteAction);
        mgr.add((IAction)this.activateAction);
        mgr.add((IAction)this.deactivateAction);
        mgr.add((IAction)this.infoAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.refreshAction);
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AuthTokenView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = manager.createContextMenu((Control)this.tokenTable);
        this.tokenTable.setMenu(menu);
        this.getSite().registerContextMenu(manager, this.getSite().getSelectionProvider());
    }

    public static class AuthenticationTokenContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object input) {
            Object[] resultArray = null;
            if (input instanceof AuthenticationTokenManager) {
                List tokens = ((AuthenticationTokenManager)input).getTokens();
                IAuthenticationToken[] tokenArray = new IAuthenticationToken[tokens.size()];
                resultArray = tokens.toArray(tokenArray);
            }
            return resultArray;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    public static class AuthenticationTokenLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider {
        private Font boldFont;

        public AuthenticationTokenLabelProvider() {
            Font font = JFaceResources.getDefaultFont();
            Device device = font.getDevice();
            FontData[] fontData = font.getFontData();
            int i = 0;
            while (i < fontData.length) {
                int style = fontData[i].getStyle();
                fontData[i].setStyle(style | 1);
                ++i;
            }
            this.boldFont = new Font(device, fontData);
        }

        public void dispose() {
            super.dispose();
            this.boldFont.dispose();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String columnText = element.toString();
            if (element instanceof IAuthenticationToken) {
                IAuthenticationToken token = (IAuthenticationToken)element;
                switch (columnIndex) {
                    case 0: {
                        columnText = token.getID();
                        break;
                    }
                    case 1: {
                        columnText = token.getDescription().getTokenTypeName();
                        break;
                    }
                    case 2: {
                        columnText = token.isActive() ? Messages.getString("AuthTokenView.token_active") : Messages.getString("AuthTokenView.token_inactive");
                        break;
                    }
                    case 3: {
                        if (!token.isActive()) {
                            columnText = "";
                            break;
                        }
                        long lifetime = token.getTimeLeft();
                        if (lifetime < 0L) {
                            columnText = Messages.getString("AuthTokenView.lifetime_infinite");
                            break;
                        }
                        if (lifetime == 0L) {
                            columnText = Messages.getString("AuthTokenView.lifetime_expired");
                            break;
                        }
                        int days = (int)(lifetime / 86400L);
                        int hours = (int)(lifetime % 86400L / 3600L);
                        int minutes = (int)(lifetime % 3600L / 60L);
                        int seconds = (int)(lifetime % 60L);
                        columnText = String.format("%1$3dd %2$02dh %3$02dm %4$02ds", days, hours, minutes, seconds);
                    }
                }
            }
            return columnText;
        }

        public Font getFont(Object element, int columnIndex) {
            IAuthenticationToken token;
            Font resultFont = null;
            if (element instanceof IAuthenticationToken && (token = (IAuthenticationToken)element).isActive()) {
                resultFont = this.boldFont;
            }
            return resultFont;
        }
    }
}

