/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views;

import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementManager;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.ui.internal.actions.ActionGroupManager;
import eu.geclipse.ui.internal.actions.ViewModeActions;
import eu.geclipse.ui.providers.ConfigurableContentProvider;
import eu.geclipse.ui.providers.GridModelLabelProvider;
import eu.geclipse.ui.providers.IConfigurationListener;
import eu.geclipse.ui.views.Messages;
import eu.geclipse.ui.views.TreeControlViewPart;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public abstract class ElementManagerViewPart
extends TreeControlViewPart
implements IGridModelListener {
    TreeColumn projectColumn;

    protected ElementManagerViewPart() {
        IGridElementManager manager = this.getManager();
        manager.addGridModelListener((IGridModelListener)this);
    }

    public void dispose() {
        IGridElementManager manager = this.getManager();
        manager.removeGridModelListener((IGridModelListener)this);
        super.dispose();
    }

    protected void contributeAdditionalActions(ActionGroupManager groups) {
        ViewModeActions group = new ViewModeActions(this);
        groups.addGroup(group);
    }

    protected abstract IGridElementManager getManager();

    protected IGridElement getRootElement() {
        return this.getManager();
    }

    protected ConfigurableContentProvider createConfigurableContentProvider() {
        ConfigurableContentProvider provider = new ConfigurableContentProvider();
        return provider;
    }

    protected IContentProvider createContentProvider() {
        ConfigurableContentProvider provider = this.createConfigurableContentProvider();
        provider.addConfigurationListener(new IConfigurationListener(){
            private int lastWidth = 100;

            public void configurationChanged(ConfigurableContentProvider source) {
                if (ElementManagerViewPart.this.projectColumn != null) {
                    int mode = source.getMode();
                    if (mode == 1) {
                        ElementManagerViewPart.this.projectColumn.setWidth(this.lastWidth);
                    } else {
                        this.lastWidth = ElementManagerViewPart.this.projectColumn.getWidth();
                        ElementManagerViewPart.this.projectColumn.setWidth(0);
                    }
                }
            }
        });
        return provider;
    }

    protected IBaseLabelProvider createLabelProvider() {
        return new GridModelLabelProvider();
    }

    protected boolean createTreeColumns(Tree tree) {
        super.createTreeColumns(tree);
        TreeColumn nameColumn = new TreeColumn(tree, 0);
        nameColumn.setText(Messages.getString("ElementManagerViewPart.name_column"));
        nameColumn.setAlignment(16384);
        nameColumn.setWidth(300);
        this.projectColumn = new TreeColumn(tree, 0);
        this.projectColumn.setText(Messages.getString("ElementManagerViewPart.project_column"));
        this.projectColumn.setAlignment(16384);
        this.projectColumn.setWidth(100);
        return true;
    }

    public boolean isDragSource(IGridElement element) {
        return super.isDragSource(element) && this.getManager().canManage(element);
    }
}

