/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views.filters;

import eu.geclipse.ui.views.filters.IGridFilter;
import eu.geclipse.ui.views.filters.IGridFilterConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGridFilterConfiguration
implements IGridFilterConfiguration {
    private static final String MEMENTO_KEY_ENABLED = "Enabled";
    private static final String MEMENTO_KEY_TYPE = "Filter";
    protected ArrayList<IGridFilter> filtersList = new ArrayList();
    private String name;
    private boolean enabled = false;

    public AbstractGridFilterConfiguration(String name) {
        this.name = name;
    }

    @Override
    public IGridFilterConfiguration clone() throws CloneNotSupportedException {
        AbstractGridFilterConfiguration newConfiguration = (AbstractGridFilterConfiguration)super.clone();
        newConfiguration.filtersList = new ArrayList();
        for (IGridFilter filter : this.filtersList) {
            newConfiguration.filtersList.add(filter.makeClone());
        }
        return newConfiguration;
    }

    @Override
    public void read(IMemento configurationMemento) {
        Integer integer = configurationMemento.getInteger(MEMENTO_KEY_ENABLED);
        if (integer != null) {
            this.enabled = integer != 0;
        }
        IMemento[] iMementoArray = configurationMemento.getChildren(MEMENTO_KEY_TYPE);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento filterMemento = iMementoArray[n2];
            IGridFilter filter = this.findFilter(filterMemento.getID());
            if (filter != null) {
                filter.readState(filterMemento);
            }
            ++n2;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public List<IGridFilter> getFilters() {
        return this.filtersList;
    }

    @Override
    public void saveState(IMemento memento) {
        memento.putInteger(MEMENTO_KEY_ENABLED, this.enabled ? 1 : 0);
        for (IGridFilter filter : this.filtersList) {
            IMemento filterMemento = memento.createChild(MEMENTO_KEY_TYPE, filter.getFilterId());
            filter.saveState(filterMemento);
        }
    }

    protected void addFilter(IGridFilter filter) {
        this.filtersList.add(filter);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected IGridFilter findFilter(String id) {
        IGridFilter filter = null;
        Iterator<IGridFilter> iterator = this.filtersList.iterator();
        while (iterator.hasNext() && filter == null) {
            IGridFilter currentFilter = iterator.next();
            if (!currentFilter.getFilterId().equals(id)) continue;
            filter = currentFilter;
        }
        return filter;
    }
}

