/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views.jobdetails;

import eu.geclipse.core.model.IGridJob;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.views.jobdetails.IJobDetail;
import eu.geclipse.ui.views.jobdetails.IJobDetailsSection;
import eu.geclipse.ui.views.jobdetails.JobTextDetail;
import eu.geclipse.ui.views.jobdetails.Messages;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.ide.IDE;

public abstract class JobComplexDetail
extends JobTextDetail {
    private static Image image;
    String editorId;
    private Button button;
    private Composite composite;

    public JobComplexDetail(IJobDetailsSection section, String name, String editorId) {
        super(section, name);
        this.editorId = editorId;
    }

    protected void createWidgets(Composite parent, FormToolkit formToolkit) {
        super.createWidgets(parent, formToolkit);
        this.composite = formToolkit.createComposite(parent);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        this.composite.setLayoutData((Object)gridData);
        this.getDetailText().setParent(this.composite);
        GridData layoutData = (GridData)this.getDetailText().getLayoutData();
        layoutData.heightHint = 40;
        this.button = this.createButton(this.composite, formToolkit);
    }

    public void dispose() {
        this.dispose((Widget)this.button);
        this.dispose((Widget)this.composite);
        this.button = null;
        this.composite = null;
        super.dispose();
    }

    private Button createButton(Composite parent, FormToolkit formToolkit) {
        Button createdButton = formToolkit.createButton(parent, null, 0);
        createdButton.setImage(this.getButtonImage());
        createdButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    String value;
                    IGridJob inputJob = JobComplexDetail.this.getInputJob();
                    if (inputJob != null && (value = JobComplexDetail.this.getComplexValue(inputJob)) != null) {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)JobComplexDetail.this.createEditorInput(inputJob, value), (String)JobComplexDetail.this.getEditorId());
                    }
                }
                catch (PartInitException exception) {
                    Activator.logException(exception);
                }
            }
        });
        return createdButton;
    }

    protected String getComplexValue(IGridJob inputJob) {
        return this.getValue(inputJob);
    }

    protected IEditorInput createEditorInput(IGridJob inputJob, String value) {
        return new EditorInput(inputJob, this.getName(), value);
    }

    protected void setVisible(boolean visible) {
        this.setVisible((Control)this.composite, visible);
        this.setVisible((Control)this.button, visible);
        super.setVisible(visible);
    }

    public void reuseWidgets(IJobDetail oldDetail) {
        JobComplexDetail detail = (JobComplexDetail)oldDetail;
        this.composite = detail.composite;
        this.button = detail.button;
        super.reuseWidgets(oldDetail);
    }

    private Image getButtonImage() {
        if (image == null) {
            ImageDescriptor imageDescriptor = Activator.getDefault().getImageRegistry().getDescriptor("See");
            image = imageDescriptor.createImage();
        }
        return image;
    }

    protected String getEditorId() {
        return this.editorId;
    }

    private class EditorInput
    implements IStorageEditorInput {
        private IGridJob inputJob;
        private String detailName;
        private String detailValue;
        private IStorage storage;

        EditorInput(IGridJob inputJob, String detailName, String detailValue) {
            this.detailName = detailName;
            this.inputJob = inputJob;
            this.detailValue = detailValue;
        }

        public boolean equals(Object obj) {
            boolean equals = false;
            if (obj instanceof EditorInput) {
                EditorInput otherInput = (EditorInput)obj;
                equals = otherInput.inputJob == this.inputJob && otherInput.detailName.equals(this.detailName);
            }
            return equals;
        }

        public IStorage getStorage() throws CoreException {
            if (this.storage == null) {
                this.storage = this.createStorage(this.detailValue);
            }
            return this.storage;
        }

        public boolean exists() {
            return false;
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.getMissingImageDescriptor();
        }

        public String getName() {
            return this.detailName;
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return String.format(Messages.JobEditedDetail_editorNameFormat, JobComplexDetail.this.getName(), this.inputJob.getName());
        }

        public Object getAdapter(Class adapter) {
            IStorage adaptableObject = null;
            if (adapter.isAssignableFrom(IStorage.class)) {
                adaptableObject = this.storage;
            }
            return adaptableObject;
        }

        private IStorage createStorage(final String string) {
            return new IStorage(){

                public InputStream getContents() throws CoreException {
                    return new ByteArrayInputStream(string.getBytes());
                }

                public IPath getFullPath() {
                    return null;
                }

                public String getName() {
                    return null;
                }

                public boolean isReadOnly() {
                    return true;
                }

                public Object getAdapter(Class adapter) {
                    return null;
                }
            };
        }
    }
}

