/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views.jobdetails;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobStatusListener;
import eu.geclipse.ui.internal.actions.JobDetailsViewActions;
import eu.geclipse.ui.views.jobdetails.IViewConfiguration;
import eu.geclipse.ui.views.jobdetails.JobDetailSectionsManager;
import eu.geclipse.ui.views.jobdetails.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class JobDetailsView
extends ViewPart
implements ISelectionListener,
IViewConfiguration,
IGridJobStatusListener {
    public static final String ID = "eu.geclipse.ui.views.jobdetails.JobDetailsView";
    private ScrolledForm topScrolledForm;
    private FormToolkit formToolkit;
    private JobDetailSectionsManager sectionsManager;
    private IMemento memento;
    private JobDetailsViewActions actions;
    private JobSelectionProvider jobSelectionProvider;
    private Label emptyJobDescription;
    private IGridJob inputJob;

    public FormToolkit getFormToolkit() {
        if (this.formToolkit == null) {
            this.formToolkit = new FormToolkit(Display.getCurrent());
        }
        return this.formToolkit;
    }

    public void createPartControl(Composite parent) {
        this.fillActionBars();
        this.fillContextMenu();
        this.readState();
        this.topScrolledForm = this.getFormToolkit().createScrolledForm(parent);
        this.topScrolledForm.getBody().setFont(this.topScrolledForm.getBody().getFont());
        this.topScrolledForm.getBody().setLayout((Layout)new GridLayout(2, false));
        this.topScrolledForm.setBackground(this.getFormToolkit().getColors().getBackground());
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.setInputJob(this.findSelectedJob());
        GridModel.getJobManager().addJobStatusListener((IGridJobStatusListener)this);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        GridModel.getJobManager().removeJobStatusListener((IGridJobStatusListener)this);
        super.dispose();
    }

    public void setFocus() {
        this.topScrolledForm.setFocus();
    }

    protected void setInputJob(IGridJob gridJob) {
        this.inputJob = gridJob;
        this.refresh();
        this.getJobSelectionProvider().fireSelectionChanged();
    }

    public void refresh() {
        this.refreshEmptyJobDescription();
        this.getSectionsManager().refresh(this.inputJob);
        this.topScrolledForm.reflow(true);
    }

    private IGridJob findSelectedJob() {
        Object selectedObj;
        IGridJob selectedJob = null;
        ISelection selection = this.getSite().getPage().getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (selectedObj = ((IStructuredSelection)selection).getFirstElement()) != null && selectedObj instanceof IGridJob) {
            selectedJob = (IGridJob)selectedObj;
        }
        return selectedJob;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object selectedObject;
        IStructuredSelection structuredSelection;
        if (selection != null && selection instanceof IStructuredSelection && !(structuredSelection = (IStructuredSelection)selection).isEmpty() && (selectedObject = structuredSelection.getFirstElement()) instanceof IGridJob) {
            IGridJob selectedJob = (IGridJob)selectedObject;
            this.setInputJob(selectedJob);
        }
    }

    public boolean isShowEmptyEnabled() {
        return this.getActions().isShowEmptyEnabled();
    }

    public JobDetailSectionsManager getSectionsManager() {
        if (this.sectionsManager == null) {
            this.sectionsManager = new JobDetailSectionsManager(this.topScrolledForm.getBody(), this);
        }
        return this.sectionsManager;
    }

    public void init(IViewSite site, IMemento currentMemento) throws PartInitException {
        this.memento = currentMemento;
        super.init(site, currentMemento);
    }

    private void readState() {
        if (this.memento != null) {
            this.getActions().readState(this.memento);
        }
    }

    public void saveState(IMemento currentMemento) {
        super.saveState(currentMemento);
        this.getActions().saveState(currentMemento);
    }

    private void scheduleRefresh() {
        Display display;
        Shell shell;
        IWorkbenchPartSite site = this.getSite();
        if (site != null && (shell = site.getShell()) != null && (display = shell.getDisplay()) != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    JobDetailsView.this.refresh();
                }
            });
        }
    }

    public void statusChanged(IGridJob job) {
    }

    public void statusUpdated(IGridJob job) {
        if (this.inputJob == job) {
            this.scheduleRefresh();
        }
    }

    private JobDetailsViewActions getActions() {
        if (this.actions == null) {
            this.actions = new JobDetailsViewActions(this);
        }
        return this.actions;
    }

    private void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.getActions().fillActionBars(actionBars);
    }

    private void fillContextMenu() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        this.getActions().fillContextMenu(manager);
    }

    public JobSelectionProvider getJobSelectionProvider() {
        if (this.jobSelectionProvider == null) {
            this.jobSelectionProvider = new JobSelectionProvider();
        }
        return this.jobSelectionProvider;
    }

    private void refreshEmptyJobDescription() {
        if (this.inputJob == null) {
            if (this.emptyJobDescription == null) {
                this.emptyJobDescription = this.getFormToolkit().createLabel(this.topScrolledForm.getBody(), Messages.JobDetailsView_emptyJobDescription);
            }
        } else if (this.emptyJobDescription != null) {
            this.emptyJobDescription.dispose();
            this.emptyJobDescription = null;
        }
    }

    public IGridJob getInputJob() {
        return this.inputJob;
    }

    public class JobSelectionProvider
    implements ISelectionProvider {
        private List<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (!this.selectionChangedListeners.contains(listener)) {
                this.selectionChangedListeners.add(listener);
            }
        }

        public ISelection getSelection() {
            return JobDetailsView.this.getInputJob() == null ? new StructuredSelection() : new StructuredSelection((Object)JobDetailsView.this.getInputJob());
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
        }

        void fireSelectionChanged() {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            for (ISelectionChangedListener listener : this.selectionChangedListeners) {
                listener.selectionChanged(event);
            }
        }
    }
}

