/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.visualisation;

import eu.geclipse.core.model.IGridVisualisation;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.views.VisualisationView;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionListenerAction;

public class AbstractVisualisationAction
extends SelectionListenerAction {
    public static final String ACTION_EXTENSION_POINT = "eu.geclipse.ui.visualisationAction";
    public static final String EXT_ACTION_CLASS = "class";
    public static final String EXT_ACTION_ELEMENT = "action";
    public static final String EXT_ACTION_TEXT = "text";
    public static final String EXT_ACTION_TOOLTIP = "tooltip";
    public static final String EXT_ACTION_FILE_EXTENSION = "fileExtension";
    public static final String EXT_ACTION_TYPE = "type";
    protected IWorkbenchSite workbenchSite;
    private String type = null;
    private String fileExt = null;
    private ArrayList<IGridVisualisation> vis;

    public AbstractVisualisationAction() {
        super(Messages.getString("AbstractVisualisationAction.title"));
    }

    public void init(String actionText, String actionTooltip, String fileExtension, IWorkbenchSite site, String visType) {
        super.setText(actionText);
        super.setToolTipText(actionTooltip);
        this.fileExt = fileExtension;
        this.workbenchSite = site;
        this.type = visType;
    }

    protected boolean isVisualizable(Object element) {
        return element instanceof IGridVisualisation;
    }

    public void run() {
        Object element = this.getStructuredSelection().getFirstElement();
        if (element != null) {
            try {
                ((IGridVisualisation)element).validate();
                IViewPart view = this.workbenchSite.getPage().showView("eu.geclipse.ui.views.visualisationview");
                ((VisualisationView)view).setVisResource((IGridVisualisation)element);
                ((VisualisationView)view).render(((IGridVisualisation)element).getResourceFileNameExtension(), this.type);
                if (((VisualisationView)view).isSuccess()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            try {
                                AbstractVisualisationAction.this.workbenchSite.getPage().showView("eu.geclipse.ui.views.visualisationview");
                            }
                            catch (PartInitException e) {
                                Activator.logException(e);
                            }
                        }
                    });
                }
            }
            catch (PartInitException pie) {
                ProblemDialog.openProblem(null, Messages.getString("AbstractVisualisationAction.errorDialogTitle"), Messages.getString("AbstractVisualisationAction.errorOpeningView"), pie);
            }
            catch (ProblemException pe) {
                ProblemDialog.openProblem(null, Messages.getString("AbstractVisualisationAction.errorDialogTitle"), Messages.getString("AbstractVisualisationAction.elementNotVisualizable"), pe);
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.vis = new ArrayList();
        boolean enabled = super.updateSelection(selection);
        Iterator iter = selection.iterator();
        while (iter.hasNext() && enabled) {
            Object element = iter.next();
            boolean isVisualizableFile = this.isVisualizable(element);
            enabled &= isVisualizableFile;
            if (!isVisualizableFile) continue;
            this.vis.add((IGridVisualisation)element);
        }
        return enabled && !this.vis.isEmpty();
    }

    public String getFileExt() {
        return this.fileExt;
    }
}

