/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.widgets;

import eu.geclipse.core.reporting.IProblem;
import eu.geclipse.core.reporting.ISolution;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.widgets.Messages;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DateTimeText {
    private static Image image;
    protected Style style;
    protected Button calendarButton;
    private Text text;
    private Composite topComposite;
    private boolean allowEmpty;

    public DateTimeText(Composite parent, Style style, boolean allowEmpty) {
        this.style = style;
        this.allowEmpty = allowEmpty;
        this.topComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.topComposite.setLayout((Layout)layout);
        this.createText(this.topComposite);
        this.createButton(this.topComposite);
    }

    public void setDate(Date date) {
        String valueString = "";
        if (date != null) {
            valueString = this.getFormatter(this.style).format(date);
        }
        this.text.setText(valueString);
    }

    public Date getDate() throws ProblemException {
        Date date = null;
        try {
            date = this.internalGetDate();
        }
        catch (ParseException exception) {
            ProblemException problemExc = new ProblemException("eu.geclipse.problem.widget.DateTimeText.WrongFormat", (Throwable)exception, "eu.geclipse.ui");
            IProblem problem = problemExc.getProblem();
            problem.addSolution(this.createUseCalendarSolution());
            problem.addSolution("eu.geclipse.solution.widget.DateTimeText.UseCorrectFormat", String.format(Messages.getString("DateTimeText.solutionEnterDateInCorrectFormat"), this.getValidDateFormat()));
            if (this.allowEmpty) {
                problem.addSolution("eu.geclipse.solution.widget.DateTimeText.DeleteValue", null);
            }
            throw problemExc;
        }
        return date;
    }

    public String getValidDateFormat() {
        String validFormat = null;
        try {
            validFormat = ((SimpleDateFormat)this.getFormatter(this.style)).toLocalizedPattern();
        }
        catch (ClassCastException classCastException) {}
        return validFormat;
    }

    private DateFormat getFormatter(Style forStyle) {
        DateFormat formatter = null;
        switch (forStyle) {
            case DATE: {
                formatter = DateFormat.getDateInstance();
                break;
            }
            default: {
                formatter = DateFormat.getDateTimeInstance();
            }
        }
        formatter.setLenient(true);
        return formatter;
    }

    private void createText(Composite parent) {
        this.text = new Text(parent, 2052);
        GridData gridData = new GridData();
        gridData.widthHint = this.getWidthHint();
        this.text.setLayoutData((Object)gridData);
    }

    private int getWidthHint() {
        int width = -1;
        switch (this.style) {
            case DATE: {
                width = -1;
                break;
            }
            default: {
                width = 110;
            }
        }
        return width;
    }

    private Date internalGetDate() throws ParseException {
        Date date;
        block3: {
            date = null;
            DateFormat formatter = this.getFormatter(this.style);
            String dateString = this.text.getText();
            if (!this.allowEmpty || dateString.length() > 0) {
                try {
                    date = formatter.parse(dateString);
                }
                catch (ParseException exception) {
                    date = this.parseOtherFormats(dateString);
                    if (date != null) break block3;
                    throw exception;
                }
            }
        }
        return date;
    }

    private Date parseOtherFormats(String dateString) {
        Date date = null;
        DateFormat[] formatters = new DateFormat[]{DateFormat.getDateTimeInstance(2, 2), DateFormat.getDateTimeInstance(2, 3), DateFormat.getDateInstance()};
        int index = 0;
        while (index < formatters.length && date == null) {
            try {
                date = formatters[index].parse(dateString);
            }
            catch (ParseException parseException) {}
            ++index;
        }
        return date;
    }

    private void createButton(Composite parent) {
        this.calendarButton = new Button(parent, 8);
        this.calendarButton.setImage(this.getImage());
        this.calendarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeText.this.openCalendarDialog();
            }
        });
    }

    private Image getImage() {
        if (image == null) {
            ImageDescriptor imageDescriptor = Activator.getDefault().getImageRegistry().getDescriptor("calendar");
            image = imageDescriptor.createImage();
        }
        return image;
    }

    public Shell getShell() {
        return this.topComposite.getShell();
    }

    public void openCalendarDialog() {
        DateTimeDialog dialog = new DateTimeDialog(this.getShell());
        dialog.open();
    }

    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
        this.calendarButton.setEnabled(enabled);
    }

    public boolean setFocus() {
        return this.text.setFocus();
    }

    private ISolution createUseCalendarSolution() {
        return new ISolution(){

            public String getDescription() {
                return Messages.getString("DateTimeText.solutionUseButton");
            }

            public String getID() {
                return null;
            }

            public boolean isActive() {
                return true;
            }

            public void solve() throws InvocationTargetException {
                DateTimeText.this.openCalendarDialog();
            }
        };
    }

    private class DateTimeDialog
    extends PopupDialog {
        private DateTime dateControl;
        private DateTime timeControl;

        protected DateTimeDialog(Shell parentShell) {
            super(parentShell, 4, true, false, false, false, null, null);
        }

        private void setDate(Date date) {
            if (date != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                this.dateControl.setYear(calendar.get(1));
                this.dateControl.setMonth(calendar.get(2));
                this.dateControl.setDay(calendar.get(5));
                if (this.timeControl != null) {
                    this.timeControl.setHours(calendar.get(11));
                    this.timeControl.setMinutes(calendar.get(12));
                    this.timeControl.setSeconds(calendar.get(13));
                }
            }
        }

        private Date getDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(this.dateControl.getYear(), this.dateControl.getMonth(), this.dateControl.getDay(), this.timeControl == null ? 0 : this.timeControl.getHours(), this.timeControl == null ? 0 : this.timeControl.getMinutes(), this.timeControl == null ? 0 : this.timeControl.getSeconds());
            return calendar.getTime();
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, true));
            this.createCalendar(composite);
            if (DateTimeText.this.style == Style.DATETIME) {
                this.createHour(composite);
            }
            this.createButtons(composite);
            try {
                this.setDate(DateTimeText.this.getDate());
            }
            catch (ProblemException problemException) {}
            return composite;
        }

        private void createButtons(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite.setLayout((Layout)layout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 131072;
            gridData.horizontalSpan = 2;
            composite.setLayoutData((Object)gridData);
            this.createOkButton(composite);
            this.createCancelButton(composite);
        }

        private void createCalendar(Composite parent) {
            this.dateControl = new DateTime(parent, 1024);
            GridData layoutData = new GridData();
            layoutData.horizontalSpan = 2;
            this.dateControl.setLayoutData((Object)layoutData);
        }

        private void createHour(Composite parent) {
            Label label = new Label(parent, 0);
            label.setText(Messages.getString("DateTimeText.labelHour"));
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 0x1000008;
            label.setLayoutData((Object)gridData);
            this.timeControl = new DateTime(parent, 128);
            gridData = new GridData();
            gridData.horizontalAlignment = 131072;
            this.timeControl.setLayoutData((Object)gridData);
        }

        protected Point getInitialLocation(Point initialSize) {
            return Display.getCurrent().map((Control)DateTimeText.this.calendarButton.getParent(), null, DateTimeText.this.calendarButton.getLocation());
        }

        private void createOkButton(Composite parent) {
            Button button = new Button(parent, 0x800008);
            button.setText(IDialogConstants.OK_LABEL);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 131072;
            gridData.widthHint = 61;
            button.setLayoutData((Object)gridData);
            this.getShell().setDefaultButton(button);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DateTimeDialog.this.closeWithSave();
                }
            });
        }

        private void createCancelButton(Composite parent) {
            Button button = new Button(parent, 0x800008);
            button.setText(IDialogConstants.CANCEL_LABEL);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 131072;
            gridData.widthHint = 61;
            button.setLayoutData((Object)gridData);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DateTimeDialog.this.close();
                }
            });
        }

        protected void closeWithSave() {
            DateTimeText.this.setDate(this.getDate());
            this.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        DATE,
        DATETIME;

    }
}

