/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.widgets;

import eu.geclipse.ui.widgets.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TabComponent<T>
extends AbstractLaunchConfigurationTab {
    protected Button editButton;
    protected Button removeButton;
    protected Button addButton;
    protected ColumnLayoutData[] tabColumnsLayouts;
    protected TableViewer table;
    private IStructuredContentProvider contentProvider;
    private ITableLabelProvider labelProvider;
    private String[] tabColumnsHeaders;
    private String[] tabColumnsProperties;
    private int tabHeight;
    private List<Integer> columnsWidth = new ArrayList<Integer>();
    private ArrayList<CellEditor> cellEditors = new ArrayList();
    private ICellModifier cellModifier;
    private int buttonsPosition;
    private Object input;

    public TabComponent(IStructuredContentProvider contentProvider, ITableLabelProvider labelProvider, List<String> propertiesVsHearders, Object input, int hight, int width) {
        this(contentProvider, labelProvider, propertiesVsHearders, hight, width, 16384);
        this.input = input;
    }

    public TabComponent(IStructuredContentProvider contentProvider, ITableLabelProvider labelProvider, List<String> propertiesVsHearders, int hight, int width) {
        this(contentProvider, labelProvider, propertiesVsHearders, hight, width, 16384);
    }

    public TabComponent(IStructuredContentProvider contentProvider, ITableLabelProvider labelProvider, List<String> propertiesVsHearders, int hight, int width, int buttonsPosition) {
        this.contentProvider = contentProvider;
        this.tabHeight = hight;
        this.labelProvider = labelProvider;
        this.tabColumnsHeaders = new String[propertiesVsHearders.size()];
        this.tabColumnsProperties = new String[propertiesVsHearders.size()];
        this.tabColumnsHeaders = propertiesVsHearders.toArray(this.tabColumnsHeaders);
        this.tabColumnsProperties = propertiesVsHearders.toArray(this.tabColumnsProperties);
        this.tabColumnsLayouts = new ColumnLayoutData[this.tabColumnsHeaders.length];
        int i = 0;
        while (i < this.tabColumnsHeaders.length) {
            this.columnsWidth.add(width);
            this.tabColumnsLayouts[i] = new ColumnWeightData(this.columnsWidth.get(i).intValue(), this.columnsWidth.get(i).intValue(), false);
            ++i;
        }
        this.buttonsPosition = buttonsPosition;
    }

    public TabComponent(IStructuredContentProvider contentProvider, ITableLabelProvider labelProvider, List<String> propertiesVsHearders, Object input, int hight, List<Integer> columnsWidth, int buttonsPosition) {
        this.contentProvider = contentProvider;
        this.tabHeight = hight;
        this.columnsWidth = columnsWidth;
        this.labelProvider = labelProvider;
        this.tabColumnsHeaders = new String[propertiesVsHearders.size()];
        this.tabColumnsProperties = new String[propertiesVsHearders.size()];
        this.tabColumnsHeaders = propertiesVsHearders.toArray(this.tabColumnsHeaders);
        this.tabColumnsProperties = propertiesVsHearders.toArray(this.tabColumnsProperties);
        this.tabColumnsLayouts = new ColumnLayoutData[this.tabColumnsHeaders.length];
        int i = 0;
        while (i < this.tabColumnsHeaders.length) {
            this.tabColumnsLayouts[i] = new ColumnWeightData(this.columnsWidth.get(i).intValue(), this.columnsWidth.get(i).intValue(), false);
            ++i;
        }
        this.buttonsPosition = buttonsPosition;
        this.input = input;
    }

    public TabComponent(IStructuredContentProvider contentProvider, ITableLabelProvider labelProvider, List<String> propertiesVsHearders, int hight, List<Integer> columnsWidth, int buttonsPosition) {
        this.contentProvider = contentProvider;
        this.tabHeight = hight;
        this.columnsWidth = columnsWidth;
        this.labelProvider = labelProvider;
        this.tabColumnsHeaders = new String[propertiesVsHearders.size()];
        this.tabColumnsProperties = new String[propertiesVsHearders.size()];
        this.tabColumnsHeaders = propertiesVsHearders.toArray(this.tabColumnsHeaders);
        this.tabColumnsProperties = propertiesVsHearders.toArray(this.tabColumnsProperties);
        this.tabColumnsLayouts = new ColumnLayoutData[this.tabColumnsHeaders.length];
        int i = 0;
        while (i < this.tabColumnsHeaders.length) {
            this.tabColumnsLayouts[i] = new ColumnWeightData(this.columnsWidth.get(i).intValue(), this.columnsWidth.get(i).intValue(), false);
            ++i;
        }
        this.buttonsPosition = buttonsPosition;
    }

    public void createControl(Composite parent) {
        Composite mainComposite1 = new Composite(parent, 0);
        this.setControl((Control)mainComposite1);
        GridLayout layout = new GridLayout();
        layout.numColumns = this.buttonsPosition == 1024 || this.buttonsPosition == 128 ? 1 : 2;
        GridData gridData = new GridData(768);
        mainComposite1.setLayout((Layout)layout);
        mainComposite1.setLayoutData((Object)gridData);
        mainComposite1.setFont(parent.getFont());
        this.createTable(mainComposite1);
        this.createTableButtons(mainComposite1);
        this.setLabels();
        Dialog.applyDialogFont((Control)mainComposite1);
        this.addEditors();
        if (!this.cellEditors.isEmpty()) {
            CellEditor[] editorsTable = new CellEditor[this.cellEditors.size()];
            int i = 0;
            Iterator<CellEditor> iterator = this.cellEditors.iterator();
            while (iterator.hasNext()) {
                CellEditor editor;
                editorsTable[i] = editor = iterator.next();
                ++i;
            }
            this.table.setCellEditors(editorsTable);
            this.table.setCellModifier(this.cellModifier);
        }
    }

    protected void addEditors() {
    }

    protected void setCellModifier(ICellModifier cellModifier) {
        this.cellModifier = cellModifier;
    }

    protected void addComboEditor(ComboBoxCellEditor editor, String[] types, boolean readOnly) {
        editor.create((Composite)this.table.getTable());
        editor.setItems(types);
        if (readOnly) {
            editor.setStyle(8);
        }
        this.cellEditors.add((CellEditor)editor);
    }

    public void addEditor(CellEditor editor) {
        editor.create((Composite)this.table.getTable());
        this.cellEditors.add(editor);
    }

    private void createTable(Composite parent) {
        Font font = parent.getFont();
        Composite tableComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.tabHeight;
        int width = 0;
        for (Integer value : this.columnsWidth) {
            width += value.intValue();
        }
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)gridData);
        tableComposite.setFont(font);
        this.table = new TableViewer(tableComposite, 68354);
        Table localTable = this.table.getTable();
        TableLayout tableLayout = new TableLayout();
        localTable.setLayout((Layout)tableLayout);
        localTable.setHeaderVisible(true);
        localTable.setFont(font);
        gridData = new GridData(1808);
        this.table.getControl().setLayoutData((Object)gridData);
        this.table.setContentProvider((IContentProvider)this.contentProvider);
        this.table.setInput(this.input);
        this.table.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.table.setColumnProperties(this.tabColumnsProperties);
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TabComponent.this.handleTableSelectionChanged(event);
            }
        });
        this.table.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!TabComponent.this.table.getSelection().isEmpty()) {
                    TabComponent.this.handleEditButtonSelected();
                }
            }
        });
        int i = 0;
        while (i < this.tabColumnsHeaders.length) {
            tableLayout.addColumnData(this.tabColumnsLayouts[i]);
            TableColumn tc = new TableColumn(localTable, 0, i);
            tc.setResizable(this.tabColumnsLayouts[i].resizable);
            tc.setText(this.tabColumnsHeaders[i]);
            ++i;
        }
        this.table.refresh();
    }

    public String getName() {
        return null;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent event) {
        int size = ((IStructuredSelection)event.getSelection()).size();
        this.editButton.setEnabled(size == 1);
        this.removeButton.setEnabled(size > 0);
    }

    protected void createTableButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.numColumns = this.buttonsPosition == 1024 || this.buttonsPosition == 128 ? 3 : 1;
        GridData gdata = new GridData(130);
        buttonComposite.setLayout((Layout)glayout);
        buttonComposite.setLayoutData((Object)gdata);
        buttonComposite.setFont(parent.getFont());
        if (this.buttonsPosition == 16384) {
            this.createVerticalSpacer(buttonComposite, 1);
        }
        gdata = new GridData(1808);
        this.addButton = new Button(buttonComposite, 8);
        this.addButton.setLayoutData((Object)gdata);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabComponent.this.handleAddButtonSelected();
            }
        });
        gdata = new GridData(1808);
        this.editButton = new Button(buttonComposite, 8);
        this.editButton.setLayoutData((Object)gdata);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabComponent.this.handleEditButtonSelected();
            }
        });
        this.editButton.setEnabled(false);
        gdata = new GridData(1808);
        this.removeButton = new Button(buttonComposite, 8);
        this.removeButton.setLayoutData((Object)gdata);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabComponent.this.handleRemoveButtonSelected();
            }
        });
        this.removeButton.setEnabled(false);
    }

    protected boolean addVariable(T variable) {
        boolean result = true;
        TableItem[] items = this.table.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            Object existingVariable = items[i].getData();
            if (existingVariable.equals(variable)) {
                boolean overWrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.getString("TabComponent.replace_table_item_question_title"), (String)Messages.getString("TabComponent.replace_table_item_question"));
                if (!overWrite) {
                    result = false;
                    break;
                }
                this.table.remove(existingVariable);
                break;
            }
            ++i;
        }
        if (result) {
            this.table.add(variable);
        }
        return result;
    }

    public ArrayList<T> getInput() {
        ArrayList<Object> result = new ArrayList<Object>();
        TableItem[] tableItemArray = this.table.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            result.add(item.getData());
            ++n2;
        }
        return result;
    }

    protected abstract void handleRemoveButtonSelected();

    protected abstract void handleAddButtonSelected();

    protected abstract void handleEditButtonSelected();

    protected abstract void setLabels();
}

