/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards;

import eu.geclipse.core.model.IGridConnection;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.ui.wizards.Messages;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class ConnectionLocationWizardPage
extends WizardNewFileCreationPage {
    private URI initialContent;
    private IStructuredSelection initialSelection;

    public ConnectionLocationWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.initialSelection = selection;
    }

    public String getConnectionFilename() {
        String filename = this.getFileName();
        return "." + filename + ".fs";
    }

    protected InputStream getInitialContents() {
        ByteArrayInputStream result = null;
        if (this.initialContent != null) {
            String string = this.initialContent.toString();
            byte[] bytes = string.getBytes();
            result = new ByteArrayInputStream(bytes);
        }
        return result;
    }

    protected String getNewFileLabel() {
        return Messages.getString("ConnectionLocationWizardPage.connection_name");
    }

    protected void initialPopulateContainerNameField() {
        IGridContainer element = null;
        if (this.initialSelection != null && !this.initialSelection.isEmpty()) {
            for (Object o : this.initialSelection.toList()) {
                if (!(o instanceof IGridElement)) continue;
                IGridProject project = ((IGridElement)o).getProject();
                IGridContainer mountDir = project.getProjectFolder(IGridConnection.class);
                IGridElement e = (IGridElement)o;
                while (e != null) {
                    if (e == mountDir) {
                        element = (IGridElement)o;
                        break;
                    }
                    e = e.getParent();
                }
                if (element != null) continue;
                element = mountDir;
            }
        }
        if (element != null) {
            this.setContainerFullPath(element.getPath());
        } else {
            super.initialPopulateContainerNameField();
        }
        this.validatePage();
    }

    protected void setInitialContent(URI uri) {
        this.initialContent = uri;
    }

    protected boolean validatePage() {
        boolean result = super.validatePage();
        if (result) {
            IPath path = this.getContainerFullPath();
            String file = this.getConnectionFilename();
            IPath filepath = path.append(file);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            if (root.exists(filepath)) {
                result = false;
                this.setErrorMessage(Messages.getString("ConnectionLocationWizardPage.connection_already_exists"));
            }
        }
        return result;
    }
}

