/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.actions.MountAction;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.wizards.ConnectionDefinitionWizardPage;
import eu.geclipse.ui.wizards.ConnectionLocationWizardPage;
import eu.geclipse.ui.wizards.ConnectionNameWizardPage;
import eu.geclipse.ui.wizards.Messages;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ConnectionWizard
extends Wizard
implements INewWizard {
    protected static final String CONNECTION_PREFIX = ".";
    protected static final String CONNECTION_SUFFIX = ".fs";
    IWizardPage firstPage;
    private boolean createGlobalConnection;
    private ISelection initialSelection;
    private URI initialURI;
    private String initialName;
    private ConnectionDefinitionWizardPage definitionPage;

    public ConnectionWizard() {
        this(null, null, false);
    }

    public ConnectionWizard(URI initialURI, String initialName) {
        this(initialURI, initialName, false);
    }

    public ConnectionWizard(boolean createGlobalConnection) {
        this(null, null, createGlobalConnection);
    }

    public ConnectionWizard(URI initialURI, String initialName, boolean createGlobalConnection) {
        URL imgURL = Activator.getDefault().getBundle().getResource("icons/wizban/newconn_wiz.gif");
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)imgURL));
        this.setNeedsProgressMonitor(true);
        this.createGlobalConnection = createGlobalConnection;
        this.initialURI = initialURI;
        this.initialName = initialName;
    }

    public void addPages() {
        if (this.initialSelection == null) {
            this.initialSelection = StructuredSelection.EMPTY;
        }
        if (this.createGlobalConnection) {
            this.firstPage = new ConnectionNameWizardPage(this.initialName);
        } else {
            this.firstPage = new ConnectionLocationWizardPage(Messages.getString("ConnectionWizard.location_page_name"), (IStructuredSelection)this.initialSelection);
            this.firstPage.setTitle(Messages.getString("ConnectionWizard.location_page_title"));
            this.firstPage.setDescription(Messages.getString("ConnectionWizard.location_page_description"));
            if (this.initialName != null) {
                ((ConnectionLocationWizardPage)this.firstPage).setFileName(this.initialName);
            }
        }
        this.addPage(this.firstPage);
        IGridContainer mountPoint = this.getMountPoint();
        this.definitionPage = new ConnectionDefinitionWizardPage(mountPoint, this.initialURI);
        this.addPage((IWizardPage)this.definitionPage);
    }

    public boolean canFinish() {
        IWizardContainer container = this.getContainer();
        IWizardPage currentPage = container.getCurrentPage();
        return (currentPage != this.firstPage || this.initialURI != null) && super.canFinish();
    }

    public String getWindowTitle() {
        return Messages.getString("ConnectionWizard.window_title");
    }

    public boolean performFinish() {
        boolean result = true;
        URI uri = this.definitionPage.getURI();
        if (uri != null) {
            try {
                result = this.createGlobalConnection ? this.createGlobalConnection(uri) : this.createLocalConnection(uri);
            }
            catch (ProblemException pExc) {
                ProblemDialog.openProblem(this.getShell(), "Mount failed", "Unable to create connection", pExc);
                result = false;
            }
        }
        return result;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.initialSelection = selection;
    }

    protected boolean createGlobalConnection(final URI uri) throws ProblemException {
        boolean result = true;
        ConnectionNameWizardPage page = (ConnectionNameWizardPage)this.firstPage;
        final String name = page.getConnectionName();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            MountAction.createGlobalMount(uri, name, monitor);
                        }
                        catch (CoreException pExc) {
                            throw new InvocationTargetException(pExc);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException itExc) {
            Throwable t = itExc.getCause();
            if (t instanceof ProblemException) {
                throw (ProblemException)t;
            }
            if (t == null) {
                t = itExc;
            }
            throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", "Unable to create connection", t, "eu.geclipse.ui");
        }
        catch (InterruptedException interruptedException) {
            result = false;
        }
        return result;
    }

    protected boolean createLocalConnection(final URI uri) throws ProblemException {
        boolean result = true;
        ConnectionLocationWizardPage page = (ConnectionLocationWizardPage)this.firstPage;
        final IPath path = page.getContainerFullPath().append(page.getFileName());
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        MountAction.createLocalMount(uri, path, monitor);
                    }
                    catch (CoreException cExc) {
                        throw new InvocationTargetException(cExc);
                    }
                }
            });
        }
        catch (InvocationTargetException itExc) {
            Throwable t = itExc.getCause();
            if (t instanceof ProblemException) {
                throw (ProblemException)t;
            }
            if (t == null) {
                t = itExc;
            }
            throw new ProblemException("eu.geclipse.core.problem.model.elementCreateFailed", "Unable to create connection", t, "eu.geclipse.ui");
        }
        catch (InterruptedException interruptedException) {
            result = false;
        }
        return result;
    }

    private IGridContainer getMountPoint() {
        IGridContainer result = null;
        if (this.initialSelection != null && this.initialSelection instanceof StructuredSelection) {
            StructuredSelection sSelection = (StructuredSelection)this.initialSelection;
            Object object = sSelection.getFirstElement();
            if (object instanceof IGridContainer) {
                result = (IGridContainer)object;
            } else if (object instanceof IResource) {
                IGridElement element = GridModel.getRoot().findElement((IResource)object);
                if (element != null && element instanceof IGridContainer) {
                    result = (IGridContainer)element;
                }
            } else if (object instanceof IAdaptable) {
                result = (IGridContainer)((IAdaptable)object).getAdapter(IGridContainer.class);
            }
        }
        return result;
    }

    private void setCurrentErrorMessage(IWizardPage fromPage) {
        String errorMessage = fromPage.getErrorMessage();
        WizardPage toPage = (WizardPage)this.getContainer().getCurrentPage();
        toPage.setErrorMessage(errorMessage);
    }
}

