/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IVoManager;
import eu.geclipse.core.model.impl.GenericVirtualOrganization;
import eu.geclipse.core.model.impl.GenericVoCreator;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.wizards.GenericVoWizardPage;
import eu.geclipse.ui.wizards.VoServiceSelectionPage;
import eu.geclipse.ui.wizards.wizardselection.IInitializableWizard;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;

public class GenericVoWizard
extends Wizard
implements IInitializableWizard {
    private GenericVirtualOrganization initialVo;
    private GenericVoWizardPage voPage;
    private VoServiceSelectionPage servicePage;

    public void addPages() {
        this.voPage = new GenericVoWizardPage();
        this.servicePage = new VoServiceSelectionPage();
        if (this.initialVo != null) {
            this.voPage.setInitialVo(this.initialVo);
            this.servicePage.setInitialVo(this.initialVo);
        }
        this.addPage((IWizardPage)this.voPage);
        this.addPage((IWizardPage)this.servicePage);
    }

    public String getWindowTitle() {
        return "Generic VO";
    }

    public boolean init(Object initialData) {
        boolean result = false;
        if (initialData instanceof GenericVirtualOrganization) {
            this.initialVo = (GenericVirtualOrganization)initialData;
            result = true;
        }
        return result;
    }

    public boolean performFinish() {
        GenericVoCreator creator = new GenericVoCreator();
        IStatus result = this.voPage.apply(creator);
        if (result.isOK()) {
            result = this.servicePage.apply(creator);
        }
        if (result.isOK()) {
            result = this.createVo(creator);
        }
        if (!result.isOK()) {
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage(result.getMessage());
        }
        return result.isOK();
    }

    private IStatus createVo(GenericVoCreator creator) {
        IStatus result = Status.OK_STATUS;
        GenericVirtualOrganization vo = null;
        IVoManager manager = GridModel.getVoManager();
        try {
            if (this.initialVo != null) {
                creator.apply(this.initialVo);
            } else {
                vo = (GenericVirtualOrganization)manager.create((IGridElementCreator)creator);
            }
        }
        catch (ProblemException pExc) {
            result = new Status(4, "eu.geclipse.ui", pExc.getLocalizedMessage(), (Throwable)pExc);
        }
        if (!result.isOK() && vo != null) {
            try {
                manager.delete((IGridElement)vo);
            }
            catch (ProblemException pExc) {
                Activator.logException(pExc);
            }
        }
        return result;
    }
}

