/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.Activator;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoSelectionWizardPage
extends WizardPage
implements IGridModelListener {
    CheckboxTableViewer tableViewer;
    List<IVirtualOrganization> voList;
    Class<?> voType;
    boolean allowMultiSelection;
    private Text infoText;
    private final String PREFERENCE_PAGE_ID = "eu.geclipse.ui.internal.preference.VOPreferencePage";

    public VoSelectionWizardPage(boolean allowMultiSelection) {
        this(allowMultiSelection, null);
    }

    public VoSelectionWizardPage(boolean allowMultiSelection, Class<?> voType) {
        super("eu.geclipse.ui.voSelectionWizardPage", "VO Selection Page", null);
        this.setDescription("Specify the VO that should be used");
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/vo_wiz.gif");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
        this.allowMultiSelection = allowMultiSelection;
        this.voType = voType;
        this.voList = new ArrayList<IVirtualOrganization>();
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        GridData gData = new GridData(1808);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        mainComp.setLayoutData((Object)gData);
        Group voGroup = new Group(mainComp, 0);
        voGroup.setLayout((Layout)new GridLayout(2, false));
        voGroup.setText("&Available VOs");
        gData = new GridData(4, 4, true, true);
        gData.heightHint = 120;
        voGroup.setLayoutData((Object)gData);
        int style = 2852;
        Table voTable = new Table((Composite)voGroup, style);
        gData = new GridData(4, 4, true, true);
        voTable.setLayoutData((Object)gData);
        voTable.setHeaderVisible(false);
        this.tableViewer = new CheckboxTableViewer(voTable);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IVirtualOrganization)element).getName();
            }
        });
        this.tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object vo1, Object vo2) {
                String name1 = ((IVirtualOrganization)vo1).getName();
                String name2 = ((IVirtualOrganization)vo2).getName();
                return name1.compareTo(name2);
            }
        });
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean ret = false;
                Class<?> type = VoSelectionWizardPage.this.voType;
                if (element instanceof IVirtualOrganization) {
                    IVirtualOrganization vo = (IVirtualOrganization)element;
                    if (type == null || type.isAssignableFrom(vo.getClass())) {
                        ret = true;
                    }
                }
                return ret;
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VoSelectionWizardPage.this.showSelectedInfo();
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element;
                if (!VoSelectionWizardPage.this.allowMultiSelection && (element = event.getElement()) instanceof IVirtualOrganization) {
                    IVirtualOrganization vo = (IVirtualOrganization)element;
                    if (event.getChecked()) {
                        VoSelectionWizardPage.this.tableViewer.setCheckedElements(new Object[]{vo});
                        VoSelectionWizardPage.this.tableViewer.refresh();
                    }
                }
                VoSelectionWizardPage.this.setPageComplete(VoSelectionWizardPage.this.getSelectedVos() != null);
            }
        });
        this.updateVoList();
        this.tableViewer.setInput(this.voList);
        GridModel.getVoManager().addGridModelListener((IGridModelListener)this);
        Button editVOsButton = new Button((Composite)voGroup, 8);
        editVOsButton.setText("Edit &VOs...");
        gData = new GridData();
        gData.horizontalAlignment = 1;
        gData.verticalAlignment = 1;
        editVOsButton.setLayoutData((Object)gData);
        editVOsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)VoSelectionWizardPage.this.getShell(), (String)"eu.geclipse.ui.internal.preference.VOPreferencePage", null, null);
                dialog.open();
            }
        });
        Group infoGroup = new Group(mainComp, 0);
        infoGroup.setLayout((Layout)new GridLayout(1, false));
        infoGroup.setText("&VO Info");
        gData = new GridData(4, 4, true, true);
        gData.heightHint = 120;
        infoGroup.setLayoutData((Object)gData);
        this.infoText = new Text((Composite)infoGroup, 2818);
        this.infoText.setEditable(false);
        gData = new GridData(1808);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        this.infoText.setLayoutData((Object)gData);
        this.setInitialSelection();
        this.showSelectedInfo();
        this.setPageComplete(this.getSelectedVos() != null);
        this.setControl((Control)mainComp);
    }

    public void gridModelChanged(IGridModelEvent event) {
        IGridElement[] elements = event.getElements();
        assert (elements[0] instanceof IVirtualOrganization) : "VoSelectionWizardPage expects events whose source is an IVirtualOrganization.";
        switch (event.getType()) {
            case 1: {
                this.updateVoList();
                this.tableViewer.setInput(this.voList);
                this.setSelection(elements[0]);
                break;
            }
            case 2: {
                this.updateVoList();
                this.tableViewer.setInput(this.voList);
                IVirtualOrganization[] selectedVOs = this.getSelectedVos();
                if (selectedVOs != null) break;
                this.setInitialSelection();
            }
        }
        this.setPageComplete(this.getSelectedVos() != null);
    }

    public void dispose() {
        GridModel.getVoManager().removeGridModelListener((IGridModelListener)this);
        super.dispose();
    }

    public IVirtualOrganization[] getSelectedVos() {
        ArrayList<IVirtualOrganization> selectedVos = new ArrayList<IVirtualOrganization>();
        Object[] objectArray = this.tableViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object vo = objectArray[n2];
            selectedVos.add((IVirtualOrganization)vo);
            ++n2;
        }
        if (selectedVos.size() == 0) {
            this.setErrorMessage("No valid VO is selected");
        } else {
            this.setErrorMessage(null);
        }
        return selectedVos.size() == 0 ? null : selectedVos.toArray(new IVirtualOrganization[selectedVos.size()]);
    }

    public void setSelectedVos(IGridElement[] vos) {
        if (vos == null || vos.length == 0) {
            return;
        }
        if (this.allowMultiSelection) {
            this.tableViewer.setCheckedElements((Object[])vos);
        } else {
            assert (vos.length == 1) : "VoSelectionWizardPage got more than one VO to select while allowMultiSelection=false.";
            this.tableViewer.setChecked((Object)vos[0], true);
        }
        this.tableViewer.refresh();
    }

    protected void showSelectedInfo() {
        int index = this.tableViewer.getTable().getSelectionIndex();
        if (index >= 0) {
            IVirtualOrganization vo = (IVirtualOrganization)this.tableViewer.getElementAt(index);
            try {
                String text = "";
                text = String.valueOf(text) + "Name:\n\t" + vo.getName() + '\n';
                text = String.valueOf(text) + "Type:\n\t" + vo.getTypeName() + '\n';
                IGridInfoService infoService = vo.getInfoService();
                if (infoService != null) {
                    text = String.valueOf(text) + "\nInformation Service:\n\tName:\n\t\t" + infoService.getName();
                    text = String.valueOf(text) + "\n\tURI:\n\t\t" + infoService.getURI().toString();
                }
                this.infoText.setText(text);
            }
            catch (ProblemException pExc) {
                ProblemDialog.openProblem(this.getShell(), "VO info problem", "Unable to query services for VO " + vo.getName(), pExc);
            }
        } else {
            this.infoText.setText("");
        }
        this.infoText.redraw();
    }

    private void updateVoList() {
        this.voList.clear();
        try {
            IGridElement[] vos;
            IGridElement[] iGridElementArray = vos = GridModel.getVoManager().getChildren(null);
            int n = vos.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement vo = iGridElementArray[n2];
                this.voList.add((IVirtualOrganization)vo);
                ++n2;
            }
        }
        catch (ProblemException pExc) {
            ProblemDialog.openProblem(this.getShell(), "VO list problem", "Unable to query registered VOs", pExc);
        }
    }

    private void setSelection(IGridElement vo) {
        if (vo == null || !(vo instanceof IVirtualOrganization)) {
            return;
        }
        if (this.allowMultiSelection) {
            this.tableViewer.setChecked((Object)vo, true);
        } else {
            this.tableViewer.setCheckedElements(new Object[]{vo});
        }
        this.tableViewer.refresh();
        StructuredSelection sel = new StructuredSelection((Object)vo);
        this.tableViewer.setSelection((ISelection)sel, true);
    }

    private void setInitialSelection() {
        IGridElement defaultVo = GridModel.getVoManager().getDefault();
        if (defaultVo == null) {
            defaultVo = (IGridElement)this.tableViewer.getElementAt(0);
        } else {
            boolean show = true;
            ViewerFilter[] viewerFilterArray = this.tableViewer.getFilters();
            int n = viewerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                show &= filter.select((Viewer)this.tableViewer, this.voList, (Object)defaultVo);
                ++n2;
            }
            if (!show) {
                defaultVo = (IGridElement)this.tableViewer.getElementAt(0);
            }
        }
        this.setSelection(defaultVo);
    }
}

