/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.jobsubmission;

import eu.geclipse.core.jobs.GridJob;
import eu.geclipse.core.jobs.GridJobCreator;
import eu.geclipse.core.jobs.ParametricJobService;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.model.IGridJobID;
import eu.geclipse.core.model.IGridJobService;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.reporting.IProblem;
import eu.geclipse.core.reporting.ISolution;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.wizards.jobsubmission.FolderSelectionWizardPage;
import eu.geclipse.ui.wizards.jobsubmission.JobServiceSelectionWizardPage;
import eu.geclipse.ui.wizards.jobsubmission.Messages;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobCreatorSelectionWizard
extends Wizard {
    protected List<IGridJobDescription> jobDescriptions;
    private List<IGridJobService> jobServices;
    private JobServiceSelectionWizardPage selectionPage;
    private FolderSelectionWizardPage folderSelection;

    public JobCreatorSelectionWizard(List<IGridJobDescription> jobDescriptions) {
        this.jobDescriptions = new ArrayList<IGridJobDescription>(jobDescriptions);
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(Messages.getString("JobCreatorSelectionWizard.title"));
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/jobsubmit_wiz.gif");
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
    }

    public IResource getDestinationFolder() {
        return this.folderSelection.getDestinationFolder();
    }

    public IGridJobService getSubmissionService() {
        return this.selectionPage.getSubmissionService();
    }

    public void addPages() {
        this.folderSelection = new FolderSelectionWizardPage("name", this.jobDescriptions.get(0).getProject(), this.jobDescriptions);
        this.addPage((IWizardPage)this.folderSelection);
        this.selectionPage = new JobServiceSelectionWizardPage("Job Service Selection", this.jobDescriptions);
        this.jobServices = new ArrayList<IGridJobService>();
        Job job = new Job("Retrieving list of job services"){

            protected IStatus run(IProgressMonitor monitor) {
                if (!$assertionsDisabled && JobCreatorSelectionWizard.this.jobDescriptions == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && JobCreatorSelectionWizard.this.jobDescriptions.get(0) == null) {
                    throw new AssertionError();
                }
                IGridJobService[] allServices = null;
                IGridProject project = JobCreatorSelectionWizard.this.jobDescriptions.get(0).getProject();
                if (!$assertionsDisabled && project == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && project.getVO() == null) {
                    throw new AssertionError();
                }
                try {
                    IGridJobService[] iGridJobServiceArray = allServices = project.getVO().getJobSubmissionServices(null);
                    int n = allServices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IGridJobService service = iGridJobServiceArray[n2];
                        Iterator<IGridJobDescription> iter = JobCreatorSelectionWizard.this.jobDescriptions.iterator();
                        boolean valid = true;
                        while (iter.hasNext()) {
                            IGridJobDescription jobDescription = iter.next();
                            if (service.canSubmit(jobDescription)) continue;
                            valid = false;
                        }
                        if (valid) {
                            JobCreatorSelectionWizard.this.jobServices.add(service);
                        }
                        ++n2;
                    }
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    Display display = workbench.getDisplay();
                    display.syncExec(new Runnable(){

                        public void run() {
                            JobCreatorSelectionWizard.this.selectionPage.setServices(JobCreatorSelectionWizard.this.jobServices);
                        }
                    });
                }
                catch (ProblemException problemException) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        this.addPage((IWizardPage)this.selectionPage);
    }

    public boolean canFinish() {
        return super.canFinish() && this.getSubmissionService() != null;
    }

    public boolean performFinish() {
        JobSubmissionJob job = new JobSubmissionJob();
        job.setJobNames(this.folderSelection.getJobNames());
        job.setDestinationFolder(this.folderSelection.getDestinationFolder());
        job.setUser(true);
        Shell shell = this.getWizardShell();
        if (shell != null) {
            shell.setVisible(false);
        }
        job.schedule();
        return false;
    }

    IGridContainer buildPath(IGridJobDescription description) throws CoreException {
        IGridProject result = null;
        IGridProject project = description.getProject();
        IPath projectPath = project.getPath();
        IGridContainer jobFolder = project.getProjectFolder(IGridJob.class);
        IPath jobFolderPath = jobFolder.getPath();
        if (jobFolderPath.equals((Object)projectPath)) {
            result = project;
        } else {
            IPath descriptionPath = description.getPath().removeLastSegments(1);
            IGridContainer descriptionFolder = project.getProjectFolder(IGridJobDescription.class);
            IPath descriptionFolderPath = descriptionFolder.getPath();
            if (descriptionFolderPath.isPrefixOf(descriptionPath)) {
                int matchingFirstSegments = descriptionPath.matchingFirstSegments(descriptionFolderPath);
                IPath appendedPath = descriptionPath.removeFirstSegments(matchingFirstSegments);
                jobFolderPath = jobFolderPath.append(appendedPath);
                IWorkspaceRoot workspaceRoot = (IWorkspaceRoot)GridModel.getRoot().getResource();
                IFolder folder = workspaceRoot.getFolder(jobFolderPath);
                this.createFolder((IContainer)folder);
                result = (IGridContainer)GridModel.getRoot().findElement((IResource)folder);
            } else {
                result = jobFolder;
            }
        }
        return result;
    }

    void createFolder(IContainer folder) throws CoreException {
        IContainer parent = folder.getParent();
        if (parent != null && parent instanceof IFolder) {
            this.createFolder(parent);
        }
        if (!folder.exists() && folder instanceof IFolder) {
            ((IFolder)folder).create(true, true, null);
        }
    }

    private Shell getWizardShell() {
        Shell shell = null;
        if (this.getContainer() != null) {
            shell = this.getContainer().getShell();
        }
        return shell;
    }

    protected void addShowWizardSolution(Throwable exc) {
        if (exc instanceof ProblemException) {
            ProblemException problemExc = (ProblemException)exc;
            IProblem problem = problemExc.getProblem();
            problem.addSolution(new ISolution(){

                public String getDescription() {
                    return Messages.getString("JobSubmissionWizardBase.solutionOpenWizard");
                }

                public String getID() {
                    return null;
                }

                public boolean isActive() {
                    return true;
                }

                public void solve() throws InvocationTargetException {
                    JobCreatorSelectionWizard.this.getContainer().getShell().setVisible(true);
                }
            });
        }
    }

    protected void addOpenEditorSolution(Throwable exc) {
        if (exc instanceof ProblemException) {
            ProblemException problemExc = (ProblemException)exc;
            IProblem problem = problemExc.getProblem();
            problem.addSolution(new ISolution(){

                public String getDescription() {
                    return Messages.getString("JobSubmissionWizardBase.solutionOpenEditor");
                }

                public String getID() {
                    return null;
                }

                public boolean isActive() {
                    return true;
                }

                public void solve() throws InvocationTargetException {
                    for (IGridJobDescription descr : JobCreatorSelectionWizard.this.jobDescriptions) {
                        IResource res = descr.getResource();
                        if (!(res instanceof IFile)) continue;
                        IFile desFile = (IFile)res;
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(desFile.getName());
                        try {
                            page.openEditor((IEditorInput)new FileEditorInput(desFile), desc.getId());
                        }
                        catch (PartInitException partInitException) {}
                    }
                }
            });
            problem.addReason(Messages.getString("JobSubmissionWizardBase.submissionFailedReasonNotEnoughInput"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JobSubmissionJob
    extends Job {
        final IGridJobService service;
        private List<String> jobNames;
        private IResource destinationFolder;

        JobSubmissionJob() {
            super(Messages.getString("JobSubmissionWizardBase.jobName"));
            this.service = JobCreatorSelectionWizard.this.getSubmissionService();
        }

        void setJobNames(List<String> _jobNames) {
            this.jobNames = _jobNames;
        }

        void setDestinationFolder(IResource folder) {
            this.destinationFolder = folder;
        }

        protected IStatus run(IProgressMonitor monitor) {
            boolean closeWizard;
            block11: {
                closeWizard = true;
                GridJobCreator creator = new GridJobCreator();
                SubMonitor betterMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)JobCreatorSelectionWizard.this.jobDescriptions.size());
                try {
                    Iterator<IGridJobDescription> iterator = JobCreatorSelectionWizard.this.jobDescriptions.iterator();
                    Iterator<String> namesIterator = this.jobNames.iterator();
                    while (iterator.hasNext()) {
                        this.testCancelled((IProgressMonitor)betterMonitor);
                        IGridJobDescription description = iterator.next();
                        betterMonitor.setTaskName(String.format(Messages.getString("JobSubmissionWizardBase.taskNameSubmitting"), description.getName()));
                        IGridContainer parent = this.buildTargetFolder(description, this.destinationFolder);
                        IGridJobID jobId = null;
                        if (this.isParametric(description)) {
                            ParametricJobService paramService = new ParametricJobService(this.service);
                            paramService.submitJob(description, betterMonitor.newChild(1), parent, namesIterator.next());
                        } else {
                            jobId = this.service.submitJob(description, (IProgressMonitor)betterMonitor.newChild(1));
                            creator.canCreate(description);
                            creator.create(parent, jobId, this.service, namesIterator.next());
                        }
                        this.testCancelled((IProgressMonitor)betterMonitor);
                        iterator.remove();
                        namesIterator.remove();
                    }
                }
                catch (ProblemException pExc) {
                    this.showProblem(pExc);
                    closeWizard = false;
                    betterMonitor.done();
                    break block11;
                }
                catch (CoreException cExc) {
                    try {
                        this.showProblem(cExc);
                        closeWizard = false;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        betterMonitor.done();
                    }
                }
                betterMonitor.done();
            }
            if (closeWizard) {
                this.closeWizard();
            }
            return Status.OK_STATUS;
        }

        private boolean isParametric(IGridJobDescription description) {
            boolean parametric = false;
            if (description instanceof JSDLJobDescription) {
                JSDLJobDescription jsdl = (JSDLJobDescription)description;
                if (jsdl.isParametric()) {
                    parametric = true;
                } else {
                    IGridContainer parent = jsdl.getParent();
                    while (parent != null) {
                        if (parent instanceof GridJob) {
                            GridJob parentJob = (GridJob)parent;
                            IGridJobDescription parentDescription = parentJob.getJobDescription();
                            if (!(parentDescription instanceof JSDLJobDescription)) break;
                            parametric = ((JSDLJobDescription)parentDescription).isParametric();
                            break;
                        }
                        parent = parent.getParent();
                    }
                }
            }
            return parametric;
        }

        private IGridContainer buildTargetFolder(IGridJobDescription description, IResource folder) throws CoreException {
            IResource targetFolder = folder;
            Object targetBuildFolder = null;
            IGridProject project = description.getProject();
            IPath descriptionPath = description.getPath().removeLastSegments(1);
            IPath descriptionFolderPath = project.getProjectFolder(IGridJobDescription.class).getPath();
            if (descriptionFolderPath.isPrefixOf(descriptionPath) && folder.getFullPath().equals((Object)project.getProjectFolder(IGridJob.class).getPath())) {
                int matchingFirstSegments = descriptionPath.matchingFirstSegments(descriptionFolderPath);
                IPath appendedPath = descriptionPath.removeFirstSegments(matchingFirstSegments);
                IWorkspaceRoot workspaceRoot = (IWorkspaceRoot)GridModel.getRoot().getResource();
                targetBuildFolder = targetFolder instanceof IProject && appendedPath.toString().equals("") ? (IContainer)targetFolder : workspaceRoot.getFolder(targetFolder.getFullPath().append(appendedPath));
                JobCreatorSelectionWizard.this.createFolder((IContainer)targetBuildFolder);
            }
            if (targetBuildFolder == null) {
                targetBuildFolder = (IContainer)targetFolder;
            }
            return (IGridContainer)GridModel.getRoot().findElement((IResource)targetBuildFolder);
        }

        private void testCancelled(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }

        void closeWizard() {
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    WizardDialog dialog = (WizardDialog)JobCreatorSelectionWizard.this.getContainer();
                    dialog.close();
                }
            });
        }

        private void showProblem(final Throwable exc) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    JobCreatorSelectionWizard.this.addShowWizardSolution(exc);
                    JobCreatorSelectionWizard.this.addOpenEditorSolution(exc);
                    ProblemDialog.openProblem(JobCreatorSelectionWizard.this.getShell(), Messages.getString("JobSubmissionWizardBase.errSubmissionFailed"), null, exc);
                    if (!JobCreatorSelectionWizard.this.getContainer().getShell().isVisible()) {
                        JobCreatorSelectionWizard.this.getContainer().getShell().close();
                    }
                }
            });
        }
    }
}

