/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.jobsubmission;

import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.model.IGridJobService;
import eu.geclipse.core.model.IGridProject;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobServiceSelectionWizardPage
extends WizardPage {
    IGridProject project;
    private List<IGridJobDescription> jobDescriptions;
    private List<IGridJobService> jobServices;
    private org.eclipse.swt.widgets.List list;

    public JobServiceSelectionWizardPage(String pageName, List<IGridJobDescription> _jobDescriptions) {
        super(pageName);
        super.setTitle("Submit job description");
        super.setDescription("Choose service for submitting jobs");
        this.setMessage("Retrieving list of services, please wait a while...", 2);
        this.jobDescriptions = _jobDescriptions;
    }

    public void setServices(List<IGridJobService> _jobServices) {
        this.setMessage(null);
        this.jobServices = _jobServices;
        HashMap<String, Integer> repeatedEntries = new HashMap<String, Integer>(5);
        for (IGridJobService service : this.jobServices) {
            String name = service.getName();
            Integer count = (Integer)repeatedEntries.get(name);
            if (count == null) {
                int index = this.list.indexOf(name);
                if (index != -1) {
                    repeatedEntries.put(name, 1);
                    String oldUri = this.jobServices.get(index).getURI().toString();
                    this.list.setItem(index, String.valueOf(name) + '[' + oldUri + ']');
                    name = String.valueOf(name) + '[' + service.getURI().toString() + ']';
                }
            } else {
                repeatedEntries.put(name, count + 1);
                name = String.valueOf(name) + '[' + service.getURI().toString() + ']';
            }
            this.list.add(name);
        }
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 3;
        gd.horizontalSpan = 2;
        gd.heightHint = 300;
        gd.widthHint = 250;
        this.list = new org.eclipse.swt.widgets.List(mainComp, 2820);
        this.list.setLayoutData((Object)gd);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobServiceSelectionWizardPage.this.updateButtons();
            }
        });
        this.setControl((Control)mainComp);
    }

    protected void updateButtons() {
        this.setPageComplete(this.list.getSelectionCount() > 0);
        this.getContainer().updateButtons();
    }

    public IGridJobService getSubmissionService() {
        IGridJobService service = null;
        int index = this.list.getSelectionIndex();
        if (index != -1) {
            service = this.jobServices.get(index);
        }
        return service;
    }
}

