/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.wizardselection;

import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.wizards.wizardselection.IWizardSelectionNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

class ExtPointWizardSelectionNode
implements IWizardSelectionNode {
    private IWizard wizard;
    private IConfigurationElement element;
    private String name;
    private String id;
    private Image icon;

    ExtPointWizardSelectionNode(IConfigurationElement element, String id, String name, Image icon) {
        this.element = element;
        this.name = name;
        this.id = id;
        this.icon = icon;
    }

    public String getName() {
        return this.name;
    }

    public Image getIcon() {
        return this.icon;
    }

    public void dispose() {
        if (this.icon != null) {
            this.icon.dispose();
        }
        if (this.wizard != null) {
            this.wizard.dispose();
        }
    }

    public Point getExtent() {
        return new Point(-1, -1);
    }

    public IWizard getWizard() {
        if (this.wizard == null) {
            try {
                Object obj = this.element.createExecutableExtension("class");
                if (obj instanceof IWizard) {
                    this.wizard = (IWizard)obj;
                }
            }
            catch (CoreException coreEx) {
                Activator.logException(coreEx);
            }
        }
        return this.wizard;
    }

    public IWizard getTempWizard() {
        boolean resetWizard = this.wizard == null;
        IWizard result = this.getWizard();
        if (resetWizard) {
            this.wizard = null;
        }
        return result;
    }

    public boolean isContentCreated() {
        return this.wizard != null;
    }

    String getId() {
        return this.id;
    }
}

