/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.wizardselection;

import eu.geclipse.ui.wizards.wizardselection.IInitializableWizard;
import eu.geclipse.ui.wizards.wizardselection.IWizardSelectionNode;
import eu.geclipse.ui.wizards.wizardselection.WizardSelectionListComposite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;

public class WizardSelectionListPage
extends WizardSelectionPage
implements IPageChangedListener {
    protected ICheatSheetManager cheatSheetManager = null;
    protected IWizardSelectionNode[] wizardSelectionNodes;
    Map<IWizardSelectionNode, Boolean> visibilityMap = new HashMap<IWizardSelectionNode, Boolean>();
    IWizardNode preselectedNode;
    private String title;
    private String desc;
    private WizardSelectionListComposite composite;
    private Object initData;
    private boolean hidePrev;

    public WizardSelectionListPage(String pageName, IWizardSelectionNode[] wizardSelectionNodes, String title, String desc, String emptyListErrMsg) {
        super(pageName);
        this.wizardSelectionNodes = wizardSelectionNodes;
        this.title = title;
        this.desc = desc;
        if (wizardSelectionNodes.length == 1) {
            this.preselectedNode = wizardSelectionNodes[0];
        } else if (wizardSelectionNodes.length == 0) {
            this.setErrorMessage(emptyListErrMsg);
        }
    }

    public WizardSelectionListPage(String pageName, IWizardSelectionNode[] wizardSelectionNodes, String title, String desc, String emptyListErrMsg, boolean quickSelection) {
        super(pageName);
        this.wizardSelectionNodes = wizardSelectionNodes;
        this.title = title;
        this.desc = desc;
        if (quickSelection && wizardSelectionNodes.length == 1) {
            this.preselectedNode = wizardSelectionNodes[0];
        } else if (wizardSelectionNodes.length == 0) {
            this.setErrorMessage(emptyListErrMsg);
        }
    }

    public void setInitData(Object initData) {
        this.initData = initData;
    }

    public void setPreselectedNode(IWizardNode node, boolean hidePrevPage) {
        this.preselectedNode = node;
        this.hidePrev = hidePrevPage;
    }

    public void dispose() {
        IWizardSelectionNode[] iWizardSelectionNodeArray = this.wizardSelectionNodes;
        int n = this.wizardSelectionNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardSelectionNode wizardNode = iWizardSelectionNodeArray[n2];
            wizardNode.dispose();
            ++n2;
        }
        super.dispose();
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.desc;
    }

    public void createControl(Composite parent) {
        ((WizardDialog)this.getContainer()).addPageChangedListener((IPageChangedListener)this);
        this.composite = new WizardSelectionListComposite(parent, 0);
        this.setControl((Control)this.composite);
        this.composite.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = ((StructuredSelection)event.getSelection()).getFirstElement();
                if (obj instanceof IWizardNode) {
                    WizardSelectionListPage.this.setSelectedNode((IWizardNode)obj);
                }
                WizardSelectionListPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.composite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                WizardSelectionListPage.this.getWizard().getContainer().showPage(WizardSelectionListPage.this.getNextPage());
            }
        });
        this.composite.fillWizardList(this.wizardSelectionNodes);
        IWizardSelectionNode[] iWizardSelectionNodeArray = this.wizardSelectionNodes;
        int n = this.wizardSelectionNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardSelectionNode node = iWizardSelectionNodeArray[n2];
            this.visibilityMap.put(node, true);
            ++n2;
        }
    }

    private IWizard initWizard(IWizardNode node) {
        IWizard wizard = null;
        if (node != null) {
            boolean isCreated = node.isContentCreated();
            wizard = node.getWizard();
            if (wizard != null && !isCreated) {
                if (wizard instanceof IInitializableWizard) {
                    ((IInitializableWizard)wizard).init(this.initData);
                }
                wizard.addPages();
                this.updateCheatSheetManager(wizard);
            }
        }
        return wizard;
    }

    public IWizardPage getNextPage() {
        this.initWizard(this.getSelectedNode());
        return super.getNextPage();
    }

    public void pageChanged(final PageChangedEvent event) {
        ((WizardDialog)this.getContainer()).removePageChangedListener((IPageChangedListener)this);
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (WizardSelectionListPage.this.preselectedNode != null && event.getSelectedPage() == WizardSelectionListPage.this) {
                    WizardSelectionListPage.this.setSelectedNode(WizardSelectionListPage.this.preselectedNode);
                    WizardSelectionListPage.this.getContainer().showPage(WizardSelectionListPage.this.getNextPage());
                    if (WizardSelectionListPage.this.hidePrev) {
                        WizardSelectionListPage.this.getContainer().getCurrentPage().setPreviousPage(null);
                    }
                    WizardSelectionListPage.this.getContainer().updateButtons();
                }
            }
        });
    }

    public void setCheatSheetManager(ICheatSheetManager cheatSheetManager) {
        this.cheatSheetManager = cheatSheetManager;
        this.updateCheatSheetManager(this.getWizard());
    }

    private void updateCheatSheetManager(IWizard wizard) {
        IWizardPage startingPage;
        if (this.cheatSheetManager != null && wizard != null && (startingPage = wizard.getStartingPage()) != null) {
            this.cheatSheetManager.setData("startingPageName", startingPage.getName());
        }
    }

    public IWizardSelectionNode[] getNodes() {
        return this.wizardSelectionNodes;
    }

    public void removeSelectionNode(IWizardSelectionNode nodeToRemove) {
        ArrayList<IWizardSelectionNode> visibleList = new ArrayList<IWizardSelectionNode>();
        Object object = this.wizardSelectionNodes;
        int n = this.wizardSelectionNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardSelectionNode node = object[n2];
            if (node.equals(nodeToRemove) && this.visibilityMap.keySet().contains(node)) {
                this.visibilityMap.put(node, new Boolean(false));
            }
            ++n2;
        }
        if (this.composite != null) {
            for (IWizardSelectionNode node : this.visibilityMap.keySet()) {
                if (!this.visibilityMap.get(node).booleanValue()) continue;
                visibleList.add(node);
            }
            IWizardSelectionNode[] newInput = new IWizardSelectionNode[visibleList.size()];
            int i = 0;
            object = visibleList.iterator();
            while (object.hasNext()) {
                IWizardSelectionNode node;
                newInput[i] = node = (IWizardSelectionNode)object.next();
                ++i;
            }
            this.composite.refreshList(newInput);
        }
    }

    public void resetNodesVisibility() {
        for (IWizardSelectionNode node : this.visibilityMap.keySet()) {
            this.visibilityMap.put(node, new Boolean(true));
        }
        if (this.composite != null) {
            this.composite.refreshList(this.wizardSelectionNodes);
        }
    }
}

