/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.resources;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.core.model.impl.ResourceGridContainer;
import eu.geclipse.core.model.impl.ResourceGridElement;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.workflow.IGridWorkflowDescription;
import eu.geclipse.workflow.IGridWorkflowJobDescription;
import eu.geclipse.workflow.impl.WorkflowImpl;
import eu.geclipse.workflow.internal.Activator;
import eu.geclipse.workflow.model.IWorkflowJob;
import eu.geclipse.workflow.model.IWorkflowNode;
import eu.geclipse.workflow.resources.GridWorkflowJobDescription;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridWorkflow
extends ResourceGridContainer
implements IGridWorkflowDescription {
    private WorkflowImpl rootImpl;
    private List<IGridWorkflowJobDescription> jobs;

    static {
        GridModel.addGridModelListener((IGridModelListener)GridWorkflow.createGridModelListener());
    }

    protected GridWorkflow(IResource resource) {
        super(resource);
    }

    public boolean canContain(IGridElement element) {
        return element instanceof IGridJobDescription || element instanceof ResourceGridElement;
    }

    public String getDescription() {
        return null;
    }

    public String getExecutable() {
        return null;
    }

    public List<String> getExecutableArguments() {
        return null;
    }

    public String getStdErrorFileName() {
        return null;
    }

    public java.net.URI getStdErrorUri() throws ProblemException {
        return null;
    }

    public String getStdInputFileName() {
        return null;
    }

    public java.net.URI getStdInputUri() throws ProblemException {
        return null;
    }

    public String getStdOutputFileName() {
        return null;
    }

    public java.net.URI getStdOutputUri() throws ProblemException {
        return null;
    }

    @Override
    public List<IGridWorkflowJobDescription> getChildrenJobs() {
        WorkflowImpl root;
        if (this.jobs == null && (root = this.getRoot()) != null) {
            this.jobs = new ArrayList<IGridWorkflowJobDescription>();
            for (IWorkflowNode node : root.getNodes()) {
                if (!(node instanceof IWorkflowJob)) continue;
                this.jobs.add(new GridWorkflowJobDescription((IWorkflowJob)node));
            }
        }
        return this.jobs;
    }

    private WorkflowImpl getRoot() {
        if (this.rootImpl == null) {
            IFile root = null;
            if (this.getResource() instanceof IFolder) {
                IFolder rootFolder = (IFolder)this.getResource();
                root = rootFolder.getFile(rootFolder.getName());
            }
            this.loadModel(root);
        }
        return this.rootImpl;
    }

    private void loadModel(IFile file) {
        String filePath = file.getFullPath().toString();
        URI uri = URI.createPlatformResourceURI((String)filePath, (boolean)false);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(uri);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF8");
        try {
            resource.load(options);
            this.rootImpl = (WorkflowImpl)resource.getContents().get(0);
            this.jobs = new ArrayList<IGridWorkflowJobDescription>();
            for (IWorkflowNode node : this.rootImpl.getNodes()) {
                if (!(node instanceof IWorkflowJob)) continue;
                this.jobs.add(new GridWorkflowJobDescription((IWorkflowJob)node));
            }
        }
        catch (IOException ioEx) {
            Activator.logException(ioEx);
        }
    }

    private static IGridModelListener createGridModelListener() {
        return new IGridModelListener(){

            public void gridModelChanged(IGridModelEvent event) {
                switch (event.getType()) {
                    case 3: {
                        IGridElement element;
                        if (event.getElements().length <= 0 || !((element = event.getElements()[0]) instanceof GridWorkflow)) break;
                        this.onWorkflowChanged(event.getElements());
                    }
                }
            }

            private void onWorkflowChanged(IGridElement[] elements) {
                IGridElement[] iGridElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridElement gridElement = iGridElementArray[n2];
                    if (gridElement instanceof GridWorkflow) {
                        GridWorkflow workflowDescription = (GridWorkflow)gridElement;
                        IFolder workflowDescriptionFolder = (IFolder)workflowDescription.getResource();
                        IFile workflowDescriptionFile = workflowDescriptionFolder.getFile(workflowDescriptionFolder.getName());
                        workflowDescription.loadModel(workflowDescriptionFile);
                    }
                    ++n2;
                }
            }
        };
    }

    public File getWorkflowFilePath() {
        File workflowFilePath = new File(String.valueOf(this.getResource().getLocation().toFile().toString()) + "/" + this.getResource().getLocation().toFile().getName());
        return workflowFilePath;
    }
}

