/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.internal;

import eu.geclipse.workflow.provider.WorkflowItemProviderAdapterFactory;
import eu.geclipse.workflow.ui.part.WorkflowDocumentProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class WorkflowDiagramEditorPlugin
extends AbstractUIPlugin {
    public static final String ID = "eu.geclipse.workflow.ui";
    public static final PreferencesHint DIAGRAM_PREFERENCES_HINT = new PreferencesHint("eu.geclipse.workflow.ui");
    private static WorkflowDiagramEditorPlugin instance;
    private ComposedAdapterFactory adapterFactory;
    private WorkflowDocumentProvider myDocumentProvider;

    public WorkflowDiagramEditorPlugin() {
        instance = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        PreferencesHint.registerPreferenceStore((PreferencesHint)DIAGRAM_PREFERENCES_HINT, (Object)this.getPreferenceStore());
        this.adapterFactory = this.createAdapterFactory();
    }

    public void stop(BundleContext context) throws Exception {
        this.adapterFactory.dispose();
        this.adapterFactory = null;
        instance = null;
        super.stop(context);
    }

    public static WorkflowDiagramEditorPlugin getInstance() {
        return instance;
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        ArrayList factories = new ArrayList();
        this.fillItemProviderFactories(factories);
        return new ComposedAdapterFactory(factories);
    }

    protected void fillItemProviderFactories(List factories) {
        factories.add(new WorkflowItemProviderAdapterFactory());
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
    }

    public static WorkflowDiagramEditorPlugin getDefault() {
        return instance;
    }

    public AdapterFactory getItemProvidersAdapterFactory() {
        return this.adapterFactory;
    }

    public ImageDescriptor getItemImageDescriptor(Object item) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(item, IItemLabelProvider.class);
        if (labelProvider != null) {
            return ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage(item));
        }
        return null;
    }

    public static ImageDescriptor getBundledImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public static ImageDescriptor findImageDescriptor(String path) {
        Path p = new Path(path);
        if (p.isAbsolute() && p.segmentCount() > 1) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)p.segment(0), (String)p.removeFirstSegments(1).makeAbsolute().toString());
        }
        return WorkflowDiagramEditorPlugin.getBundledImageDescriptor(p.makeAbsolute().toString());
    }

    public static String getString(String key) {
        return Platform.getResourceString((Bundle)WorkflowDiagramEditorPlugin.getInstance().getBundle(), (String)("%" + key));
    }

    public Image getBundledImage(String path) {
        Image image = this.getImageRegistry().get(path);
        if (image == null) {
            this.getImageRegistry().put(path, WorkflowDiagramEditorPlugin.getBundledImageDescriptor(path));
            image = this.getImageRegistry().get(path);
        }
        return image;
    }

    public WorkflowDocumentProvider getDocumentProvider() {
        if (this.myDocumentProvider == null) {
            this.myDocumentProvider = new WorkflowDocumentProvider();
        }
        return this.myDocumentProvider;
    }

    public void logError(String error) {
        this.logError(error, null);
    }

    public void logError(String error, Throwable throwable) {
        if (error == null && throwable != null) {
            error = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(4, ID, 0, error, throwable));
    }

    public static void logException(Throwable exc) {
        String message = exc.getLocalizedMessage();
        if (message == null) {
            message = exc.getClass().getName();
        }
        Status status = new Status(4, ID, 0, message, exc);
        WorkflowDiagramEditorPlugin.logStatus((IStatus)status);
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Throwable throwable) {
        if (message == null && throwable != null) {
            message = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(1, ID, 0, message, throwable));
    }

    public static void logStatus(IStatus status) {
        WorkflowDiagramEditorPlugin.getDefault().getLog().log(status);
    }
}

