/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.internal.actions;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.workflow.model.IWorkflowJob;
import eu.geclipse.workflow.ui.edit.commands.CopyJobDescToWorkflowCommand;
import eu.geclipse.workflow.ui.edit.commands.UpdateJobPortsCommand;
import eu.geclipse.workflow.ui.edit.parts.WorkflowJobEditPart;
import eu.geclipse.workflow.ui.part.Messages;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class GetJobDescriptionFromFileAction
implements IObjectActionDelegate {
    protected WorkflowJobEditPart mySelectedElement;
    protected IFile jsdlTarget;
    String jobDescriptionInJSDL = null;
    private Shell myShell;
    private IFileStore wfRootFileStore = null;
    private String[] dirs = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.myShell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        String result;
        FileDialog dialog = new FileDialog(this.myShell, 4096);
        String[] exts = new String[]{"*.jsdl"};
        dialog.setFilterExtensions(exts);
        TransactionalEditingDomain domain = this.mySelectedElement.getEditingDomain();
        ResourceSet resourceSet = domain.getResourceSet();
        Resource res = (Resource)resourceSet.getResources().get(0);
        URI wfRootUri = res.getURI();
        String wfRootPath = wfRootUri.path();
        this.dirs = wfRootPath.split("/");
        String projectName = this.dirs[2];
        this.wfRootFileStore = GridModel.getRoot().getFileStore().getChild(projectName);
        dialog.setFilterPath(this.wfRootFileStore.toString());
        if (dialog.open() != null && (result = dialog.getFileName()) != null && result.length() > 0) {
            MessageDialog confirmDialog;
            int confirmResult;
            String filePath = String.valueOf(dialog.getFilterPath()) + "/" + result;
            java.net.URI filePathUri = null;
            filePathUri = URIUtil.toURI((String)filePath);
            IFile jsdlFile = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(filePathUri)[0];
            IWorkflowJob selectedJob = (IWorkflowJob)this.mySelectedElement.resolveSemanticElement();
            if ((selectedJob.getName() != null || selectedJob.getJobDescription() != null) && (confirmResult = (confirmDialog = new MessageDialog(null, Messages.getString("WorkflowJobDragDropEditPolicy_confirmationTitle"), null, Messages.getString("WorkflowJobDragDropEditPolicy_userPrompt"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0)).open()) == 0) {
                JSDLJobDescription jsdl = new JSDLJobDescription(jsdlFile);
                CopyJobDescToWorkflowCommand copyCommand = new CopyJobDescToWorkflowCommand(this.mySelectedElement.resolveSemanticElement(), jsdl);
                UpdateJobPortsCommand updatePortsCommand = new UpdateJobPortsCommand((GraphicalEditPart)this.mySelectedElement, jsdl);
                try {
                    OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)copyCommand, (IProgressMonitor)new NullProgressMonitor(), null);
                    OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)updatePortsCommand, (IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException eE) {
                    eE.printStackTrace();
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this.mySelectedElement = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && structuredSelection.getFirstElement() instanceof WorkflowJobEditPart) {
            this.mySelectedElement = (WorkflowJobEditPart)((Object)structuredSelection.getFirstElement());
        }
        action.setEnabled(this.isEnabled());
    }

    private boolean isEnabled() {
        return this.mySelectedElement != null;
    }
}

