/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.internal.actions;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridRoot;
import eu.geclipse.jsdl.ui.wizards.NewJobWizard;
import eu.geclipse.workflow.model.IWorkflowJob;
import eu.geclipse.workflow.ui.edit.parts.WorkflowJobEditPart;
import eu.geclipse.workflow.ui.internal.WorkflowDiagramEditorPlugin;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenWorkflowJobDescriptionAction
implements IObjectActionDelegate {
    private WorkflowJobEditPart mySelectedElement;
    String fileName = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        IWorkflowJob job = (IWorkflowJob)this.mySelectedElement.resolveSemanticElement();
        String wfFileString = job.getWorkflow().eResource().getURI().toPlatformString(true);
        IGridRoot gridModelRoot = GridModel.getRoot();
        IFileStore gridModelRootFileStore = gridModelRoot.getFileStore();
        String gridModelRootFileStoreString = gridModelRootFileStore.toString();
        java.net.URI uri = URIUtil.toURI((String)(String.valueOf(gridModelRootFileStoreString) + wfFileString));
        IFile[] workflowIFile = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
        String filename = job.getJobDescription();
        IResource res = workflowIFile[0].getParent().findMember(filename);
        if (filename != null) {
            if (!"".equals(filename)) {
                IFile[] file = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(res.getLocation());
                try {
                    if (file.length != 0 && file[0].exists()) {
                        IDE.openEditor((IWorkbenchPage)WorkflowDiagramEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file[0], (boolean)true);
                    }
                }
                catch (PartInitException partInitException) {
                    WorkflowDiagramEditorPlugin.logException(partInitException);
                }
            } else {
                this.createNewJobWizard();
            }
        } else {
            this.createNewJobWizard();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this.mySelectedElement = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && structuredSelection.getFirstElement() instanceof WorkflowJobEditPart) {
            this.mySelectedElement = (WorkflowJobEditPart)((Object)structuredSelection.getFirstElement());
        }
        action.setEnabled(this.isEnabled());
    }

    private boolean isEnabled() {
        return this.mySelectedElement != null;
    }

    private void createNewJobWizard() {
        NewJobWizard newJobWizard = new NewJobWizard();
        TransactionalEditingDomain domain = this.mySelectedElement.getEditingDomain();
        ResourceSet resourceSet = domain.getResourceSet();
        Resource res = (Resource)resourceSet.getResources().get(0);
        URI wfRootUri = res.getURI();
        String wfRootPath = wfRootUri.path();
        String[] dirs = wfRootPath.split("/");
        String projectName = dirs[2];
        IFileStore wfRootFileStore = GridModel.getRoot().getFileStore().getChild(projectName).getChild("Workflows");
        newJobWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)wfRootFileStore));
        WizardDialog wizard = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)newJobWizard);
        wizard.create();
        wizard.open();
    }
}

