/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.part;

import eu.geclipse.workflow.ui.internal.WorkflowDiagramEditorPlugin;
import eu.geclipse.workflow.ui.part.Messages;
import eu.geclipse.workflow.ui.providers.WorkflowElementTypes;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gmf.runtime.diagram.ui.tools.UnspecifiedTypeConnectionTool;
import org.eclipse.gmf.runtime.diagram.ui.tools.UnspecifiedTypeCreationTool;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;

public class WorkflowPaletteFactory {
    public void fillPalette(PaletteRoot paletteRoot) {
        paletteRoot.add((PaletteEntry)this.createWorkflowGroup());
    }

    private PaletteContainer createWorkflowGroup() {
        PaletteGroup paletteContainer = new PaletteGroup(Messages.getString("WorkflowGroup_title"));
        paletteContainer.setDescription(Messages.getString("WorkflowGroup_desc"));
        paletteContainer.add((PaletteEntry)this.createLinkCreationTool());
        paletteContainer.add((PaletteEntry)this.createInputPortCreationTool());
        paletteContainer.add((PaletteEntry)this.createOutputPortCreationTool());
        paletteContainer.add((PaletteEntry)this.createWorkflowJobCreationTool());
        return paletteContainer;
    }

    private ToolEntry createLinkCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(WorkflowElementTypes.ILink_3001);
        LinkToolEntry entry = new LinkToolEntry(Messages.getString("LinkCreationTool_title"), Messages.getString("LinkCreationTool_desc"), types);
        entry.setSmallIcon(WorkflowDiagramEditorPlugin.findImageDescriptor("/eu.geclipse.workflow.edit/icons/full/obj16/Link.gif"));
        entry.setLargeIcon(entry.getSmallIcon());
        return entry;
    }

    private ToolEntry createInputPortCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(WorkflowElementTypes.IInputPort_2002);
        NodeToolEntry entry = new NodeToolEntry(Messages.getString("InputPortCreationTool_title"), Messages.getString("InputPortCreationTool_desc"), types);
        entry.setSmallIcon(WorkflowDiagramEditorPlugin.findImageDescriptor("/eu.geclipse.workflow.edit/icons/full/obj16/InputPort.gif"));
        entry.setLargeIcon(entry.getSmallIcon());
        return entry;
    }

    private ToolEntry createOutputPortCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(WorkflowElementTypes.IOutputPort_2001);
        NodeToolEntry entry = new NodeToolEntry(Messages.getString("OutputPortCreationTool_title"), Messages.getString("OutputPortCreationTool_desc"), types);
        entry.setSmallIcon(WorkflowDiagramEditorPlugin.findImageDescriptor("/eu.geclipse.workflow.edit/icons/full/obj16/OutputPort.gif"));
        entry.setLargeIcon(entry.getSmallIcon());
        return entry;
    }

    private ToolEntry createWorkflowJobCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(WorkflowElementTypes.IWorkflowJob_1001);
        NodeToolEntry entry = new NodeToolEntry(Messages.getString("WorkflowJobCreationTool_title"), Messages.getString("WorkflowJobCreationTool_desc"), types);
        entry.setSmallIcon(WorkflowDiagramEditorPlugin.findImageDescriptor("/eu.geclipse.workflow.edit/icons/full/obj16/WorkflowJob.gif"));
        entry.setLargeIcon(entry.getSmallIcon());
        return entry;
    }

    private static class LinkToolEntry
    extends ToolEntry {
        private final List relationshipTypes;

        private LinkToolEntry(String title, String description, List relationshipTypes) {
            super(title, description, null, null);
            this.relationshipTypes = relationshipTypes;
        }

        public Tool createTool() {
            UnspecifiedTypeConnectionTool tool = new UnspecifiedTypeConnectionTool(this.relationshipTypes);
            tool.setProperties(this.getToolProperties());
            return tool;
        }
    }

    private static class NodeToolEntry
    extends ToolEntry {
        private final List elementTypes;

        private NodeToolEntry(String title, String description, List elementTypes) {
            super(title, description, null, null);
            this.elementTypes = elementTypes;
        }

        public Tool createTool() {
            UnspecifiedTypeCreationTool tool = new UnspecifiedTypeCreationTool(this.elementTypes);
            tool.setProperties(this.getToolProperties());
            return tool;
        }
    }
}

