/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.providers;

import eu.geclipse.workflow.ui.part.WorkflowVisualIDRegistry;
import eu.geclipse.workflow.ui.providers.WorkflowElementTypes;
import eu.geclipse.workflow.ui.view.factories.InputPortViewFactory;
import eu.geclipse.workflow.ui.view.factories.LinkViewFactory;
import eu.geclipse.workflow.ui.view.factories.OutputPortViewFactory;
import eu.geclipse.workflow.ui.view.factories.WorkflowJobNameViewFactory;
import eu.geclipse.workflow.ui.view.factories.WorkflowJobViewFactory;
import eu.geclipse.workflow.ui.view.factories.WorkflowViewFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.providers.AbstractViewProvider;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.View;

public class WorkflowViewProvider
extends AbstractViewProvider {
    protected Class getDiagramViewClass(IAdaptable semanticAdapter, String diagramKind) {
        EObject semanticElement = this.getSemanticElement(semanticAdapter);
        if ("Workflow".equals(diagramKind) && WorkflowVisualIDRegistry.getDiagramVisualID(semanticElement) != -1) {
            return WorkflowViewFactory.class;
        }
        return null;
    }

    protected Class getNodeViewClass(IAdaptable semanticAdapter, View containerView, String semanticHint) {
        int visualID;
        if (containerView == null) {
            return null;
        }
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        EObject domainElement = this.getSemanticElement(semanticAdapter);
        if (semanticHint == null) {
            if (elementType != null || domainElement == null) {
                return null;
            }
            visualID = WorkflowVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        } else {
            visualID = WorkflowVisualIDRegistry.getVisualID(semanticHint);
            if (elementType != null) {
                if (!WorkflowElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
                    return null;
                }
                String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
                if (!semanticHint.equals(elementTypeHint)) {
                    return null;
                }
                if (domainElement != null && visualID != WorkflowVisualIDRegistry.getNodeVisualID(containerView, domainElement)) {
                    return null;
                }
            } else {
                switch (visualID) {
                    case 79: 
                    case 1001: 
                    case 2001: 
                    case 2002: 
                    case 3001: {
                        return null;
                    }
                }
            }
        }
        if (!WorkflowVisualIDRegistry.canCreateNode(containerView, visualID)) {
            return null;
        }
        switch (visualID) {
            case 1001: {
                return WorkflowJobViewFactory.class;
            }
            case 4001: {
                return WorkflowJobNameViewFactory.class;
            }
            case 2001: {
                return OutputPortViewFactory.class;
            }
            case 2002: {
                return InputPortViewFactory.class;
            }
        }
        return null;
    }

    protected Class getEdgeViewClass(IAdaptable semanticAdapter, View containerView, String semanticHint) {
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        if (elementType == null) {
            return null;
        }
        if (!WorkflowElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
            return null;
        }
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        if (elementTypeHint == null) {
            return null;
        }
        if (semanticHint != null && !semanticHint.equals(elementTypeHint)) {
            return null;
        }
        int visualID = WorkflowVisualIDRegistry.getVisualID(elementTypeHint);
        EObject domainElement = this.getSemanticElement(semanticAdapter);
        if (domainElement != null && visualID != WorkflowVisualIDRegistry.getLinkWithClassVisualID(domainElement)) {
            return null;
        }
        switch (visualID) {
            case 3001: {
                return LinkViewFactory.class;
            }
        }
        return null;
    }

    private IElementType getSemanticElementType(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        return (IElementType)semanticAdapter.getAdapter(IElementType.class);
    }
}

