/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.extensions.sirius.helpers;

import org.eclipse.sirius.diagram.description.AdditionalLayer;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.style.CenterLabelStyleDescription;
import org.eclipse.sirius.diagram.description.style.ContainerStyleDescription;
import org.eclipse.sirius.diagram.description.style.EdgeStyleDescription;
import org.eclipse.sirius.diagram.description.style.FlatContainerStyleDescription;
import org.eclipse.sirius.diagram.description.style.StylePackage;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class SpecificationBuildHelper {
    public static DiagramDescription createDiagram(Viewpoint viewpoint, String dName) {
        DiagramDescription diagramDescription = DescriptionPackage.eINSTANCE.getDescriptionFactory().createDiagramDescription();
        diagramDescription.setName(dName);
        viewpoint.getOwnedRepresentations().add((Object)diagramDescription);
        return diagramDescription;
    }

    public static AdditionalLayer createAdditionalLayer(String layerName) {
        AdditionalLayer res = DescriptionPackage.eINSTANCE.getDescriptionFactory().createAdditionalLayer();
        res.setName(layerName);
        res.setActiveByDefault(true);
        return res;
    }

    public static NodeMapping createNodeMapping(DiagramDescription diag, String label) {
        NodeMapping res = DescriptionPackage.eINSTANCE.getDescriptionFactory().createNodeMapping();
        res.setName(label);
        diag.getDefaultLayer().getNodeMappings().add((Object)res);
        return res;
    }

    public static ContainerMapping createContainerapping(DiagramDescription diag, String label) {
        ContainerMapping res = DescriptionPackage.eINSTANCE.getDescriptionFactory().createContainerMapping();
        res.setName(label);
        diag.getDefaultLayer().getContainerMappings().add((Object)res);
        return res;
    }

    public static FlatContainerStyleDescription createFlatContainerStyleDescription(ContainerMapping container) {
        FlatContainerStyleDescription res = StylePackage.eINSTANCE.getStyleFactory().createFlatContainerStyleDescription();
        container.setStyle((ContainerStyleDescription)res);
        return res;
    }

    public static EdgeMapping createEdgeMapping(DiagramDescription diag, String emName, String source, String target) {
        EdgeMapping res = DescriptionPackage.eINSTANCE.getDescriptionFactory().createEdgeMapping();
        res.setName(emName);
        res.setSourceFinderExpression(source);
        res.setTargetExpression(target);
        Layer layer = diag.getDefaultLayer();
        layer.getEdgeMappings().add((Object)res);
        return res;
    }

    public static EdgeMapping createEdgeMapping(DiagramDescription diag, String emName) {
        EdgeMapping res = DescriptionPackage.eINSTANCE.getDescriptionFactory().createEdgeMapping();
        res.setName(emName);
        Layer layer = diag.getDefaultLayer();
        layer.getEdgeMappings().add((Object)res);
        return res;
    }

    public static EdgeMapping createEdgeMapping(Layer layer, String emName) {
        EdgeMapping res = DescriptionPackage.eINSTANCE.getDescriptionFactory().createEdgeMapping();
        res.setName(emName);
        layer.getEdgeMappings().add((Object)res);
        return res;
    }

    public static ContainerMapping createContainerMapping(DiagramDescription description, String name) {
        ContainerMapping res = DescriptionPackage.eINSTANCE.getDescriptionFactory().createContainerMapping();
        res.setName(name);
        description.getDefaultLayer().getContainerMappings().add((Object)res);
        return res;
    }

    public static EdgeStyleDescription createStyleDescription(EdgeMapping edgeMapping) {
        EdgeStyleDescription res = StylePackage.eINSTANCE.getStyleFactory().createEdgeStyleDescription();
        edgeMapping.setStyle(res);
        return res;
    }

    public static CenterLabelStyleDescription createCenterLabelStyleDescription(EdgeStyleDescription edgeStyleDecl, String labelExpression) {
        CenterLabelStyleDescription res = StylePackage.eINSTANCE.getStyleFactory().createCenterLabelStyleDescription();
        res.setLabelExpression(labelExpression);
        res.setShowIcon(false);
        edgeStyleDecl.setCenterLabelStyleDescription(res);
        return res;
    }
}

