/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.ui.launcher;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.MessagingSystem;
import org.eclipse.gemoc.dsl.debug.ide.adapter.IDSLCurrentInstructionListener;
import org.eclipse.gemoc.executionframework.engine.Activator;
import org.eclipse.gemoc.executionframework.engine.commons.EngineContextException;
import org.eclipse.gemoc.executionframework.engine.ui.launcher.AbstractGemocLauncher;
import org.eclipse.gemoc.executionframework.extensions.sirius.services.AbstractGemocAnimatorServices;
import org.eclipse.gemoc.executionframework.extensions.sirius.services.AbstractGemocDebuggerServices;
import org.eclipse.gemoc.executionframework.extensions.sirius.services.IModelAnimator;
import org.eclipse.gemoc.xdsmlframework.api.core.EngineStatus;
import org.eclipse.gemoc.xdsmlframework.api.core.ExecutionMode;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionContext;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.core.IRunConfiguration;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractSequentialGemocLauncher<C extends IExecutionContext<R, ?, ?>, R extends IRunConfiguration>
extends AbstractGemocLauncher<C> {
    public static final String MODEL_ID = "org.eclipse.gemoc.executionframework.extensions.sirius.debugModel";
    protected IProgressMonitor launchProgressMonitor = null;
    private IExecutionEngine<C> _executionEngine;
    protected static final String executionStartedMessage = "Execution started successfully.";

    protected abstract IExecutionEngine<C> createExecutionEngine(R var1, ExecutionMode var2) throws CoreException, EngineContextException;

    protected abstract void prepareViews();

    protected abstract R parseLaunchConfiguration(ILaunchConfiguration var1) throws CoreException;

    protected abstract MessagingSystem getMessagingSystem();

    protected abstract void error(String var1, Exception var2);

    protected abstract void setDefaultsLaunchConfiguration(ILaunchConfigurationWorkingCopy var1);

    public final void launch(final ILaunchConfiguration configuration, final String mode, final ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            this.debug("About to initialize and run the GEMOC Execution Engine...");
            this.launchProgressMonitor = monitor;
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractSequentialGemocLauncher.this.prepareViews();
                }
            });
            R runConfiguration = this.parseLaunchConfiguration(configuration);
            ExecutionMode executionMode = null;
            executionMode = "debug".equals(mode) ? ExecutionMode.Animation : ExecutionMode.Run;
            if (this.isEngineAlreadyRunning(runConfiguration.getExecutedModelURI())) {
                return;
            }
            this._executionEngine = this.createExecutionEngine(runConfiguration, executionMode);
            this.openViewsRecommandedByAddons((IRunConfiguration)runConfiguration);
            Job job = new Job(this.getDebugJobName(configuration, this.getFirstInstruction(configuration))){

                protected IStatus run(IProgressMonitor monitor) {
                    if ("debug".equals(mode)) {
                        IModelAnimator animator = AbstractGemocAnimatorServices.getAnimator();
                        AbstractSequentialGemocLauncher.this._executionEngine.getExecutionContext().getExecutionPlatform().addEngineAddon((IEngineAddon)animator);
                        try {
                            AbstractSequentialGemocLauncher.super.launch(configuration, mode, launch, monitor);
                            return new Status(0, AbstractSequentialGemocLauncher.this.getPluginID(), AbstractSequentialGemocLauncher.executionStartedMessage);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            return new Status(4, AbstractSequentialGemocLauncher.this.getPluginID(), "Could not start execution engine.");
                        }
                    }
                    AbstractSequentialGemocLauncher.this._executionEngine.start();
                    AbstractSequentialGemocLauncher.this.debug(AbstractSequentialGemocLauncher.executionStartedMessage);
                    return new Status(0, AbstractSequentialGemocLauncher.this.getPluginID(), AbstractSequentialGemocLauncher.executionStartedMessage);
                }
            };
            this.debug("Initialization done, starting engine...");
            job.schedule();
        }
        catch (Exception e) {
            String message = "Error occured when starting execution engine: " + e.getMessage() + " (see inner exception).";
            this.error(message, e);
            throw new CoreException((IStatus)new Status(4, this.getPluginID(), message, (Throwable)e));
        }
    }

    private boolean isEngineAlreadyRunning(URI launchedModelURI) throws CoreException {
        Collection engines = Activator.getDefault().gemocRunningEngineRegistry.getRunningEngines().values();
        for (IExecutionEngine engine : engines) {
            if (engine.getRunningStatus() == EngineStatus.RunStatus.Stopped || !engine.getExecutionContext().getResourceModel().getURI().equals(launchedModelURI)) continue;
            String message = "An engine is already running on this model, please stop it first";
            this.warn(message);
            return true;
        }
        return false;
    }

    protected final void debug(String message) {
        this.getMessagingSystem().debug(message, this.getPluginID());
    }

    protected final void info(String message) {
        this.getMessagingSystem().info(message, this.getPluginID());
    }

    protected final void warn(final String message) {
        this.getMessagingSystem().warn(message, this.getPluginID());
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"GEMOC Engine Launcher", (String)message);
            }
        });
    }

    protected final void error(final String message) {
        this.getMessagingSystem().error(message, this.getPluginID());
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"GEMOC Engine Launcher", (String)message);
            }
        });
    }

    protected String getDebugTargetName(ILaunchConfiguration configuration, EObject firstInstruction) {
        return "Gemoc debug target";
    }

    protected final List<IDSLCurrentInstructionListener> getCurrentInstructionListeners() {
        List result = super.getCurrentInstructionListeners();
        result.add(AbstractGemocDebuggerServices.LISTENER);
        return result;
    }

    protected final EObject getFirstInstruction(ISelection selection) {
        return EcorePackage.eINSTANCE;
    }

    protected final EObject getFirstInstruction(IEditorPart editor) {
        return EcorePackage.eINSTANCE;
    }

    protected final EObject getFirstInstruction(ILaunchConfiguration configuration) {
        return EcorePackage.eINSTANCE;
    }

    protected final ILaunchConfiguration[] createLaunchConfiguration(IResource file, EObject firstInstruction, String mode) throws CoreException {
        ILaunchConfigurationWorkingCopy configuration;
        String selectedLanguage;
        ILaunchConfiguration[] launchConfigs = super.createLaunchConfiguration(file, firstInstruction, mode);
        if (launchConfigs.length == 1 && launchConfigs[0] instanceof ILaunchConfigurationWorkingCopy && (selectedLanguage = (configuration = (ILaunchConfigurationWorkingCopy)launchConfigs[0]).getAttribute("GEMOC_LAUNCH_SELECTED_LANGUAGE", "")).equals("")) {
            this.setDefaultsLaunchConfiguration(configuration);
            ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)configuration, (String)mode);
            if (group != null) {
                ILaunchConfiguration savedLaunchConfig = configuration.doSave();
                DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IStructuredSelection)new StructuredSelection((Object)savedLaunchConfig), (String)group.getIdentifier(), null);
            }
        }
        return launchConfigs;
    }

    @Override
    public IExecutionEngine<C> getExecutionEngine() {
        return this._executionEngine;
    }
}

