/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.ale.interpreted.engine;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecoretools.ale.ALEInterpreter;
import org.eclipse.emf.ecoretools.ale.core.interpreter.services.EvalBodyService;
import org.eclipse.emf.ecoretools.ale.core.interpreter.services.ServiceCallListener;
import org.eclipse.emf.ecoretools.ale.core.parser.Dsl;
import org.eclipse.emf.ecoretools.ale.core.parser.DslBuilder;
import org.eclipse.emf.ecoretools.ale.core.parser.visitor.ParseResult;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.gemoc.ale.interpreted.engine.Helper;
import org.eclipse.gemoc.execution.sequential.javaengine.K3RunConfiguration;
import org.eclipse.gemoc.execution.sequential.javaengine.SequentialModelExecutionContext;
import org.eclipse.gemoc.executionframework.engine.commons.DefaultExecutionPlatform;
import org.eclipse.gemoc.executionframework.engine.commons.DslHelper;
import org.eclipse.gemoc.executionframework.engine.core.AbstractSequentialExecutionEngine;
import org.eclipse.gemoc.executionframework.extensions.sirius.services.IModelAnimator;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.gemoc.api.IMultiDimensionalTraceAddon;
import org.eclipse.gemoc.trace.gemoc.api.ITraceViewListener;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterWithDiagnostic;

public class AleEngine
extends AbstractSequentialExecutionEngine<SequentialModelExecutionContext<K3RunConfiguration>, K3RunConfiguration> {
    EObject caller;
    List<ParseResult<ModelUnit>> parsedSemantics;
    List<Object> args;
    ALEInterpreter interpreter;
    private String mainOp;
    private String initOp;

    public String engineKindName() {
        return "ALE Engine";
    }

    protected void executeEntryPoint() {
        if (this.interpreter != null && this.parsedSemantics != null) {
            this.interpreter.addListener(new ServiceCallListener(){

                public void preCall(IService service, Object[] arguments) {
                    boolean isStep;
                    if (service instanceof EvalBodyService && (isStep = ((EvalBodyService)service).getImplem().getTags().contains((Object)"step")) && arguments[0] instanceof EObject) {
                        EObject currentCaller = (EObject)arguments[0];
                        String className = currentCaller.eClass().getName();
                        String methodName = service.getName();
                        AleEngine.this.beforeExecutionStep(currentCaller, className, methodName);
                    }
                }

                public void postCall(IService service, Object[] arguments, Object result) {
                    boolean isStep;
                    if (service instanceof EvalBodyService && (isStep = ((EvalBodyService)service).getImplem().getTags().contains((Object)"step"))) {
                        AleEngine.this.afterExecutionStep();
                    }
                }
            });
            IMultiDimensionalTraceAddon traceCandidate = null;
            final ArrayList<IModelAnimator> animators = new ArrayList<IModelAnimator>();
            for (IEngineAddon addon : ((DefaultExecutionPlatform)((SequentialModelExecutionContext)this.getExecutionContext()).getExecutionPlatform()).getEngineAddons()) {
                if (addon instanceof IMultiDimensionalTraceAddon) {
                    traceCandidate = (IMultiDimensionalTraceAddon)addon;
                    continue;
                }
                if (!(addon instanceof IModelAnimator)) continue;
                animators.add((IModelAnimator)addon);
            }
            final IMultiDimensionalTraceAddon traceAddon = traceCandidate;
            ITraceViewListener diagramUpdater = new ITraceViewListener(){

                public void update() {
                    for (IModelAnimator addon : animators) {
                        try {
                            if (traceAddon == null) continue;
                            Step nextStep = (Step)traceAddon.getTraceExplorer().getCurrentState().getStartedSteps().get(0);
                            addon.activate((Object)AleEngine.this.caller, nextStep);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            };
            if (traceAddon != null) {
                traceAddon.getTraceExplorer().registerCommand(diagramUpdater, () -> diagramUpdater.update());
            }
            Method entryPoint = this.getMainOp().orElse(null);
            if (this.interpreter.getCurrentEngine() != null) {
                EvaluationResult res = this.interpreter.getCurrentEngine().eval(this.caller, entryPoint, Arrays.asList(new Object[0]));
                this.interpreter.getLogger().diagnosticForHuman();
                if (res.getDiagnostic().getMessage() != null) {
                    System.out.println(res.getDiagnostic().getMessage());
                    throw new RuntimeException(res.getDiagnostic().getMessage());
                }
            } else {
                try {
                    IInterpreterWithDiagnostic.IEvaluationResult res = this.interpreter.eval(this.caller, entryPoint, Arrays.asList(new Object[0]), this.parsedSemantics);
                    this.interpreter.getLogger().diagnosticForHuman();
                    if (res.getDiagnostic().getMessage() != null) {
                        System.out.println(res.getDiagnostic().getMessage());
                        throw new RuntimeException(res.getDiagnostic().getMessage());
                    }
                }
                catch (ALEInterpreter.ClosedALEInterpreterException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            if (traceAddon != null) {
                traceAddon.getTraceExplorer().removeListener(diagramUpdater);
            }
        }
    }

    protected void initializeModel() {
        Optional<Method> init = this.getInitOp();
        if (this.interpreter != null && this.parsedSemantics != null && init.isPresent()) {
            try {
                IInterpreterWithDiagnostic.IEvaluationResult res = this.interpreter.eval(this.caller, init.get(), this.args, this.parsedSemantics);
                if (res.getDiagnostic().getMessage() != null) {
                    System.out.println(res.getDiagnostic().getMessage());
                    this.interpreter.getLogger().notify(res.getDiagnostic());
                    this.interpreter.getLogger().diagnosticForHuman();
                    throw new RuntimeException(res.getDiagnostic().getMessage());
                }
                this.interpreter.getLogger().diagnosticForHuman();
            }
            catch (ALEInterpreter.ClosedALEInterpreterException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    protected void prepareEntryPoint(SequentialModelExecutionContext<K3RunConfiguration> executionContext) {
    }

    protected void prepareInitializeModel(SequentialModelExecutionContext<K3RunConfiguration> executionContext) {
        if (executionContext.getRunConfiguration() instanceof K3RunConfiguration) {
            K3RunConfiguration runConf = (K3RunConfiguration)executionContext.getRunConfiguration();
            Resource inputModel = executionContext.getResourceModel();
            String rootPath = runConf.getModelEntryPoint();
            this.caller = inputModel.getEObject(rootPath);
            org.eclipse.gemoc.dsl.Dsl language = DslHelper.load((String)runConf.getLanguageName());
            this.args = Lists.newArrayList((Object[])runConf.getModelInitializationArguments().split("\n"));
            this.mainOp = runConf.getExecutionEntryPoint();
            this.initOp = runConf.getModelInitializationMethod();
            Dsl environment = Helper.gemocDslToAleDsl(language);
            this.interpreter = new ALEInterpreter();
            this.parsedSemantics = new DslBuilder(this.interpreter.getQueryEnvironment(), this.caller.eResource().getResourceSet()).parse(environment);
            HashSet projects = new HashSet();
            HashSet<String> plugins = new HashSet<String>();
            if (language.eResource().getURI().isPlatformPlugin()) {
                URI dslUri = language.eResource().getURI();
                String dslPlugin = (String)dslUri.segmentsList().get(1);
                plugins.add(dslPlugin);
                List<String> ecoreUris = Helper.getEcoreUris(language);
                for (String ecoreURI : ecoreUris) {
                    URI uri = URI.createURI((String)ecoreURI);
                    String plugin = (String)uri.segmentsList().get(1);
                    plugins.add(plugin);
                }
                List<String> aleUris = Helper.getAleUris(language);
                for (String aleURI : aleUris) {
                    URI uri = URI.createURI((String)aleURI);
                    String plugin = (String)uri.segmentsList().get(1);
                    plugins.add(plugin);
                }
            }
            this.interpreter.javaExtensions.updateScope(plugins, projects);
            this.interpreter.javaExtensions.reloadIfNeeded();
        }
    }

    public List<ModelUnit> getModelUnits() {
        if (this.parsedSemantics != null) {
            return this.parsedSemantics.stream().map(p -> (ModelUnit)p.getRoot()).filter(elem -> elem != null).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public ALEInterpreter getInterpreter() {
        return this.interpreter;
    }

    public Optional<Method> getMainOp() {
        ArrayList segments;
        if (this.mainOp != null && (segments = Lists.newArrayList((Object[])this.mainOp.split("::"))).size() >= 2) {
            String opName = (String)segments.get(segments.size() - 1);
            String typeName = (String)segments.get(segments.size() - 2);
            return this.getModelUnits().stream().flatMap(unit -> unit.getClassExtensions().stream()).filter(xtdCls -> xtdCls.getBaseClass().getName().equals(typeName)).flatMap(cls -> cls.getMethods().stream()).filter(op -> op.getTags().contains((Object)"main")).filter(op -> op.getOperationRef().getName().equals(opName)).findFirst();
        }
        return Optional.empty();
    }

    public Optional<Method> getInitOp() {
        ArrayList segments;
        if (this.initOp != null && (segments = Lists.newArrayList((Object[])this.initOp.split("::"))).size() >= 2) {
            String opName = (String)segments.get(segments.size() - 1);
            String typeName = (String)segments.get(segments.size() - 2);
            return this.getModelUnits().stream().flatMap(unit -> unit.getClassExtensions().stream()).filter(xtdCls -> xtdCls.getBaseClass().getName().equals(typeName)).flatMap(cls -> cls.getMethods().stream()).filter(op -> op.getTags().contains((Object)"init")).filter(op -> op.getOperationRef().getName().equals(opName)).findFirst();
        }
        return Optional.empty();
    }

    protected void finishDispose() {
        super.finishDispose();
        this.interpreter.close();
    }
}

