/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.parser;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public class Dsl {
    String sourceFile;
    List<String> allSyntaxes = new ArrayList<String>();
    List<String> allSemantics = new ArrayList<String>();

    public Dsl(List<String> syntaxes, List<String> semantics) {
        this.allSyntaxes.addAll(syntaxes);
        this.allSemantics.addAll(semantics);
    }

    public Dsl(String dslFile) throws FileNotFoundException {
        this(new FileInputStream(dslFile));
        this.sourceFile = dslFile;
    }

    public Dsl(InputStream input) {
        Properties dslProp = new Properties();
        try {
            dslProp.load(input);
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String allSyntaxes = (String)dslProp.get("syntax");
        String allBehaviors = (String)dslProp.get("behavior");
        if (allSyntaxes != null && allBehaviors != null) {
            String[] syntaxes = allSyntaxes.split(",");
            String[] behaviors = allBehaviors.split(",");
            this.allSyntaxes.addAll(this.trim(syntaxes));
            this.allSemantics.addAll(this.trim(behaviors));
        }
    }

    public List<String> getAllSemantics() {
        return this.allSemantics;
    }

    public List<String> getAllSyntaxes() {
        return this.allSyntaxes;
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public void save() {
        if (this.sourceFile != null) {
            Properties dslProp = new Properties();
            dslProp.put("syntax", String.join((CharSequence)",", this.allSyntaxes));
            dslProp.put("behavior", String.join((CharSequence)",", this.allSemantics));
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileOutputStream output = new FileOutputStream(this.sourceFile);){
                    dslProp.store(output, "");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected List<String> trim(String[] uris) {
        return Arrays.asList(uris).stream().map(s -> s.trim()).collect(Collectors.toList());
    }
}

