/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.commons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionPlatform;
import org.eclipse.gemoc.xdsmlframework.api.core.IModelLoader;
import org.eclipse.gemoc.xdsmlframework.api.core.IRunConfiguration;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.gemoc.xdsmlframework.api.extensions.engine_addon.EngineAddonSpecificationExtension;
import org.eclipse.gemoc.xdsmlframework.api.extensions.languages.LanguageDefinitionExtension;

public class DefaultExecutionPlatform
implements IExecutionPlatform {
    protected IModelLoader _modelLoader;
    protected Collection<IEngineAddon> _addons;
    private Object _addonLock = new Object();

    public DefaultExecutionPlatform(LanguageDefinitionExtension _languageDefinition, IRunConfiguration runConfiguration) throws CoreException {
        this._modelLoader = _languageDefinition.instanciateModelLoader();
        this._addons = new ArrayList<IEngineAddon>();
        for (EngineAddonSpecificationExtension extension : runConfiguration.getEngineAddonExtensions()) {
            this.addEngineAddon(extension.instanciateComponent());
        }
        for (IEngineAddon addon : _languageDefinition.instanciateEngineAddons()) {
            this.addEngineAddon(addon);
        }
    }

    public IModelLoader getModelLoader() {
        return this._modelLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<IEngineAddon> getEngineAddons() {
        Object object = this._addonLock;
        synchronized (object) {
            return Collections.unmodifiableCollection(new ArrayList<IEngineAddon>(this._addons));
        }
    }

    public void dispose() {
        this._addons.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEngineAddon(IEngineAddon addon) {
        Object object = this._addonLock;
        synchronized (object) {
            this._addons.add(addon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEngineAddon(IEngineAddon addon) {
        Object object = this._addonLock;
        synchronized (object) {
            this._addons.remove(addon);
        }
    }
}

