/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.debugger;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import fr.inria.diverse.melange.resource.MelangeResourceImpl;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.commons.eclipse.emf.EObjectUtil;
import org.eclipse.gemoc.dsl.debug.ide.IDSLDebugger;
import org.eclipse.gemoc.dsl.debug.ide.event.IDSLDebugEventProcessor;
import org.eclipse.gemoc.executionframework.debugger.AbstractGemocDebugger;
import org.eclipse.gemoc.executionframework.engine.core.EngineStoppedException;
import org.eclipse.gemoc.trace.commons.model.helper.StepHelper;
import org.eclipse.gemoc.trace.commons.model.trace.MSE;
import org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence;
import org.eclipse.gemoc.trace.commons.model.trace.ParallelStep;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class GenericSequentialModelDebugger
extends AbstractGemocDebugger {
    private static final EObject FAKE_INSTRUCTION = EcorePackage.eINSTANCE;
    private List<ToPushPop> toPushPop = new ArrayList<ToPushPop>();
    protected final String threadName = "Model debugging";
    protected int nbStackFrames = 0;
    protected boolean executionTerminated = false;
    protected final DefaultDeclarativeQualifiedNameProvider nameprovider = new DefaultDeclarativeQualifiedNameProvider();

    public GenericSequentialModelDebugger(IDSLDebugEventProcessor target, IExecutionEngine<?> engine) {
        super(target, engine);
    }

    public void start() {
        this.engine.start();
    }

    public void disconnect() {
    }

    protected void setupStepReturnPredicateBreak() {
        boolean _greaterThan;
        final IExecutionEngine seqEngine = this.engine;
        Deque stack = seqEngine.getCurrentStack();
        int _size = stack.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            Iterator it = stack.iterator();
            it.next();
            abstract class __GenericSequentialModelDebugger_1
            implements BiPredicate<IExecutionEngine<?>, Step<?>> {
                Step<?> steppedReturn;

                __GenericSequentialModelDebugger_1() {
                }
            }
            __GenericSequentialModelDebugger_1 ___GenericSequentialModelDebugger_1 = new __GenericSequentialModelDebugger_1(this, it){
                {
                    this.steppedReturn = (Step)iterator.next();
                }

                @Override
                public boolean test(IExecutionEngine<?> t, Step<?> u) {
                    boolean _contains = seqEngine.getCurrentStack().contains(this.steppedReturn);
                    return !_contains;
                }
            };
            this.addPredicateBreak(___GenericSequentialModelDebugger_1);
        }
    }

    public void steppingReturn(String threadName) {
        super.steppingReturn(threadName);
        this.setupStepReturnPredicateBreak();
    }

    protected void setupStepOverPredicateBreak() {
        abstract class __GenericSequentialModelDebugger_2
        implements BiPredicate<IExecutionEngine<?>, Step<?>> {
            IExecutionEngine<?> seqEngine;
            Step<?> steppedOver;

            __GenericSequentialModelDebugger_2() {
            }
        }
        __GenericSequentialModelDebugger_2 ___GenericSequentialModelDebugger_2 = new __GenericSequentialModelDebugger_2(this){
            {
                this.seqEngine = genericSequentialModelDebugger2.engine;
                this.steppedOver = this.seqEngine.getCurrentStep();
            }

            @Override
            public boolean test(IExecutionEngine<?> t, Step<?> u) {
                boolean _contains = this.seqEngine.getCurrentStack().contains(this.steppedOver);
                return !_contains;
            }
        };
        this.addPredicateBreak(___GenericSequentialModelDebugger_2);
    }

    public void steppingOver(String threadName) {
        super.steppingOver(threadName);
        this.setupStepOverPredicateBreak();
    }

    public boolean canStepInto(String threadName, EObject instruction) {
        boolean canStepInto;
        EObject currentInstruction = (EObject)this.currentInstructions.get(threadName);
        Step currentStep = this.engine.getCurrentStep();
        boolean correctObject = Objects.equal((Object)currentInstruction, (Object)instruction);
        boolean bl = canStepInto = !(currentStep instanceof ParallelStep);
        return correctObject && canStepInto;
    }

    public void steppingInto(String threadName) {
        super.steppingInto(threadName);
        this.addPredicateBreak(new BiPredicate<IExecutionEngine<?>, Step<?>>(){

            @Override
            public boolean test(IExecutionEngine<?> t, Step<?> u) {
                return true;
            }
        });
    }

    @Override
    public void pushStackFrame(String threadName, String frameName, EObject context, EObject instruction) {
        super.pushStackFrame(threadName, frameName, context, instruction);
        ++this.nbStackFrames;
    }

    @Override
    public void popStackFrame(String threadName) {
        super.popStackFrame(threadName);
        --this.nbStackFrames;
    }

    private String prettyObjectName(Object o) {
        String _switchResult = null;
        boolean _matched = false;
        if (o instanceof EObject) {
            _matched = true;
            _switchResult = this.prettyObjectName((EObject)o);
        }
        if (!_matched && o instanceof String) {
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("\"");
            _builder.append((String)o);
            _builder.append("\"");
            _switchResult = _builder.toString();
        }
        if (!_matched) {
            _switchResult = o.toString();
        }
        return _switchResult;
    }

    private String prettyObjectName(EObject o) {
        String resBasedName;
        String typeName = o.eClass().getName();
        String objectName = null;
        QualifiedName qn = this.nameprovider.getFullyQualifiedName(o);
        objectName = qn != null ? qn.toString() : ((resBasedName = EObjectUtil.getResourceBasedName((EObject)o, (boolean)false)) != null ? resBasedName : o.toString());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[");
        _builder.append(typeName);
        _builder.append("] ");
        _builder.append(objectName);
        return _builder.toString();
    }

    protected String prettyFrameName(MSEOccurrence mseoccurrence, boolean implicit) {
        if (mseoccurrence != null) {
            MSE mse = mseoccurrence.getMse();
            Functions.Function1<Object, String> _function = new Functions.Function1<Object, String>(){

                public String apply(Object it) {
                    return GenericSequentialModelDebugger.this.prettyObjectName(it);
                }
            };
            String args = IterableExtensions.join((Iterable)ListExtensions.map((List)mseoccurrence.getParameters(), (Functions.Function1)_function), (CharSequence)", ");
            String _prettyFrameName = this.prettyFrameName(mse, implicit);
            String _plus = String.valueOf(_prettyFrameName) + "(";
            String _plus_1 = String.valueOf(_plus) + args;
            return String.valueOf(_plus_1) + ")";
        }
        return null;
    }

    protected String prettyFrameName(MSE mse, boolean implicit) {
        if (mse != null) {
            EObject caller = mse.getCaller();
            String objectName = this.prettyObjectName(caller);
            String _xifexpression = null;
            if (implicit) {
                EOperation _action = mse.getAction();
                String _name = null;
                if (_action != null) {
                    _name = _action.getName();
                }
                _xifexpression = String.valueOf(_name) + "_implicitStep";
            } else {
                EOperation _action_1 = mse.getAction();
                String _name_1 = null;
                if (_action_1 != null) {
                    _name_1 = _action_1.getName();
                }
                _xifexpression = _name_1;
            }
            String opName = _xifexpression;
            String prettyName = String.valueOf(objectName) + "#" + opName;
            return prettyName;
        }
        return null;
    }

    protected MSEFrameInformation getMSEFrameInformation(Step<?> step) {
        MSEOccurrence mseOccurrence = step.getMseoccurrence();
        EObject container = step.eContainer();
        String prettyName = "";
        EObject caller = null;
        if (mseOccurrence != null) {
            caller = mseOccurrence.getMse().getCaller();
            prettyName = this.prettyFrameName(mseOccurrence, false);
        } else if (container != null && container instanceof Step && ((Step)container).getMseoccurrence() != null) {
            String _plus;
            MSE parentMSE = ((Step)container).getMseoccurrence().getMse();
            caller = parentMSE.getCaller();
            String _prettyFrameName = this.prettyFrameName(parentMSE, true);
            prettyName = _plus = String.valueOf(_prettyFrameName) + "()";
        } else if (step instanceof ParallelStep) {
            caller = step;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(" ");
            String _stepName = StepHelper.getStepName(step);
            _builder.append(_stepName, " ");
            _builder.append(" (");
            Functions.Function1<MSE, String> _function = new Functions.Function1<MSE, String>(){

                public String apply(MSE it) {
                    return it.getName();
                }
            };
            String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)StepHelper.getMSEs((Step)step), (Functions.Function1)_function), (CharSequence)", ");
            _builder.append(_join, " ");
            _builder.append(")");
            prettyName = _builder.toString();
        } else {
            caller = step;
            prettyName = "Unknown step";
        }
        return new MSEFrameInformation(caller, prettyName);
    }

    @Override
    public void updateStack(String threadName, EObject instruction) {
        ArrayDeque virtualStack = new ArrayDeque();
        for (ToPushPop m : this.toPushPop) {
            if (m.push) {
                virtualStack.push(m.step);
                continue;
            }
            boolean _isEmpty = virtualStack.isEmpty();
            if (_isEmpty) {
                this.popStackFrame(threadName);
                continue;
            }
            virtualStack.pop();
        }
        Iterator iterator = virtualStack.descendingIterator();
        while (iterator.hasNext()) {
            Step step = (Step)iterator.next();
            MSEFrameInformation info = this.getMSEFrameInformation(step);
            this.pushStackFrame(threadName, info.prettyLabel, info.caller, info.caller);
        }
        this.setCurrentInstruction(threadName, instruction);
        this.toPushPop.clear();
    }

    @Override
    public void updateData(String threadName, EObject instruction) {
        EObject realInstruction = instruction;
        if (instruction == null) {
            this.updateVariables(threadName);
            this.updateStack(threadName, null);
            return;
        }
        if (instruction instanceof Step) {
            boolean _tripleNotEquals;
            Step step = (Step)instruction;
            MSEOccurrence _mseoccurrence = step.getMseoccurrence();
            boolean bl = _tripleNotEquals = _mseoccurrence != null;
            if (_tripleNotEquals) {
                realInstruction = step.getMseoccurrence().getMse().getCaller();
            }
        } else if (instruction instanceof MSEOccurrence) {
            realInstruction = ((MSEOccurrence)instruction).getMse().getCaller();
        }
        super.updateData(threadName, realInstruction);
    }

    public boolean shouldBreak(EObject instruction) {
        if (instruction instanceof Step) {
            return this.shouldBreakStep((Step)instruction);
        }
        boolean _equals = Objects.equal((Object)instruction, (Object)FAKE_INSTRUCTION);
        return _equals;
    }

    private boolean hasRegularBreakpointTrue(EObject o) {
        MelangeResourceImpl mr;
        EObject target = o;
        Resource res = o.eResource();
        if (res != null && (mr = (MelangeResourceImpl)IterableExtensions.head((Iterable)Iterables.filter((Iterable)res.getResourceSet().getResources(), MelangeResourceImpl.class))) != null) {
            String uriFragment = res.getURIFragment(o);
            target = mr.getWrappedResource().getEObject(uriFragment);
        }
        return super.shouldBreak(target) && (Boolean.valueOf((String)((Object)this.getBreakpointAttributes(target, "org.eclipse.gemoc.gemoc_modeling_workbench.ui.breakpoint.breakOnLogicalStep"))) != false || Boolean.valueOf((String)((Object)this.getBreakpointAttributes(target, "org.eclipse.gemoc.gemoc_modeling_workbench.ui.breakpoint.breakOnMSE"))) != false);
    }

    private boolean shouldBreakStep(Step<?> step) {
        boolean _tripleNotEquals;
        boolean _shouldBreakPredicates = this.shouldBreakPredicates(this.engine, step);
        if (_shouldBreakPredicates) {
            return true;
        }
        MSEOccurrence _mseoccurrence = step.getMseoccurrence();
        boolean bl = _tripleNotEquals = _mseoccurrence != null;
        if (_tripleNotEquals) {
            MSE mse = step.getMseoccurrence().getMse();
            boolean _hasRegularBreakpointTrue = this.hasRegularBreakpointTrue((EObject)mse);
            if (_hasRegularBreakpointTrue) {
                return true;
            }
            EObject caller = mse.getCaller();
            boolean _hasRegularBreakpointTrue_1 = this.hasRegularBreakpointTrue(caller);
            if (_hasRegularBreakpointTrue_1) {
                return true;
            }
        }
        return false;
    }

    public EObject getNextInstruction(String threadName, EObject currentInstruction, IDSLDebugger.Stepping stepping) {
        return FAKE_INSTRUCTION;
    }

    public void engineStarted(IExecutionEngine<?> executionEngine) {
        this.spawnRunningThread("Model debugging", (EObject)this.engine.getExecutionContext().getResourceModel().getContents().get(0));
    }

    public void engineStopped(IExecutionEngine<?> engine) {
        boolean _not;
        boolean _isTerminated = this.isTerminated("Model debugging");
        boolean bl = _not = !_isTerminated;
        if (_not) {
            this.terminated("Model debugging");
        }
    }

    public void aboutToExecuteStep(IExecutionEngine<?> executionEngine, Step<?> step) {
        ToPushPop stackModification = new ToPushPop(step, true);
        this.toPushPop.add(stackModification);
        boolean shallcontinue = this.control("Model debugging", (EObject)step);
        if (!shallcontinue) {
            throw new EngineStoppedException("Debug thread has stopped.");
        }
    }

    public void stepExecuted(IExecutionEngine<?> engine, Step<?> step) {
        ToPushPop stackModification = new ToPushPop(step, false);
        this.toPushPop.add(stackModification);
    }

    public void engineAboutToStop(IExecutionEngine<?> engine) {
        this.executionTerminated = true;
    }

    public void terminate() {
        super.terminate();
        this.engine.stop();
    }

    public static class MSEFrameInformation {
        public final EObject caller;
        public final String prettyLabel;

        public MSEFrameInformation(EObject caller, String prettyLabel) {
            this.caller = caller;
            this.prettyLabel = prettyLabel;
        }
    }

    private static class ToPushPop {
        public Step<?> step;
        public boolean push;

        public ToPushPop(Step<?> step, boolean push) {
            this.step = step;
            this.push = push;
        }
    }
}

