/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.validation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecoretools.ale.ALEInterpreter;
import org.eclipse.emf.ecoretools.ale.OrderedSet;
import org.eclipse.emf.ecoretools.ale.SeqType;
import org.eclipse.emf.ecoretools.ale.Sequence;
import org.eclipse.emf.ecoretools.ale.SetType;
import org.eclipse.emf.ecoretools.ale.Unit;
import org.eclipse.emf.ecoretools.ale.core.parser.Dsl;
import org.eclipse.emf.ecoretools.ale.core.parser.DslBuilder;
import org.eclipse.emf.ecoretools.ale.core.validation.ALEValidator;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.validation.AbstractAleValidator;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.HiddenLeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class AleValidator
extends AbstractAleValidator {
    public static String ALE_MARKER = "org.eclipse.emf.ecoretools.ale.xtext.AleMarker";

    @Check
    public void checkIsValid(Unit root) {
        try {
            IFile aleFile = WorkspaceSynchronizer.getFile((Resource)root.eResource());
            this.cleanUpMarkers(aleFile);
            IPath dslPath = aleFile.getFullPath().removeFileExtension().addFileExtension("dsl");
            IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
            IFile dslFile = ws.getFile(dslPath);
            InputStream _contents = dslFile.getContents();
            Dsl dsl = new Dsl(_contents);
            AleValidator.resolveUris(dsl);
            try (ALEInterpreter interpreter = new ALEInterpreter();){
                String _name = dslFile.getProject().getName();
                interpreter.initScope((Set)Sets.newHashSet(), (Set)Sets.newHashSet((Object[])new String[]{_name}));
                IQueryEnvironment _queryEnvironment = interpreter.getQueryEnvironment();
                List parsedSemantics = new DslBuilder(_queryEnvironment).parse(dsl);
                Functions.Function1 _function = it -> (ModelUnit)it.getRoot();
                Functions.Function1 _function_1 = it -> it.getServices();
                List services = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map((List)parsedSemantics, (Functions.Function1)_function)), (Functions.Function1)_function_1)));
                interpreter.registerServices(services);
                IQueryEnvironment _queryEnvironment_1 = interpreter.getQueryEnvironment();
                ALEValidator validator = new ALEValidator(_queryEnvironment_1);
                validator.validate(parsedSemantics);
                List msgs = validator.getMessages();
                Consumer<IValidationMessage> _function_2 = msg -> {
                    try {
                        IMarker marker = aleFile.createMarker(ALE_MARKER);
                        marker.setAttribute("message", (Object)msg.getMessage());
                        marker.setAttribute("severity", this.severityOf((IValidationMessage)msg));
                        marker.setAttribute("charStart", msg.getStartPosition());
                        marker.setAttribute("charEnd", msg.getEndPosition());
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                msgs.forEach(_function_2);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Object severityOf(IValidationMessage message) {
        Object _switchResult = null;
        ValidationMessageLevel _level = message.getLevel();
        if (_level != null) {
            switch (_level) {
                case INFO: {
                    _switchResult = 0;
                    break;
                }
                case WARNING: {
                    _switchResult = 1;
                    break;
                }
                case ERROR: {
                    _switchResult = 2;
                    break;
                }
                default: {
                    _switchResult = ValidationMessageLevel.ERROR;
                    break;
                }
            }
        } else {
            _switchResult = ValidationMessageLevel.ERROR;
        }
        return _switchResult;
    }

    @Check
    public void checkSequenceInitialization(Sequence sequence) {
        this.checkNoExtraSpaceAfterKeyword(sequence, "Sequence", "Sequence initialization");
    }

    @Check
    public void checkOrderedSetInitialization(OrderedSet orderedSet) {
        this.checkNoExtraSpaceAfterKeyword(orderedSet, "OrderedSet", "OrderedSet initialization");
    }

    @Check
    public void checkSequenceTypeDeclaration(SeqType seqType) {
        this.checkNoExtraSpaceAfterKeyword(seqType, "Sequence", "Sequence type declaration");
    }

    @Check
    public void checkOrderedSetTypeDeclaration(SetType setType) {
        this.checkNoExtraSpaceAfterKeyword(setType, "OrderedSet", "OrderedSet type declaration");
    }

    public void checkNoExtraSpaceAfterKeyword(EObject grammarElement, String keyword, String message) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)grammarElement);
        Functions.Function1 _function = it -> it.getGrammarElement() instanceof Keyword && ((Keyword)it.getGrammarElement()).getValue().equals(keyword);
        INode keywordNode = (INode)IterableExtensions.findFirst((Iterable)node.getChildren(), (Functions.Function1)_function);
        INode _nextSibling = keywordNode.getNextSibling();
        if (_nextSibling instanceof HiddenLeafNode) {
            this.getMessageAcceptor().acceptError("Extra space in " + message, grammarElement, keywordNode.getEndOffset(), keywordNode.getNextSibling().getLength(), "", new String[0]);
        }
    }

    public static void resolveUris(Dsl dsl) {
        ArrayList newSemantics = new ArrayList();
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        Consumer<String> _function = elem -> {
            URI uri = URI.createURI((String)elem);
            if (ws != null && uri.isPlatform()) {
                IResource file = ws.getRoot().findMember(uri.toPlatformString(true));
                String path = file.getLocationURI().getRawPath();
                newSemantics.add(path);
            } else {
                newSemantics.add(elem);
            }
        };
        dsl.getAllSemantics().forEach(_function);
        dsl.getAllSemantics().clear();
        dsl.getAllSemantics().addAll(newSemantics);
    }

    private void cleanUpMarkers(IFile file) {
        try {
            file.deleteMarkers(ALE_MARKER, true, 0);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

