/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.emf.type.core.ClientContext;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextAddedEvent;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextRemovedEvent;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IClientContextManagerListener;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IElementTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.MultiClientContext;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypeDebugOptions;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePlugin;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.IEditHelperAdviceDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.impl.DefaultClientContext;
import org.eclipse.gmf.runtime.emf.type.core.internal.impl.XMLClientContext;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;

public final class ClientContextManager {
    public static final String ELEMENT_TYPE_BINDINGS_EXT_P_NAME = "elementTypeBindings";
    private static final String E_CLIENT_CONTEXT = "clientContext";
    private static final String E_BINDING = "binding";
    private static final String A_CONTEXT = "context";
    private static final String E_ELEMENT_TYPE = "elementType";
    private static final String E_ADVICE = "advice";
    private static final String A_REF = "ref";
    private static final String A_PATTERN = "pattern";
    private static final ClientContextManager INSTANCE = new ClientContextManager();
    private final Set clientContexts = new HashSet();
    private final Map clientContextMap = new HashMap();
    private final CopyOnWriteArrayList<IClientContextManagerListener> listeners = new CopyOnWriteArrayList();
    private ExtensionTracker extensionTracker;
    private IExtensionChangeHandler extensionListener;

    private ClientContextManager() {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(EMFTypePlugin.getPluginId(), ELEMENT_TYPE_BINDINGS_EXT_P_NAME);
        if (EMFTypePlugin.isDynamicAware()) {
            this.startExtensionTracking();
        }
        this.configureElementTypeBindings(configs);
    }

    private void startExtensionTracking() {
        this.extensionListener = new IExtensionChangeHandler(){

            public void addExtension(IExtensionTracker tracker, IExtension extension) {
                ClientContextManager.this.configureElementTypeBindings(extension.getConfigurationElements());
            }

            public void removeExtension(IExtension extension, Object[] objects) {
            }
        };
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(EMFTypePlugin.getPluginId(), ELEMENT_TYPE_BINDINGS_EXT_P_NAME);
        this.extensionTracker = new ExtensionTracker();
        this.extensionTracker.registerHandler(this.extensionListener, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)point));
    }

    public static final ClientContextManager getInstance() {
        return INSTANCE;
    }

    public static final IClientContext getDefaultClientContext() {
        return ClientContextManager.getInstance().getClientContext("org.eclipse.gmf.runtime.emf.type.core.defaultContext");
    }

    public IClientContext getClientContext(String contextId) {
        if ("org.eclipse.gmf.runtime.emf.type.core.defaultContext".equals(contextId)) {
            return DefaultClientContext.getInstance();
        }
        return (IClientContext)this.clientContextMap.get(contextId);
    }

    public Set getClientContexts() {
        return this.clientContexts;
    }

    public IClientContext getClientContextFor(EObject eObject) {
        ArrayList<IClientContext> contexts = new ArrayList<IClientContext>();
        Iterator iter = this.getClientContexts().iterator();
        while (iter.hasNext()) {
            IClientContext next = (IClientContext)iter.next();
            IElementMatcher matcher = next.getMatcher();
            try {
                if (!matcher.matches(eObject)) continue;
                contexts.add(next);
            }
            catch (RuntimeException e) {
                iter.remove();
                this.clientContextMap.remove(next.getId());
                Trace.catching((Plugin)EMFTypePlugin.getPlugin(), (String)EMFTypeDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getClientContextsFor", (Throwable)e);
                Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)70, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.client_matcherFailure_ERROR_, (Object)next.getId()), (Throwable)e);
            }
        }
        return this.getClientContext(contexts);
    }

    private IClientContext getClientContext(Collection contexts) {
        IClientContext result = DefaultClientContext.getInstance();
        if (contexts.size() > 1) {
            result = new MultiClientContext(contexts);
        } else if (!contexts.isEmpty()) {
            result = (IClientContext)contexts.iterator().next();
        }
        return result;
    }

    public IClientContext getBinding(IElementTypeDescriptor elementTypeDescriptor) {
        ArrayList<IClientContext> result = new ArrayList<IClientContext>();
        for (IClientContext next : this.getClientContexts()) {
            if (!next.includes(elementTypeDescriptor)) continue;
            result.add(next);
        }
        return this.getClientContext(result);
    }

    public IClientContext getBinding(IElementType elementType) {
        ArrayList<IClientContext> result = new ArrayList<IClientContext>();
        for (IClientContext next : this.getClientContexts()) {
            if (!next.includes(elementType)) continue;
            result.add(next);
        }
        return this.getClientContext(result);
    }

    public IClientContext getBinding(IEditHelperAdviceDescriptor advice) {
        ArrayList<IClientContext> result = new ArrayList<IClientContext>();
        for (IClientContext next : this.getClientContexts()) {
            if (!next.includes(advice)) continue;
            result.add(next);
        }
        return this.getClientContext(result);
    }

    private synchronized void configureElementTypeBindings(IConfigurationElement[] elements) {
        this.configureClientContexts(elements);
        this.configureBindings(elements);
    }

    public void registerClientContext(IClientContext clientContext) {
        if (this.clientContexts.add(clientContext)) {
            this.clientContextMap.put(clientContext.getId(), clientContext);
            this.fireClientContextAdded(clientContext);
        }
    }

    public boolean isDynamic(IClientContext clientContext) {
        boolean result = true;
        if (clientContext instanceof ClientContext) {
            result = ((ClientContext)clientContext).isDynamic();
        }
        return result;
    }

    public boolean deregisterClientContext(IClientContext clientContext) {
        boolean result = false;
        IClientContext existing = (IClientContext)this.clientContextMap.get(clientContext.getId());
        if (existing != null) {
            if (existing != clientContext) {
                Log.warning((Plugin)EMFTypePlugin.getPlugin(), (int)81, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.wrong_type_WARN_, (Object[])new Object[]{clientContext.getId(), EMFTypeCoreMessages.invalid_action_remove_context_WARN_, clientContext.toString(), existing.toString()}));
            } else if (!this.isDynamic(clientContext)) {
                Log.warning((Plugin)EMFTypePlugin.getPlugin(), (int)82, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.dependency_constraint_WARN_, (Object[])new Object[]{clientContext.getId(), EMFTypeCoreMessages.invalid_action_remove_context_WARN_, EMFTypeCoreMessages.dependency_reason_static_WARN_}));
            } else {
                this.clientContextMap.remove(clientContext.getId());
                this.clientContexts.remove(clientContext);
                result = true;
            }
        }
        if (result) {
            this.fireClientContextRemoved(clientContext);
        }
        return result;
    }

    private void configureClientContexts(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement config = elements[i];
            if (E_CLIENT_CONTEXT.equals(config.getName())) {
                String sourcePluginId;
                try {
                    XMLClientContext context = new XMLClientContext(config);
                    if (this.clientContexts.add(context)) {
                        this.clientContextMap.put(context.getId(), context);
                    }
                }
                catch (CoreException ce) {
                    sourcePluginId = config.getDeclaringExtension().getContributor().getName();
                    Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)ce.getStatus().getCode(), (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.xml_parsing_elementTypeBindings_ERROR_, (Object)sourcePluginId, (Object)ce.getStatus().getMessage()), (Throwable)ce);
                }
                catch (Exception e) {
                    sourcePluginId = config.getDeclaringExtension().getContributor().getName();
                    Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)10, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.xml_parsing_elementTypeBindings_ERROR_, (Object)sourcePluginId, (Object)e.getMessage()), (Throwable)e);
                }
            }
            ++i;
        }
    }

    private void configureBindings(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement config = elements[i];
            if (E_BINDING.equals(config.getName())) {
                String contextId = config.getAttribute(A_CONTEXT);
                if (contextId == null) {
                    Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)60, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.xml_parsing_elementTypeBindings_ERROR_, (Object)config.getDeclaringExtension().getContributor().getName(), (Object)EMFTypeCoreMessages.binding_noContextId_ERROR_));
                } else {
                    ClientContext context = (ClientContext)this.getClientContext(contextId);
                    if (context == null) {
                        Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)61, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.xml_parsing_elementTypeBindings_ERROR_, (Object)config.getDeclaringExtension().getContributor().getName(), (Object)EMFTypeCoreMessages.binding_noSuchContext_ERROR_));
                    } else {
                        this.configureBindings(context, config);
                    }
                }
            }
            ++i;
        }
    }

    private void configureBindings(ClientContext context, IConfigurationElement config) {
        this.configureBindings(context, config, E_ELEMENT_TYPE);
        this.configureBindings(context, config, E_ADVICE);
    }

    private void configureBindings(ClientContext context, IConfigurationElement config, String elementName) {
        IConfigurationElement[] children = config.getChildren(elementName);
        int i = 0;
        while (i < children.length) {
            String ref = children[i].getAttribute(A_REF);
            String patternString = children[i].getAttribute(A_PATTERN);
            if (ref == null && patternString == null) {
                Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)63, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.xml_parsing_elementTypeBindings_ERROR_, (Object)config.getDeclaringExtension().getContributor().getName(), (Object)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.binding_no_ref_or_pattern_ERROR_, (Object)context.getId())));
                return;
            }
            if (ref != null && patternString != null) {
                Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)64, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.xml_parsing_elementTypeBindings_ERROR_, (Object)config.getDeclaringExtension().getContributor().getName(), (Object)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.binding_both_ref_and_pattern_ERROR_, (Object)context.getId())));
                return;
            }
            if (ref != null) {
                context.bindId(ref);
            } else {
                try {
                    Pattern pattern = Pattern.compile(patternString);
                    context.bindPattern(pattern);
                }
                catch (PatternSyntaxException pse) {
                    Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)62, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.xml_parsing_elementTypeBindings_ERROR_, (Object)config.getDeclaringExtension().getContributor().getName(), (Object)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.pattern_invalid_syntax_ERROR_, (Object)patternString)), (Throwable)pse);
                }
            }
            ++i;
        }
    }

    public void addClientContextManagerListener(IClientContextManagerListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeClientContextManagerListener(IClientContextManagerListener listener) {
        this.listeners.remove(listener);
    }

    private void fireClientContextAdded(IClientContext context) {
        if (!this.listeners.isEmpty()) {
            ClientContextAddedEvent event = new ClientContextAddedEvent(context);
            for (IClientContextManagerListener next : this.listeners) {
                try {
                    next.clientContextAdded(event);
                }
                catch (Exception e) {
                    Log.warning((Plugin)EMFTypePlugin.getPlugin(), (int)90, (String)EMFTypeCoreMessages.contextManager_listener_exception_WARN_, (Throwable)e);
                }
            }
        }
    }

    private void fireClientContextRemoved(IClientContext context) {
        if (!this.listeners.isEmpty()) {
            ClientContextRemovedEvent event = new ClientContextRemovedEvent(context);
            for (IClientContextManagerListener next : this.listeners) {
                try {
                    next.clientContextRemoved(event);
                }
                catch (Exception e) {
                    Log.warning((Plugin)EMFTypePlugin.getPlugin(), (int)90, (String)EMFTypeCoreMessages.contextManager_listener_exception_WARN_, (Throwable)e);
                }
            }
        }
    }
}

