/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.eclipse.equinox.internal.p2.metadata.repository.Messages;
import org.eclipse.osgi.util.NLS;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZOutputStream;

public class XZCompressor {
    private static final String CONTENT_XML_XZ = "content.xml.xz";
    private static final String ARTIFACTS_XML_XZ = "artifacts.xml.xz";
    private static final String ARTIFACTS2 = "artifacts";
    private static final String CONTENT = "content";
    private static final String JAR = ".jar";
    private static final String XML = ".xml";
    private String repoFolder;
    private boolean preserveOriginalFile = true;
    private ArrayList<File> filesToDelete = new ArrayList();

    public String getRepoFolder() {
        return this.repoFolder;
    }

    public void setRepoFolder(String repoFolder) {
        this.repoFolder = repoFolder;
    }

    public boolean isPreserveOriginalFile() {
        return this.preserveOriginalFile;
    }

    public void setPreserveOriginalFile(boolean preserveOriginalFile) {
        this.preserveOriginalFile = preserveOriginalFile;
    }

    private File uncompressJar(File jarFile, String fileToExtract) throws IOException {
        JarInputStream jarStream = new JarInputStream(new FileInputStream(jarFile));
        JarEntry jarEntry = jarStream.getNextJarEntry();
        while (jarEntry != null && !fileToExtract.equals(jarEntry.getName())) {
            jarEntry = jarStream.getNextJarEntry();
        }
        if (jarEntry == null) {
            jarStream.close();
            throw new IOException(NLS.bind((String)Messages.repoMan_invalidLocation, (Object)jarFile.getAbsolutePath()));
        }
        BufferedInputStream input = null;
        OutputStream output = null;
        File extractedFile = new File(jarFile.getAbsoluteFile().getParent(), fileToExtract);
        try {
            input = new BufferedInputStream(jarStream);
            output = new BufferedOutputStream(new FileOutputStream(extractedFile));
            byte[] buffer = new byte[8192];
            int bytesRead = 0;
            while ((bytesRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.close();
            }
        }
        this.filesToDelete.add(extractedFile);
        return extractedFile;
    }

    private File getMetadataFile(String prefix) throws IOException {
        File candidate = new File(this.repoFolder, String.valueOf(prefix) + XML);
        if (candidate.exists()) {
            if (!this.preserveOriginalFile) {
                this.filesToDelete.add(candidate);
            }
            return candidate;
        }
        candidate = new File(this.repoFolder, String.valueOf(prefix) + JAR);
        if (candidate.exists()) {
            if (!this.preserveOriginalFile) {
                this.filesToDelete.add(candidate);
            }
            return this.uncompressJar(candidate, String.valueOf(prefix) + XML);
        }
        return null;
    }

    public void compressRepo() throws IOException {
        File artifacts;
        File metadata = this.getMetadataFile(CONTENT);
        if (metadata != null) {
            this.compressFile(metadata, new File(this.repoFolder, CONTENT_XML_XZ));
        }
        if ((artifacts = this.getMetadataFile(ARTIFACTS2)) != null) {
            this.compressFile(artifacts, new File(this.repoFolder, ARTIFACTS_XML_XZ));
        }
        this.createP2Index(metadata != null, artifacts != null);
        this.deleteFiles();
    }

    private void deleteFiles() {
        Iterator<File> iterator = this.filesToDelete.iterator();
        while (iterator.hasNext()) {
            iterator.next().delete();
        }
    }

    private void compressFile(File input, File output) throws IOException {
        LZMA2Options options = new LZMA2Options();
        try {
            options.setDictSize(0x800000);
            options.setLcLp(3, 0);
            options.setPb(4);
            options.setMode(2);
            options.setNiceLen(273);
            options.setMatchFinder(20);
            options.setDepthLimit(512);
        }
        catch (UnsupportedOptionsException unsupportedOptionsException) {}
        XZOutputStream out = null;
        FileInputStream is = null;
        try {
            int size;
            out = new XZOutputStream((OutputStream)new FileOutputStream(output), (FilterOptions)options);
            is = new FileInputStream(input);
            byte[] buf = new byte[8192];
            while ((size = is.read(buf)) != -1) {
                out.write(buf, 0, size);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    private void createP2Index(boolean metadata, boolean artifacts) throws IOException {
        Properties p2Index = new Properties();
        if (metadata) {
            if (this.preserveOriginalFile) {
                p2Index.setProperty("metadata.repository.factory.order", "content.xml.xz,content.xml,!");
            } else {
                p2Index.setProperty("metadata.repository.factory.order", "content.xml.xz,!");
            }
        }
        if (artifacts) {
            if (this.preserveOriginalFile) {
                p2Index.setProperty("artifact.repository.factory.order", "artifacts.xml.xz,artifacts.xml,!");
            } else {
                p2Index.setProperty("artifact.repository.factory.order", "artifacts.xml.xz,!");
            }
        }
        p2Index.setProperty("version", "1");
        try (OutputStream output = null;){
            output = new FileOutputStream(new File(this.repoFolder, "p2.index"));
            p2Index.store(output, null);
        }
    }
}

