/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.base.collect;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.sirius.ext.base.collect.SetIntersection;

public class GSetIntersection<E>
extends SetIntersection<E> {
    private Set<E> newElements = Sets.newLinkedHashSet();
    private BiMap<Integer, E> oldElements = HashBiMap.create();
    private List<E> extraElementsToDelete = Lists.newArrayList();

    @Override
    public void addInNew(E newObj) {
        this.newElements.add(newObj);
    }

    @Override
    public void addInOld(E oldObj) {
        Object previouslyStored = this.oldElements.put((Object)oldObj.hashCode(), oldObj);
        if (previouslyStored != null) {
            this.extraElementsToDelete.add(oldObj);
        }
    }

    @Override
    public Iterable<E> getAllElements() {
        ArrayList intersection = Lists.newArrayList();
        for (E newElement : this.newElements) {
            Object alreadyThere = this.oldElements.get((Object)newElement.hashCode());
            if (alreadyThere != null) {
                intersection.add(alreadyThere);
                continue;
            }
            intersection.add(newElement);
        }
        return intersection;
    }

    @Override
    public Iterable<E> getKeptElements() {
        ArrayList intersection = Lists.newArrayList();
        for (E newElement : this.newElements) {
            Object alreadyThere = this.oldElements.get((Object)newElement.hashCode());
            if (alreadyThere == null) continue;
            intersection.add(alreadyThere);
        }
        return intersection;
    }

    @Override
    public Iterable<E> getRemovedElements() {
        return Iterables.concat(this.extraElementsToDelete, (Iterable)Sets.difference((Set)this.oldElements.values(), this.newElements));
    }

    @Override
    public Set<E> getNewElements() {
        return Sets.difference(this.newElements, (Set)this.oldElements.values());
    }
}

