/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.discovery.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.amalgam.discovery.DiscoveryDefinition;
import org.eclipse.amalgam.discovery.InstallableComponent;
import org.eclipse.amalgam.discovery.core.DiscoveryDefinitionBrowser;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallationStatusUpdater {
    private DiscoveryDefinitionBrowser discovery;

    public InstallationStatusUpdater(DiscoveryDefinition newdiscovery) {
        this.discovery = new DiscoveryDefinitionBrowser(newdiscovery);
    }

    public void update(IProgressMonitor monitor) throws InterruptedException {
        IBundleGroupProvider[] bundleGroupProviders;
        HashSet<String> installedFeatures = new HashSet<String>();
        IBundleGroupProvider[] iBundleGroupProviderArray = bundleGroupProviders = Platform.getBundleGroupProviders();
        int n = bundleGroupProviders.length;
        int n2 = 0;
        while (n2 < n) {
            IBundleGroup[] bundleGroups;
            IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            IBundleGroup[] iBundleGroupArray = bundleGroups = provider.getBundleGroups();
            int n3 = bundleGroups.length;
            int n4 = 0;
            while (n4 < n3) {
                IBundleGroup group = iBundleGroupArray[n4];
                installedFeatures.add(group.getIdentifier());
                ++n4;
            }
            ++n2;
        }
        for (InstallableComponent comp : this.discovery.getAllInstallableComponents()) {
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            if (!this.allFeaturesAreAlreadyInstalled(installedFeatures, comp) && !this.oneOfTheseIsAlreadyInstalled(comp.getHiddingFeatureID(), installedFeatures)) continue;
            comp.setInstalled(true);
        }
    }

    private boolean oneOfTheseIsAlreadyInstalled(EList<String> hiddingFeatureID, Set<String> installedFeatures) {
        boolean oneIsInstalled = false;
        Iterator it = hiddingFeatureID.iterator();
        while (it.hasNext() && !oneIsInstalled) {
            oneIsInstalled = installedFeatures.contains(it.next());
        }
        return oneIsInstalled;
    }

    private boolean allFeaturesAreAlreadyInstalled(Set<String> installedFeatures, InstallableComponent comp) {
        return installedFeatures.containsAll((Collection<?>)comp.getId());
    }
}

