/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;

@API(status=API.Status.STABLE, since="1.0")
public class FilePosition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int line;
    private final Integer column;

    public static FilePosition from(int line) {
        return new FilePosition(line);
    }

    public static FilePosition from(int line, int column) {
        return new FilePosition(line, column);
    }

    private FilePosition(int line) {
        Preconditions.condition((line > 0 ? 1 : 0) != 0, (String)"line number must be greater than zero");
        this.line = line;
        this.column = null;
    }

    private FilePosition(int line, int column) {
        Preconditions.condition((line > 0 ? 1 : 0) != 0, (String)"line number must be greater than zero");
        Preconditions.condition((column > 0 ? 1 : 0) != 0, (String)"column number must be greater than zero");
        this.line = line;
        this.column = column;
    }

    public int getLine() {
        return this.line;
    }

    public Optional<Integer> getColumn() {
        return Optional.ofNullable(this.column);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilePosition that = (FilePosition)o;
        return this.line == that.line && Objects.equals(this.column, that.column);
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("line", (Object)this.line).append("column", (Object)this.getColumn().orElse(-1)).toString();
    }
}

