/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.opsemanticsview.gen.k3;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import opsemanticsview.OperationalSemanticsView;
import opsemanticsview.OpsemanticsviewFactory;
import opsemanticsview.Rule;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gemoc.commons.eclipse.jdt.CallHierarchyHelper;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class K3StepExtractor {
    private final Set<IType> allClasses;
    private final EPackage extendedMetamodel;
    private final OperationalSemanticsView ecoreExtension;
    private final Map<IType, EClass> stepAspectsClassToAspectedClasses = new HashMap<IType, EClass>();
    private final Set<IMethod> allMethods = new HashSet<IMethod>();
    private final Set<IMethod> allk3Methods = new HashSet<IMethod>();
    private final Set<IMethod> allSuperMethods = new HashSet<IMethod>();
    private final Set<IMethod> stepFunctions = new HashSet<IMethod>();
    private final Set<IMethod> eventFunctions = new HashSet<IMethod>();
    private final Map<IMethod, Rule> functionToRule = new HashMap<IMethod, Rule>();
    private final Set<IType> inspectedClasses = new HashSet<IType>();
    private final Map<IMethod, IMethod> methodToK3Method = new HashMap<IMethod, IMethod>();
    private final Map<IMethod, IMethod> k3MethodToMethod = new HashMap<IMethod, IMethod>();
    private final Map<IMethod, IMethod> superMethodTok3Method = new HashMap<IMethod, IMethod>();
    private final Map<IMethod, Set<IMethod>> k3MethodToCalledMethods = new HashMap<IMethod, Set<IMethod>>();
    private final Map<IMethod, Set<IMethod>> methodToOverridingMethods = new HashMap<IMethod, Set<IMethod>>();
    private final Map<IMethod, Set<IMethod>> callGraph = new HashMap<IMethod, Set<IMethod>>();
    private final Map<IType, Set<IType>> classToSubClasses = new HashMap<IType, Set<IType>>();
    private final Map<IType, Set<IType>> classToSuperClasses = new HashMap<IType, Set<IType>>();

    public K3StepExtractor(Set<IType> aspects, String languageName, EPackage extendedMetamodel, OperationalSemanticsView inConstructionOperationalSemanticsView) {
        this.allClasses = aspects;
        this.extendedMetamodel = extendedMetamodel;
        this.ecoreExtension = inConstructionOperationalSemanticsView;
    }

    public void generate() {
        this.generateStepFromXtend(this.allClasses);
    }

    private Rule getRuleOfFunction(final IMethod function) {
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _containsKey = this.functionToRule.containsKey(function);
        if (_containsKey) {
            return this.functionToRule.get(function);
        }
        Rule rule = OpsemanticsviewFactory.eINSTANCE.createRule();
        EList _rules = this.ecoreExtension.getRules();
        _rules.add((Object)rule);
        IType containingClass = function.getDeclaringType();
        EClass _get = this.stepAspectsClassToAspectedClasses.get(containingClass);
        rule.setContainingClass(_get);
        EOperation candidate = null;
        EClass _containingClass = rule.getContainingClass();
        boolean bl = _notEquals = !Objects.equal((Object)_containingClass, null);
        if (_notEquals) {
            EOperation _findFirst;
            EClass _containingClass_1 = rule.getContainingClass();
            EList _eAllOperations = _containingClass_1.getEAllOperations();
            Functions.Function1<EOperation, Boolean> _function = new Functions.Function1<EOperation, Boolean>(){

                public Boolean apply(EOperation o) {
                    String _name = o.getName();
                    String _elementName = function.getElementName();
                    return _name.equals(_elementName);
                }
            };
            candidate = _findFirst = (EOperation)IterableExtensions.findFirst((Iterable)_eAllOperations, (Functions.Function1)_function);
        }
        boolean bl2 = _notEquals_1 = !Objects.equal(candidate, null);
        if (_notEquals_1) {
            rule.setOperation(candidate);
        } else {
            EOperation _xtendFunctionToEOperation = this.xtendFunctionToEOperation(function);
            rule.setOperation(_xtendFunctionToEOperation);
        }
        boolean _contains = this.stepFunctions.contains(function);
        rule.setStepRule(_contains);
        boolean _isMain = this.isMain(function);
        rule.setMain(_isMain);
        this.functionToRule.put(function, rule);
        return rule;
    }

    private void inspectForBigStep(IMethod function) {
        try {
            IType _declaringType;
            Set<IType> subtypes;
            boolean _notEquals_1;
            boolean _notEquals;
            Rule rule = this.getRuleOfFunction(function);
            Set<IMethod> calledFunctions = this.callGraph.get(function);
            boolean bl = _notEquals = !Objects.equal(calledFunctions, null);
            if (_notEquals) {
                for (IMethod calledFunction : calledFunctions) {
                    if (calledFunction == null) continue;
                    Rule calledRule = this.getRuleOfFunction(calledFunction);
                    EList _calledRules = rule.getCalledRules();
                    _calledRules.add((Object)calledRule);
                }
            }
            boolean bl2 = _notEquals_1 = !Objects.equal(subtypes = this.classToSubClasses.get(_declaringType = function.getDeclaringType()), null);
            if (_notEquals_1) {
                for (IType t : subtypes) {
                    IMethod[] _methods;
                    IMethod[] iMethodArray = _methods = t.getMethods();
                    int n = _methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String _elementName_1;
                        IMethod f = iMethodArray[n2];
                        String _elementName = f.getElementName();
                        boolean _equals = _elementName.equals(_elementName_1 = function.getElementName());
                        if (_equals) {
                            Rule overridingRule = this.getRuleOfFunction(f);
                            EList _overridenBy = rule.getOverridenBy();
                            _overridenBy.add((Object)overridingRule);
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private EOperation xtendFunctionToEOperation(IMethod function) {
        EOperation result = EcoreFactory.eINSTANCE.createEOperation();
        String _elementName = function.getElementName();
        result.setName(_elementName);
        return result;
    }

    private void inspectClass(final IType type) {
        try {
            boolean _not;
            boolean _contains = this.inspectedClasses.contains(type);
            boolean bl = _not = !_contains;
            if (_not) {
                IMethod[] _methods = type.getMethods();
                Functions.Function1<IMethod, Boolean> _function = new Functions.Function1<IMethod, Boolean>(){

                    public Boolean apply(IMethod it) {
                        String _elementName = it.getElementName();
                        return _elementName.startsWith("_privk3_");
                    }
                };
                final Iterable typeK3Methods = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_methods)), (Functions.Function1)_function);
                Iterables.addAll(this.allk3Methods, (Iterable)typeK3Methods);
                IMethod[] _methods_1 = type.getMethods();
                Functions.Function1<IMethod, Boolean> _function_1 = new Functions.Function1<IMethod, Boolean>(){

                    public Boolean apply(final IMethod m) {
                        Functions.Function1<IMethod, Boolean> _function = new Functions.Function1<IMethod, Boolean>(){

                            public Boolean apply(IMethod c) {
                                String _elementName = c.getElementName();
                                String _substring = _elementName.substring(8);
                                String _elementName_1 = m.getElementName();
                                return _substring.equals(_elementName_1);
                            }
                        };
                        return IterableExtensions.exists((Iterable)typeK3Methods, (Functions.Function1)_function);
                    }
                };
                Iterable typeMethods = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_methods_1)), (Functions.Function1)_function_1);
                Iterables.addAll(this.allMethods, (Iterable)typeMethods);
                Consumer<IMethod> _function_2 = new Consumer<IMethod>(){

                    @Override
                    public void accept(final IMethod m) {
                        Functions.Function1<IMethod, Boolean> _function = new Functions.Function1<IMethod, Boolean>(){

                            public Boolean apply(IMethod c) {
                                String _elementName = c.getElementName();
                                String _substring = _elementName.substring(8);
                                String _elementName_1 = m.getElementName();
                                return _substring.equals(_elementName_1);
                            }
                        };
                        IMethod k3m = (IMethod)IterableExtensions.findFirst((Iterable)typeK3Methods, (Functions.Function1)_function);
                        K3StepExtractor.this.k3MethodToMethod.put(k3m, m);
                        K3StepExtractor.this.methodToK3Method.put(m, k3m);
                    }
                };
                typeMethods.forEach(_function_2);
                HashSet candidateSupers = new HashSet();
                IMethod[] _methods_2 = type.getMethods();
                Functions.Function1<IMethod, Boolean> _function_3 = new Functions.Function1<IMethod, Boolean>(){

                    public Boolean apply(IMethod it) {
                        String _elementName = it.getElementName();
                        return _elementName.startsWith("super_");
                    }
                };
                Iterable _filter = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_methods_2)), (Functions.Function1)_function_3);
                Iterables.addAll(candidateSupers, (Iterable)_filter);
                Functions.Function1<IMethod, Boolean> _function_4 = new Functions.Function1<IMethod, Boolean>(){

                    public Boolean apply(final IMethod c) {
                        try {
                            IMethod[] _methods = type.getMethods();
                            Functions.Function1<IMethod, Boolean> _function = new Functions.Function1<IMethod, Boolean>(){

                                public Boolean apply(IMethod m) {
                                    String _elementName = c.getElementName();
                                    String _substring = _elementName.substring(6);
                                    String _elementName_1 = m.getElementName();
                                    return _substring.equals(_elementName_1);
                                }
                            };
                            return IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)_methods)), (Functions.Function1)_function);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                Iterable _filter_1 = IterableExtensions.filter(candidateSupers, (Functions.Function1)_function_4);
                Iterables.addAll(this.allSuperMethods, (Iterable)_filter_1);
                List<IAnnotation> _aspectAnnotations = this.getAspectAnnotations(type);
                for (IAnnotation a : _aspectAnnotations) {
                    EClass aspectedEClass = this.getAspectized(a);
                    this.stepAspectsClassToAspectedClasses.put(type, aspectedEClass);
                    IMethod[] _methods_3 = type.getMethods();
                    Functions.Function1<IMethod, Boolean> _function_5 = new Functions.Function1<IMethod, Boolean>(){

                        public Boolean apply(IMethod it) {
                            return K3StepExtractor.this.isStep(it);
                        }
                    };
                    Iterable _filter_2 = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_methods_3)), (Functions.Function1)_function_5);
                    Iterables.addAll(this.stepFunctions, (Iterable)_filter_2);
                    IMethod[] _methods_4 = type.getMethods();
                    Functions.Function1<IMethod, Boolean> _function_6 = new Functions.Function1<IMethod, Boolean>(){

                        public Boolean apply(IMethod it) {
                            return K3StepExtractor.this.isEvent(it);
                        }
                    };
                    Iterable _filter_3 = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_methods_4)), (Functions.Function1)_function_6);
                    Iterables.addAll(this.eventFunctions, (Iterable)_filter_3);
                }
                this.inspectedClasses.add(type);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void gatherCallsFromK3(final IMethod function) {
        HashSet callingSites = CallHierarchyHelper.getCallLocationsOf((IMethod)function);
        Consumer<CallLocation> _function = new Consumer<CallLocation>(){

            @Override
            public void accept(CallLocation cl) {
                final IMethod f = function;
                IMember member = cl.getMember();
                final IMethod method = K3StepExtractor.this.getContainingAspectMethod((IMethod)member);
                Functions.Function1<IMethod, Boolean> _function = new Functions.Function1<IMethod, Boolean>(){

                    public Boolean apply(IMethod m) {
                        return Objects.equal((Object)m, (Object)method);
                    }
                };
                Iterable _filter = IterableExtensions.filter((Iterable)K3StepExtractor.this.allk3Methods, (Functions.Function1)_function);
                Consumer<IMethod> _function_1 = new Consumer<IMethod>(){

                    @Override
                    public void accept(IMethod m) {
                        HashSet<IMethod> calledMethods = (HashSet<IMethod>)K3StepExtractor.this.k3MethodToCalledMethods.get(m);
                        boolean _equals = Objects.equal((Object)calledMethods, null);
                        if (_equals) {
                            HashSet<IMethod> _hashSet;
                            calledMethods = _hashSet = new HashSet<IMethod>();
                            K3StepExtractor.this.k3MethodToCalledMethods.put(m, calledMethods);
                        }
                        calledMethods.add(f);
                    }
                };
                _filter.forEach(_function_1);
            }
        };
        callingSites.forEach(_function);
    }

    private void gatherCallsFromSuper(final IMethod function) {
        HashSet callingSites = CallHierarchyHelper.getCallLocationsOf((IMethod)function);
        Consumer<CallLocation> _function = new Consumer<CallLocation>(){

            @Override
            public void accept(final CallLocation cl) {
                Functions.Function1<IMethod, Boolean> _function = new Functions.Function1<IMethod, Boolean>(){

                    public Boolean apply(IMethod m) {
                        IMember _member = cl.getMember();
                        return Objects.equal((Object)m, (Object)_member);
                    }
                };
                Iterable _filter = IterableExtensions.filter((Iterable)K3StepExtractor.this.allSuperMethods, (Functions.Function1)_function);
                Consumer<IMethod> _function_1 = new Consumer<IMethod>(){

                    @Override
                    public void accept(IMethod m) {
                        K3StepExtractor.this.superMethodTok3Method.put(m, function);
                    }
                };
                _filter.forEach(_function_1);
            }
        };
        callingSites.forEach(_function);
    }

    private void gatherOverridenMethods(final IMethod method) {
        boolean _isOverride = this.isOverride(method);
        if (_isOverride) {
            boolean _notEquals;
            final String methodName = method.getElementName();
            IType declaringType = method.getDeclaringType();
            Set<IType> superClasses = this.classToSuperClasses.get(declaringType);
            boolean bl = _notEquals = !Objects.equal(superClasses, null);
            if (_notEquals) {
                Consumer<IType> _function = new Consumer<IType>(){

                    @Override
                    public void accept(IType c) {
                        try {
                            boolean _notEquals;
                            IMethod[] _methods = c.getMethods();
                            Functions.Function1<IMethod, Boolean> _function = new Functions.Function1<IMethod, Boolean>(){

                                public Boolean apply(IMethod m) {
                                    String _elementName = m.getElementName();
                                    return _elementName.equals(methodName);
                                }
                            };
                            IMethod overridenMethod = (IMethod)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_methods)), (Functions.Function1)_function);
                            boolean bl = _notEquals = !Objects.equal((Object)overridenMethod, null);
                            if (_notEquals) {
                                HashSet<IMethod> overridingMethods = (HashSet<IMethod>)K3StepExtractor.this.methodToOverridingMethods.get(overridenMethod);
                                boolean _equals = Objects.equal((Object)overridingMethods, null);
                                if (_equals) {
                                    HashSet<IMethod> _hashSet;
                                    overridingMethods = _hashSet = new HashSet<IMethod>();
                                    K3StepExtractor.this.methodToOverridingMethods.put(overridenMethod, overridingMethods);
                                }
                                overridingMethods.add(method);
                            }
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                superClasses.forEach(_function);
            }
        }
    }

    private void generateStepFromXtend(Set<IType> files) {
        Consumer<IMethod> _function_7;
        Integer _apply;
        Functions.Function0<Integer> _function_6;
        Consumer<IType> _function = new Consumer<IType>(){

            @Override
            public void accept(IType c) {
                Set _allSuperClasses = K3StepExtractor.this.getAllSuperClasses(c);
                Functions.Function1<IType, Boolean> _function = new Functions.Function1<IType, Boolean>(){

                    public Boolean apply(IType t) {
                        return K3StepExtractor.this.allClasses.contains(t);
                    }
                };
                Iterable _filter = IterableExtensions.filter((Iterable)_allSuperClasses, (Functions.Function1)_function);
                Set allSuperClasses = IterableExtensions.toSet((Iterable)_filter);
                K3StepExtractor.this.classToSuperClasses.put(c, allSuperClasses);
                Set _allSubClasses = K3StepExtractor.this.getAllSubClasses(c);
                Functions.Function1<IType, Boolean> _function_1 = new Functions.Function1<IType, Boolean>(){

                    public Boolean apply(IType t) {
                        return K3StepExtractor.this.allClasses.contains(t);
                    }
                };
                Iterable _filter_1 = IterableExtensions.filter((Iterable)_allSubClasses, (Functions.Function1)_function_1);
                Set allSubClasses = IterableExtensions.toSet((Iterable)_filter_1);
                K3StepExtractor.this.classToSubClasses.put(c, allSubClasses);
            }
        };
        this.allClasses.forEach(_function);
        for (IType c : this.allClasses) {
            this.inspectClass(c);
        }
        Consumer<IMethod> _function_1 = new Consumer<IMethod>(){

            @Override
            public void accept(IMethod it) {
                K3StepExtractor.this.gatherCallsFromSuper(it);
            }
        };
        this.allk3Methods.forEach(_function_1);
        Consumer<IMethod> _function_2 = new Consumer<IMethod>(){

            @Override
            public void accept(IMethod it) {
                K3StepExtractor.this.gatherOverridenMethods(it);
            }
        };
        this.allMethods.forEach(_function_2);
        Consumer<IMethod> _function_3 = new Consumer<IMethod>(){

            @Override
            public void accept(IMethod it) {
                K3StepExtractor.this.gatherCallsFromK3(it);
            }
        };
        this.allMethods.forEach(_function_3);
        Consumer<IMethod> _function_4 = new Consumer<IMethod>(){

            @Override
            public void accept(IMethod it) {
                K3StepExtractor.this.gatherCallsFromK3(it);
            }
        };
        this.allSuperMethods.forEach(_function_4);
        Consumer<IMethod> _function_5 = new Consumer<IMethod>(){

            @Override
            public void accept(final IMethod m) {
                boolean _notEquals;
                IMethod k3m = (IMethod)K3StepExtractor.this.methodToK3Method.get(m);
                boolean bl = _notEquals = !Objects.equal((Object)k3m, null);
                if (_notEquals) {
                    boolean _notEquals_1;
                    Set calledMethods = (Set)K3StepExtractor.this.k3MethodToCalledMethods.get(k3m);
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)calledMethods, null);
                    if (_notEquals_1) {
                        Consumer<IMethod> _function = new Consumer<IMethod>(){

                            @Override
                            public void accept(IMethod c) {
                                boolean _contains = K3StepExtractor.this.allMethods.contains(c);
                                if (_contains) {
                                    HashSet<IMethod> tmp = (HashSet<IMethod>)K3StepExtractor.this.callGraph.get(m);
                                    boolean _equals = Objects.equal((Object)tmp, null);
                                    if (_equals) {
                                        HashSet<IMethod> _hashSet;
                                        tmp = _hashSet = new HashSet<IMethod>();
                                        K3StepExtractor.this.callGraph.put(m, tmp);
                                    }
                                    tmp.add(c);
                                }
                            }
                        };
                        calledMethods.forEach(_function);
                    }
                }
            }
        };
        this.allMethods.forEach(_function_5);
        Functions.Function0<Integer> callGraphTotalLengthComputer = _function_6 = new Functions.Function0<Integer>(){

            public Integer apply() {
                Collection _values = K3StepExtractor.this.callGraph.values();
                Functions.Function1<Set<IMethod>, Integer> _function = new Functions.Function1<Set<IMethod>, Integer>(){

                    public Integer apply(Set<IMethod> s) {
                        return s.size();
                    }
                };
                Iterable _map = IterableExtensions.map(_values, (Functions.Function1)_function);
                Functions.Function2<Integer, Integer, Integer> _function_1 = new Functions.Function2<Integer, Integer, Integer>(){

                    public Integer apply(Integer i1, Integer i2) {
                        return i1 + i2;
                    }
                };
                return (Integer)IterableExtensions.reduce((Iterable)_map, (Functions.Function2)_function_1);
            }
        };
        Integer totalLength = (Integer)callGraphTotalLengthComputer.apply();
        int previousTotalLength = -1;
        while (totalLength > previousTotalLength) {
            Integer _apply2;
            Consumer<IMethod> _function_72 = new Consumer<IMethod>(){

                @Override
                public void accept(IMethod m) {
                    boolean _notEquals;
                    HashSet _xifexpression = null;
                    Set _get = (Set)K3StepExtractor.this.callGraph.get(m);
                    boolean _equals = Objects.equal((Object)_get, null);
                    if (_equals) {
                        HashSet _xblockexpression = null;
                        HashSet tmp = new HashSet();
                        K3StepExtractor.this.callGraph.put(m, tmp);
                        _xifexpression = _xblockexpression = tmp;
                    } else {
                        _xifexpression = (HashSet)K3StepExtractor.this.callGraph.get(m);
                    }
                    final HashSet calledMethods = _xifexpression;
                    Set overridingMethods = (Set)K3StepExtractor.this.methodToOverridingMethods.get(m);
                    boolean bl = _notEquals = !Objects.equal((Object)overridingMethods, null);
                    if (_notEquals) {
                        Consumer<IMethod> _function = new Consumer<IMethod>(){

                            @Override
                            public void accept(IMethod n) {
                                boolean _notEquals;
                                Set calledByOverride = (Set)K3StepExtractor.this.callGraph.get(n);
                                boolean bl = _notEquals = !Objects.equal((Object)calledByOverride, null);
                                if (_notEquals) {
                                    calledMethods.addAll(calledByOverride);
                                }
                            }
                        };
                        overridingMethods.forEach(_function);
                    }
                }
            };
            this.allMethods.forEach(_function_72);
            previousTotalLength = totalLength;
            totalLength = _apply2 = (Integer)callGraphTotalLengthComputer.apply();
        }
        totalLength = _apply = (Integer)callGraphTotalLengthComputer.apply();
        previousTotalLength = -1;
        while (totalLength > previousTotalLength) {
            Integer _apply_1;
            _function_7 = new Consumer<IMethod>(){

                @Override
                public void accept(IMethod m) {
                    boolean _notEquals;
                    Set calledMethods = (Set)K3StepExtractor.this.callGraph.get(m);
                    boolean bl = _notEquals = !Objects.equal((Object)calledMethods, null);
                    if (_notEquals) {
                        final HashSet tmp = new HashSet();
                        Consumer<IMethod> _function = new Consumer<IMethod>(){

                            @Override
                            public void accept(IMethod n) {
                                boolean _notEquals;
                                Set overridingMethods = (Set)K3StepExtractor.this.methodToOverridingMethods.get(n);
                                boolean bl = _notEquals = !Objects.equal((Object)overridingMethods, null);
                                if (_notEquals) {
                                    tmp.addAll(overridingMethods);
                                }
                            }
                        };
                        calledMethods.forEach(_function);
                        calledMethods.addAll(tmp);
                    }
                }
            };
            this.allMethods.forEach(_function_7);
            previousTotalLength = totalLength;
            totalLength = _apply_1 = (Integer)callGraphTotalLengthComputer.apply();
        }
        _function_7 = new Consumer<IMethod>(){

            @Override
            public void accept(IMethod m) {
                HashSet calledMethods = (HashSet)K3StepExtractor.this.callGraph.get(m);
                boolean _equals = Objects.equal((Object)calledMethods, null);
                if (_equals) {
                    HashSet _hashSet;
                    calledMethods = _hashSet = new HashSet();
                    K3StepExtractor.this.callGraph.put(m, calledMethods);
                }
                calledMethods.addAll(K3StepExtractor.this.eventFunctions);
            }
        };
        this.allMethods.forEach(_function_7);
        Consumer<IMethod> _function_8 = new Consumer<IMethod>(){

            @Override
            public void accept(final IMethod m) {
                boolean _notEquals;
                IMethod k3m = (IMethod)K3StepExtractor.this.methodToK3Method.get(m);
                boolean bl = _notEquals = !Objects.equal((Object)k3m, null);
                if (_notEquals) {
                    boolean _notEquals_1;
                    Set calledMethods = (Set)K3StepExtractor.this.k3MethodToCalledMethods.get(k3m);
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)calledMethods, null);
                    if (_notEquals_1) {
                        Consumer<IMethod> _function = new Consumer<IMethod>(){

                            @Override
                            public void accept(IMethod c) {
                                boolean _contains = K3StepExtractor.this.allSuperMethods.contains(c);
                                if (_contains) {
                                    IMethod actualMethod;
                                    boolean _notEquals;
                                    IMethod actualk3Method = (IMethod)K3StepExtractor.this.superMethodTok3Method.get(c);
                                    boolean bl = _notEquals = !Objects.equal((Object)actualk3Method, null);
                                    if (_notEquals && !Objects.equal((Object)(actualMethod = (IMethod)K3StepExtractor.this.k3MethodToMethod.get(actualk3Method)), null) && K3StepExtractor.this.allMethods.contains(actualMethod)) {
                                        HashSet<IMethod> tmp = (HashSet<IMethod>)K3StepExtractor.this.callGraph.get(m);
                                        boolean _equals = Objects.equal((Object)tmp, null);
                                        if (_equals) {
                                            HashSet<IMethod> _hashSet;
                                            tmp = _hashSet = new HashSet<IMethod>();
                                            K3StepExtractor.this.callGraph.put(m, tmp);
                                        }
                                        tmp.add(actualMethod);
                                    }
                                }
                            }
                        };
                        calledMethods.forEach(_function);
                    }
                }
            }
        };
        this.allMethods.forEach(_function_8);
        InputOutput.println((Object)"Callgraph : \n\n");
        BiConsumer<IMethod, Set<IMethod>> _function_9 = new BiConsumer<IMethod, Set<IMethod>>(){

            @Override
            public void accept(IMethod m, Set<IMethod> s) {
                IType _declaringType = m.getDeclaringType();
                String _elementName = _declaringType.getElementName();
                String _plus = String.valueOf(_elementName) + ".";
                String _elementName_1 = m.getElementName();
                String _plus_1 = String.valueOf(_plus) + _elementName_1;
                String _plus_2 = String.valueOf(_plus_1) + " : \n";
                Functions.Function1<IMethod, String> _function = new Functions.Function1<IMethod, String>(){

                    public String apply(IMethod n) {
                        IType _declaringType = n.getDeclaringType();
                        String _elementName = _declaringType.getElementName();
                        String _plus = String.valueOf(_elementName) + ".";
                        String _elementName_1 = n.getElementName();
                        return String.valueOf(_plus) + _elementName_1;
                    }
                };
                Iterable _map = IterableExtensions.map(s, (Functions.Function1)_function);
                Functions.Function2<String, String, String> _function_1 = new Functions.Function2<String, String, String>(){

                    public String apply(String s1, String s2) {
                        return String.valueOf(s1) + ", " + s2;
                    }
                };
                String _reduce = (String)IterableExtensions.reduce((Iterable)_map, (Functions.Function2)_function_1);
                String _plus_3 = String.valueOf(_plus_2) + _reduce;
                String _plus_4 = String.valueOf(_plus_3) + "\n";
                InputOutput.println((Object)_plus_4);
            }
        };
        this.callGraph.forEach(_function_9);
        for (IMethod function : this.allMethods) {
            this.inspectForBigStep(function);
        }
    }

    private List<IAnnotation> getAspectAnnotations(IType type) {
        try {
            boolean _isClass = type.isClass();
            if (_isClass) {
                IAnnotation[] _annotations = type.getAnnotations();
                Functions.Function1<IAnnotation, Boolean> _function = new Functions.Function1<IAnnotation, Boolean>(){

                    public Boolean apply(IAnnotation annot) {
                        boolean _xblockexpression = false;
                        String name = annot.getElementName();
                        int lastDotIndex = name.lastIndexOf(".");
                        String simpleName = name;
                        if (lastDotIndex != -1) {
                            String _substring;
                            simpleName = _substring = name.substring(lastDotIndex + 1);
                        }
                        _xblockexpression = simpleName.equals("Aspect");
                        return _xblockexpression;
                    }
                };
                Iterable _filter = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_annotations)), (Functions.Function1)_function);
                return IterableExtensions.toList((Iterable)_filter);
            }
            return new ArrayList<IAnnotation>();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private boolean testAnnotation(IMethod method, final String annotationSimpleName) {
        try {
            IAnnotation[] _annotations = method.getAnnotations();
            Functions.Function1<IAnnotation, Boolean> _function = new Functions.Function1<IAnnotation, Boolean>(){

                public Boolean apply(IAnnotation annot) {
                    String name = annot.getElementName();
                    int lastDotIndex = name.lastIndexOf(".");
                    String simpleName = name;
                    if (lastDotIndex != -1) {
                        String _substring;
                        simpleName = _substring = name.substring(lastDotIndex + 1);
                    }
                    return simpleName.equals(annotationSimpleName);
                }
            };
            return IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)_annotations)), (Functions.Function1)_function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private boolean isStep(IMethod method) {
        return this.testAnnotation(method, "Step");
    }

    private boolean isEvent(IMethod method) {
        try {
            boolean _xblockexpression = false;
            IAnnotation[] _annotations = method.getAnnotations();
            Functions.Function1<IAnnotation, Boolean> _function = new Functions.Function1<IAnnotation, Boolean>(){

                public Boolean apply(IAnnotation a) {
                    String name = a.getElementName();
                    int lastDotIndex = name.lastIndexOf(".");
                    String simpleName = name;
                    if (lastDotIndex != -1) {
                        String _substring;
                        simpleName = _substring = name.substring(lastDotIndex + 1);
                    }
                    return Objects.equal((Object)simpleName, (Object)"Step");
                }
            };
            IAnnotation annotation = (IAnnotation)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_annotations)), (Functions.Function1)_function);
            _xblockexpression = !Objects.equal((Object)annotation, null) && IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)annotation.getMemberValuePairs())), (Functions.Function1)new Functions.Function1<IMemberValuePair, Boolean>(){

                public Boolean apply(IMemberValuePair p) {
                    return Objects.equal((Object)p.getMemberName(), (Object)"eventHandler") && p.getValue() instanceof Boolean && (Boolean)p.getValue() != false;
                }
            });
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private boolean isOverride(IMethod method) {
        return this.testAnnotation(method, "OverrideAspectMethod");
    }

    private boolean isMain(IMethod method) {
        return this.testAnnotation(method, "Main");
    }

    private Set<IType> getAllSubClasses(IType type) {
        try {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            ITypeHierarchy hierarchy = type.newTypeHierarchy((IProgressMonitor)_nullProgressMonitor);
            IType[] _allSubtypes = hierarchy.getAllSubtypes(type);
            return IterableExtensions.toSet((Iterable)((Iterable)Conversions.doWrapArray((Object)_allSubtypes)));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Set<IType> getAllSuperClasses(IType type) {
        try {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            ITypeHierarchy hierarchy = type.newTypeHierarchy((IProgressMonitor)_nullProgressMonitor);
            IType[] _allSuperclasses = hierarchy.getAllSuperclasses(type);
            return IterableExtensions.toSet((Iterable)((Iterable)Conversions.doWrapArray((Object)_allSuperclasses)));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private EClass getAspectized(IAnnotation annot) {
        try {
            IMemberValuePair[] _memberValuePairs = annot.getMemberValuePairs();
            Functions.Function1<IMemberValuePair, Boolean> _function = new Functions.Function1<IMemberValuePair, Boolean>(){

                public Boolean apply(IMemberValuePair p) {
                    String _memberName = p.getMemberName();
                    return Objects.equal((Object)_memberName, (Object)"className");
                }
            };
            IMemberValuePair _findFirst = (IMemberValuePair)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_memberValuePairs)), (Functions.Function1)_function);
            Object _value = _findFirst.getValue();
            final String aspectedClassName = (String)_value;
            TreeIterator _eAllContents = this.extendedMetamodel.eAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_eAllContents, EClass.class);
            Functions.Function1<EClass, Boolean> _function_1 = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass c1) {
                    String _name = c1.getName();
                    return aspectedClassName.equals(_name);
                }
            };
            return (EClass)IteratorExtensions.findFirst((Iterator)_filter, (Functions.Function1)_function_1);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private IMethod getContainingAspectMethod(IMethod function) {
        IType container = function.getDeclaringType();
        boolean _contains = this.allClasses.contains(container);
        if (_contains) {
            return function;
        }
        IJavaElement parent = function.getParent();
        while (parent != null) {
            IJavaElement _parent;
            if (parent instanceof IMethod) {
                return this.getContainingAspectMethod((IMethod)parent);
            }
            parent = _parent = parent.getParent();
        }
        return null;
    }
}

