/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.javadoc;

import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jface.internal.text.html.SingleCharReader;

public class JavaDocCommentReader
extends SingleCharReader {
    private IBuffer fBuffer;
    private int fCurrPos;
    private int fStartPos;
    private int fEndPos;
    private boolean fWasNewLine;

    public JavaDocCommentReader(IBuffer buf, int start, int end) {
        this.fBuffer = buf;
        this.fStartPos = start + 3;
        this.fEndPos = end - 2;
        this.reset();
    }

    public int read() {
        if (this.fCurrPos < this.fEndPos) {
            char ch = this.fBuffer.getChar(this.fCurrPos++);
            if (this.fWasNewLine && !IndentManipulation.isLineDelimiterChar((char)ch)) {
                while (this.fCurrPos < this.fEndPos && Character.isWhitespace(ch)) {
                    ch = this.fBuffer.getChar(this.fCurrPos++);
                }
                if (ch == '*') {
                    if (this.fCurrPos < this.fEndPos) {
                        while ((ch = this.fBuffer.getChar(this.fCurrPos++)) == '*') {
                        }
                    } else {
                        return -1;
                    }
                }
            }
            this.fWasNewLine = IndentManipulation.isLineDelimiterChar((char)ch);
            return ch;
        }
        return -1;
    }

    public void close() {
        this.fBuffer = null;
    }

    public void reset() {
        this.fCurrPos = this.fStartPos;
        this.fWasNewLine = true;
        if (this.fCurrPos < this.fEndPos && '\r' == this.fBuffer.getChar(this.fCurrPos)) {
            ++this.fCurrPos;
        }
        if (this.fCurrPos < this.fEndPos && '\n' == this.fBuffer.getChar(this.fCurrPos)) {
            ++this.fCurrPos;
        }
    }

    public int getOffset() {
        return this.fCurrPos;
    }
}

