/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.wizards.NewModuleInfoWizard;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class CreateModuleInfoAction
implements IObjectActionDelegate {
    private static final String MODULE_INFO_JAVA_FILENAME = "module-info.java";
    private ISelection fSelection;

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IJavaProject javaProject = null;
        if (this.fSelection instanceof IStructuredSelection) {
            Object selectedElement = ((IStructuredSelection)this.fSelection).getFirstElement();
            if (selectedElement instanceof IProject) {
                javaProject = JavaCore.create((IProject)((IProject)selectedElement));
            } else if (selectedElement instanceof IJavaProject) {
                javaProject = (IJavaProject)selectedElement;
            } else {
                return;
            }
            try {
                if (!JavaModelUtil.is9OrHigher((IJavaProject)javaProject)) {
                    MessageDialog.openError((Shell)this.getDisplay().getActiveShell(), (String)ActionMessages.CreateModuleInfoAction_error_title, (String)ActionMessages.CreateModuleInfoAction_error_message_compliance);
                    return;
                }
                IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
                ArrayList<IPackageFragmentRoot> packageFragmentRootsAsList = new ArrayList<IPackageFragmentRoot>(Arrays.asList(packageFragmentRoots));
                IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots;
                int n = packageFragmentRoots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                    IResource res = packageFragmentRoot.getCorrespondingResource();
                    if (res == null || res.getType() != 2 || packageFragmentRoot.getKind() != 1) {
                        packageFragmentRootsAsList.remove(packageFragmentRoot);
                    }
                    ++n2;
                }
                packageFragmentRoots = packageFragmentRootsAsList.toArray(new IPackageFragmentRoot[packageFragmentRootsAsList.size()]);
                if (packageFragmentRoots.length == 0) {
                    MessageDialog.openError((Shell)this.getDisplay().getActiveShell(), (String)ActionMessages.CreateModuleInfoAction_error_title, (String)ActionMessages.CreateModuleInfoAction_error_message_no_source_folder);
                    return;
                }
                IPackageFragmentRoot targetPkgFragmentRoot = null;
                IPackageFragmentRoot[] iPackageFragmentRootArray2 = packageFragmentRoots;
                int n3 = packageFragmentRoots.length;
                n = 0;
                while (n < n3) {
                    IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray2[n];
                    if (packageFragmentRoot.getPackageFragment("").getCompilationUnit(MODULE_INFO_JAVA_FILENAME).exists()) {
                        String message = Messages.format(ActionMessages.CreateModuleInfoAction_question_message_overwrite_module_info, packageFragmentRoot.getElementName());
                        boolean overwrite = MessageDialog.openQuestion((Shell)this.getDisplay().getActiveShell(), (String)ActionMessages.CreateModuleInfoAction_error_title, (String)message);
                        if (!overwrite) {
                            return;
                        }
                        targetPkgFragmentRoot = packageFragmentRoot;
                        break;
                    }
                    ++n;
                }
                NewModuleInfoWizard moduleInfoWizard = new NewModuleInfoWizard(javaProject, packageFragmentRoots, targetPkgFragmentRoot);
                WizardDialog dialog = new WizardDialog(this.getDisplay().getActiveShell(), (IWizard)moduleInfoWizard);
                dialog.setHelpAvailable(false);
                dialog.create();
                dialog.open();
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
    }

    private Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

