/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaElementHyperlinkDeclaredTypeDetector;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class JavaElementDeclaredTypeHyperlink
implements IHyperlink {
    private final IRegion fRegion;
    private final SelectionDispatchAction fOpenAction;
    private final IJavaElement fElement;
    private final String fTypeSig;
    private final boolean fQualify;

    public JavaElementDeclaredTypeHyperlink(IRegion region, SelectionDispatchAction openAction, IJavaElement element, boolean qualify) {
        this(region, openAction, element, null, qualify);
    }

    public JavaElementDeclaredTypeHyperlink(IRegion region, SelectionDispatchAction openAction, IJavaElement element, String typeSig, boolean qualify) {
        Assert.isNotNull((Object)((Object)openAction));
        Assert.isNotNull((Object)region);
        Assert.isNotNull((Object)element);
        this.fRegion = region;
        this.fOpenAction = openAction;
        this.fElement = element;
        this.fTypeSig = typeSig;
        this.fQualify = qualify;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        if (this.fQualify) {
            if (this.fTypeSig == null) {
                String elementLabel = JavaElementLabels.getElementLabel(this.fElement, JavaElementLabels.ALL_FULLY_QUALIFIED);
                return Messages.format(JavaEditorMessages.JavaElementDeclaredTypeHyperlink_hyperlinkText_qualified, new Object[]{elementLabel});
            }
            String type = Signature.toString((String)this.fTypeSig);
            return Messages.format(JavaEditorMessages.JavaElementDeclaredTypeHyperlink_hyperlinkText_qualified_signature, new Object[]{type});
        }
        return JavaEditorMessages.JavaElementDeclaredTypeHyperlink_hyperlinkText;
    }

    public void open() {
        int kind;
        String typeSignature = this.fTypeSig;
        if (typeSignature == null) {
            try {
                typeSignature = JavaElementHyperlinkDeclaredTypeDetector.getTypeSignature(this.fElement);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return;
            }
        }
        if ((kind = Signature.getTypeSignatureKind((String)typeSignature)) == 4) {
            typeSignature = Signature.getElementType((String)typeSignature);
        } else if (kind == 1) {
            typeSignature = Signature.getTypeErasure((String)typeSignature);
        } else if (kind == 8) {
            String[] typeBounds = Signature.getUnionTypeBounds((String)typeSignature);
            ArrayList<IType> types = new ArrayList<IType>();
            int i = 0;
            while (i < typeBounds.length) {
                String typeErasure = Signature.getTypeErasure((String)typeBounds[i]);
                IType type = this.getType(typeErasure);
                if (type != null) {
                    types.add(type);
                }
                ++i;
            }
            if (types.size() > 0) {
                IJavaElement element = SelectionConverter.selectJavaElement((IJavaElement[])types.toArray(new IType[types.size()]), this.fOpenAction.getShell(), ActionMessages.OpenAction_error_title, ActionMessages.OpenAction_select_element);
                if (element != null) {
                    this.fOpenAction.run((IStructuredSelection)new StructuredSelection((Object)element));
                }
                return;
            }
        }
        IType type = this.getType(typeSignature);
        if (type != null) {
            this.fOpenAction.run((IStructuredSelection)new StructuredSelection((Object)type));
            return;
        }
        this.openElementAndShowErrorInStatusLine();
    }

    private IType getType(String typeSignature) {
        String[][] resolvedType;
        IType type;
        block4: {
            String typeName = Signature.toString((String)typeSignature);
            IJavaElement parent = this.fElement.getAncestor(7);
            if (parent == null) {
                return null;
            }
            type = null;
            try {
                resolvedType = ((IType)parent).resolveType(typeName);
                if (resolvedType != null && resolvedType.length != 0) break block4;
                return null;
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return null;
            }
        }
        String qualTypeName = JavaModelUtil.concatenateName((String)resolvedType[0][0], (String)resolvedType[0][1]);
        type = this.fElement.getJavaProject().findType(qualTypeName, null);
        return type;
    }

    private void openElementAndShowErrorInStatusLine() {
        try {
            IEditorPart editor = JavaUI.openInEditor(this.fElement);
            editor.getSite().getShell().getDisplay().beep();
            if (editor instanceof JavaEditor) {
                ((JavaEditor)editor).setStatusLineErrorMessage(JavaEditorMessages.JavaElementDeclaredTypeHyperlink_error_msg);
            }
        }
        catch (PartInitException e) {
            JavaPlugin.log(e);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
    }
}

