/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Predicate;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;

public class JavaPackageCompletionProcessor
implements IContentAssistProcessor,
ISubjectControlContentAssistProcessor {
    private IPackageFragmentRoot[] fPackageFragmentRoots;
    private CompletionProposalComparator fComparator = new CompletionProposalComparator();
    private ILabelProvider fLabelProvider;
    private Predicate<IPackageFragment> fFilter;
    private char[] fProposalAutoActivationSet;

    public JavaPackageCompletionProcessor() {
        this((ILabelProvider)new JavaElementLabelProvider(256));
    }

    public JavaPackageCompletionProcessor(ILabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        String triggers = preferenceStore.getString("content_assist_autoactivation_triggers_java");
        this.fProposalAutoActivationSet = triggers.toCharArray();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        Assert.isTrue((boolean)false, (String)"ITextViewer not supported");
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl contentAssistSubjectControl, int documentOffset) {
        if (this.fPackageFragmentRoots == null || this.fPackageFragmentRoots.length == 0) {
            return null;
        }
        String input = contentAssistSubjectControl.getDocument().get();
        ICompletionProposal[] proposals = this.createPackagesProposals(documentOffset, input);
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot ... packageFragmentRoots) {
        this.fPackageFragmentRoots = packageFragmentRoots;
    }

    public void setFilter(Predicate<IPackageFragment> filter) {
        this.fFilter = filter;
    }

    private ICompletionProposal[] createPackagesProposals(int documentOffset, String input) {
        ArrayList<JavaCompletionProposal> proposals = new ArrayList<JavaCompletionProposal>();
        String prefix = input.substring(0, documentOffset);
        HashSet<String> names = this.fPackageFragmentRoots.length > 1 ? new HashSet<String>() : null;
        IPackageFragmentRoot[] iPackageFragmentRootArray = this.fPackageFragmentRoots;
        int n = this.fPackageFragmentRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
            try {
                IJavaElement[] packageFragments = packageFragmentRoot.getChildren();
                int i = 0;
                while (i < packageFragments.length) {
                    IPackageFragment pack = (IPackageFragment)packageFragments[i];
                    String packName = pack.getElementName();
                    if (packName.length() != 0 && packName.startsWith(prefix) && (this.fFilter == null || this.fFilter.test(pack)) && (names == null || names.add(packName))) {
                        Image image = this.fLabelProvider.getImage((Object)pack);
                        JavaCompletionProposal proposal = new JavaCompletionProposal(packName, 0, input.length(), image, this.fLabelProvider.getText((Object)pack), 0);
                        proposals.add(proposal);
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
            ++n2;
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }
}

