/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.TypeNameMatchCollector;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AddModuleRequiresCorrectionProposal;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.text.java.ClasspathFixProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Image;

public class DefaultClasspathFixProcessor
extends ClasspathFixProcessor {
    @Override
    public ClasspathFixProcessor.ClasspathFixProposal[] getFixImportProposals(IJavaProject project, String missingType) throws CoreException {
        ArrayList<DefaultClasspathFixProposal> res = new ArrayList<DefaultClasspathFixProposal>();
        this.collectProposals(project, missingType, res);
        return res.toArray(new ClasspathFixProcessor.ClasspathFixProposal[res.size()]);
    }

    private void collectProposals(IJavaProject project, String name, Collection<DefaultClasspathFixProposal> proposals) throws CoreException {
        int idx = name.lastIndexOf(46);
        char[] packageName = idx != -1 ? name.substring(0, idx).toCharArray() : null;
        char[] typeName = name.substring(idx + 1).toCharArray();
        if (typeName.length == 1 && typeName[0] == '*') {
            typeName = null;
        }
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        ArrayList<TypeNameMatch> res = new ArrayList<TypeNameMatch>();
        TypeNameMatchCollector requestor = new TypeNameMatchCollector(res);
        int matchMode = 8;
        new SearchEngine().searchAllTypeNames(packageName, matchMode, typeName, matchMode, 0, scope, (TypeNameMatchRequestor)requestor, 3, null);
        if (res.isEmpty()) {
            return;
        }
        IModuleDescription currentModuleDescription = null;
        if (JavaModelUtil.is9OrHigher((IJavaProject)project) && (currentModuleDescription = project.getModuleDescription()) != null && !currentModuleDescription.exists()) {
            currentModuleDescription = null;
        }
        HashMap<IClasspathEntry, TypeNameMatch> classPathEntryToTypeNameMatch = new HashMap<IClasspathEntry, TypeNameMatch>();
        HashMap<TypeNameMatch, String> typeNameMatchToModuleName = new HashMap<TypeNameMatch, String>();
        HashSet<IClasspathEntry> classpaths = new HashSet<IClasspathEntry>();
        HashSet<TypeNameMatch> typesWithModule = new HashSet<TypeNameMatch>();
        if (currentModuleDescription != null) {
            int i = 0;
            while (i < res.size()) {
                TypeNameMatch curr = res.get(i);
                IType type = curr.getType();
                if (type != null) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)type.getAncestor(3);
                    try {
                        IClasspathEntry entry = root.getRawClasspathEntry();
                        if (entry != null) {
                            IModuleDescription projectModule = null;
                            String moduleName = null;
                            projectModule = root.getModuleDescription();
                            if (projectModule != null && projectModule.exists()) {
                                moduleName = projectModule.getElementName();
                            }
                            if (classpaths.add(entry)) {
                                classPathEntryToTypeNameMatch.put(entry, curr);
                                typesWithModule.add(curr);
                                if (moduleName != null) {
                                    typeNameMatchToModuleName.put(curr, moduleName);
                                }
                            } else {
                                Object typeNameMatch = classPathEntryToTypeNameMatch.get(entry);
                                if (typeNameMatch != null) {
                                    if (moduleName != null) {
                                        Object modName = typeNameMatchToModuleName.get(typeNameMatch);
                                        if (!moduleName.equals(modName)) {
                                            typesWithModule.remove(typeNameMatch);
                                            classPathEntryToTypeNameMatch.remove(entry);
                                        }
                                    } else {
                                        typesWithModule.remove(typeNameMatch);
                                        classPathEntryToTypeNameMatch.remove(entry);
                                    }
                                }
                            }
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
                ++i;
            }
        }
        HashSet<Object> addedClaspaths = new HashSet<Object>();
        int i = 0;
        while (i < res.size()) {
            block34: {
                TypeNameMatch curr = res.get(i);
                IType type = curr.getType();
                if (type != null) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)type.getAncestor(3);
                    try {
                        IClasspathEntry entry = root.getRawClasspathEntry();
                        if (entry == null) break block34;
                        Change cuChange = null;
                        String moduleName = null;
                        if (typesWithModule.contains(curr) && (moduleName = (String)typeNameMatchToModuleName.get(curr)) != null && currentModuleDescription != null) {
                            String changeDescription;
                            ICompilationUnit currentCU = currentModuleDescription.getCompilationUnit();
                            Object[] args = new String[]{moduleName};
                            String changeName = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_add_requires_module_info, args);
                            AddModuleRequiresCorrectionProposal moduleRequiresProposal = new AddModuleRequiresCorrectionProposal(moduleName, changeName, changeDescription = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_add_requires_module_description, args), currentCU, 0);
                            cuChange = moduleRequiresProposal.getChange();
                            if (cuChange != null) {
                                cuChange.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                            }
                        }
                        IJavaProject other = root.getJavaProject();
                        int entryKind = entry.getEntryKind();
                        if ((entry.isExported() || entryKind == 3) && addedClaspaths.add(other)) {
                            IClasspathEntry newEntry = null;
                            if (cuChange != null) {
                                IClasspathAttribute[] extraAttributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"module", (String)"true")};
                                newEntry = JavaCore.newProjectEntry((IPath)other.getPath(), null, (boolean)true, (IClasspathAttribute[])extraAttributes, (boolean)false);
                            } else {
                                newEntry = JavaCore.newProjectEntry((IPath)other.getPath());
                            }
                            Change change = ClasspathFixProcessor.ClasspathFixProposal.newAddClasspathChange(project, newEntry);
                            if (change != null) {
                                String label;
                                Object[] args = new String[]{BasicElementLabels.getResourceName((String)other.getElementName()), BasicElementLabels.getResourceName((String)project.getElementName())};
                                String desc = label = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_project_description, args);
                                if (cuChange != null) {
                                    String additionalLabel = cuChange.getName();
                                    additionalLabel = String.valueOf(additionalLabel.substring(0, 1).toLowerCase()) + additionalLabel.substring(1);
                                    change = new CompositeChange(change.getName(), new Change[]{change, cuChange});
                                    Object[] arguments = new String[]{label, additionalLabel};
                                    desc = label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_combine_two_proposals_info, arguments);
                                }
                                DefaultClasspathFixProposal proposal = new DefaultClasspathFixProposal(label, change, desc, 8);
                                proposals.add(proposal);
                            }
                        }
                        if (entryKind == 5) {
                            IPath entryPath = entry.getPath();
                            if (this.isNonProjectSpecificContainer(entryPath)) {
                                this.addLibraryProposal(project, root, entry, addedClaspaths, proposals, cuChange);
                                break block34;
                            }
                            try {
                                IClasspathEntry entryInContainer;
                                IClasspathContainer classpathContainer = JavaCore.getClasspathContainer((IPath)entryPath, (IJavaProject)root.getJavaProject());
                                if (classpathContainer != null && (entryInContainer = JavaModelUtil.findEntryInContainer((IClasspathContainer)classpathContainer, (IPath)root.getPath())) != null) {
                                    this.addLibraryProposal(project, root, entryInContainer, addedClaspaths, proposals, cuChange);
                                }
                                break block34;
                            }
                            catch (CoreException coreException) {}
                            break block34;
                        }
                        if (entryKind == 1 || entryKind == 4) {
                            this.addLibraryProposal(project, root, entry, addedClaspaths, proposals, cuChange);
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
            ++i;
        }
    }

    private void addLibraryProposal(IJavaProject project, IPackageFragmentRoot root, IClasspathEntry entry, Collection<Object> addedClaspaths, Collection<DefaultClasspathFixProposal> proposals, Change additionalChange) throws JavaModelException {
        Change change;
        String label;
        if (addedClaspaths.add(entry) && (label = DefaultClasspathFixProcessor.getAddClasspathLabel(entry, root, project)) != null && (change = ClasspathFixProcessor.ClasspathFixProposal.newAddClasspathChange(project, entry)) != null) {
            if (additionalChange != null) {
                String additionalLabel = additionalChange.getName();
                additionalLabel = String.valueOf(additionalLabel.substring(0, 1).toLowerCase()) + additionalLabel.substring(1);
                Object[] arguments = new String[]{label, additionalLabel};
                label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_combine_two_proposals_info, arguments);
                change = new CompositeChange(change.getName(), new Change[]{change, additionalChange});
            }
            DefaultClasspathFixProposal proposal = new DefaultClasspathFixProposal(label, change, label, 7);
            proposals.add(proposal);
        }
    }

    private boolean isNonProjectSpecificContainer(IPath containerPath) {
        String id;
        return containerPath.segmentCount() > 0 && ((id = containerPath.segment(0)).equals("org.eclipse.jdt.USER_LIBRARY") || id.equals(JavaRuntime.JRE_CONTAINER));
    }

    private static String getAddClasspathLabel(IClasspathEntry entry, IPackageFragmentRoot root, IJavaProject project) {
        switch (entry.getEntryKind()) {
            case 1: {
                if (root.isArchive()) {
                    Object[] args = new String[]{JavaElementLabels.getElementLabel((IJavaElement)root, 0x200000000000L), BasicElementLabels.getJavaElementName((String)project.getElementName())};
                    return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_archive_description, args);
                }
                Object[] args = new String[]{JavaElementLabels.getElementLabel((IJavaElement)root, 0x200000000000L), BasicElementLabels.getJavaElementName((String)project.getElementName())};
                return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_classfolder_description, args);
            }
            case 4: {
                Object[] args = new String[]{JavaElementLabels.getElementLabel((IJavaElement)root, 0L), BasicElementLabels.getJavaElementName((String)project.getElementName())};
                return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_variable_description, args);
            }
            case 5: {
                try {
                    Object[] args = new String[]{JavaElementLabels.getContainerEntryLabel(entry.getPath(), root.getJavaProject()), BasicElementLabels.getJavaElementName((String)project.getElementName())};
                    return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_addcp_library_description, args);
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        return null;
    }

    private static class DefaultClasspathFixProposal
    extends ClasspathFixProcessor.ClasspathFixProposal {
        private String fName;
        private Change fChange;
        private String fDescription;
        private int fRelevance;

        public DefaultClasspathFixProposal(String name, Change change, String description, int relevance) {
            this.fName = name;
            this.fChange = change;
            this.fDescription = description;
            this.fRelevance = relevance;
        }

        @Override
        public String getAdditionalProposalInfo() {
            return this.fDescription;
        }

        @Override
        public Change createChange(IProgressMonitor monitor) {
            return this.fChange;
        }

        @Override
        public String getDisplayString() {
            return this.fName;
        }

        @Override
        public Image getImage() {
            return JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        }

        @Override
        public int getRelevance() {
            return this.fRelevance;
        }
    }
}

