/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.gemoc.traceaddon;

import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gemoc.commons.eclipse.emf.EMFResource;
import org.eclipse.gemoc.executionframework.engine.core.CommandExecution;
import org.eclipse.gemoc.trace.commons.model.launchconfiguration.LaunchConfiguration;
import org.eclipse.gemoc.trace.commons.model.trace.Dimension;
import org.eclipse.gemoc.trace.commons.model.trace.State;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.commons.model.trace.Trace;
import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;
import org.eclipse.gemoc.trace.commons.model.trace.Value;
import org.eclipse.gemoc.trace.gemoc.api.IMultiDimensionalTraceAddon;
import org.eclipse.gemoc.trace.gemoc.api.IStateManager;
import org.eclipse.gemoc.trace.gemoc.api.ITraceConstructor;
import org.eclipse.gemoc.trace.gemoc.api.ITraceExplorer;
import org.eclipse.gemoc.trace.gemoc.api.ITraceExtractor;
import org.eclipse.gemoc.trace.gemoc.api.ITraceListener;
import org.eclipse.gemoc.trace.gemoc.api.ITraceNotifier;
import org.eclipse.gemoc.trace.gemoc.traceaddon.GenericTraceExplorer;
import org.eclipse.gemoc.trace.gemoc.traceaddon.GenericTraceExtractor;
import org.eclipse.gemoc.trace.gemoc.traceaddon.GenericTraceNotifier;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionContext;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionWorkspace;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.BatchModelChangeListener;
import org.eclipse.gemoc.xdsmlframework.api.extensions.engine_addon.EngineAddonSpecificationExtensionPoint;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public abstract class AbstractTraceAddon
implements IEngineAddon,
IMultiDimensionalTraceAddon<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> {
    private IExecutionContext _executionContext;
    private ITraceExplorer<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> traceExplorer;
    private ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> traceExtractor;
    private ITraceConstructor traceConstructor;
    private ITraceNotifier traceNotifier;
    private BatchModelChangeListener traceListener;
    private boolean needTransaction = true;
    private BatchModelChangeListener listenerAddon;
    private Trace<Step<?>, TracedObject<?>, State<?, ?>> trace;

    protected abstract ITraceConstructor constructTraceConstructor(Resource var1, Resource var2, Map<EObject, TracedObject<?>> var3);

    protected abstract IStateManager<State<?, ?>> constructStateManager(Resource var1, Map<TracedObject<?>, EObject> var2);

    public ITraceExplorer<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> getTraceExplorer() {
        return this.traceExplorer;
    }

    public ITraceConstructor getTraceConstructor() {
        return this.traceConstructor;
    }

    public ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> getTraceExtractor() {
        return this.traceExtractor;
    }

    public ITraceNotifier getTraceNotifier() {
        return this.traceNotifier;
    }

    public void load(Resource traceResource) {
        EList _contents = traceResource.getContents();
        EObject root = (EObject)IterableExtensions.head((Iterable)_contents);
        if (root instanceof Trace) {
            GenericTraceExtractor _genericTraceExtractor;
            GenericTraceExplorer _genericTraceExplorer;
            this.trace = (Trace)root;
            this.traceExplorer = _genericTraceExplorer = new GenericTraceExplorer(this.trace);
            this.traceExtractor = _genericTraceExtractor = new GenericTraceExtractor(this.trace);
        } else {
            this.traceExplorer = null;
            this.traceExtractor = null;
        }
    }

    private static String getEPackageFQN(EPackage p, String separator) {
        boolean _notEquals;
        EPackage superP = p.getESuperPackage();
        boolean bl = _notEquals = !Objects.equal((Object)superP, null);
        if (_notEquals) {
            String _ePackageFQN = AbstractTraceAddon.getEPackageFQN(superP, separator);
            String _plus = String.valueOf(_ePackageFQN) + separator;
            String _name = p.getName();
            return String.valueOf(_plus) + _name;
        }
        String _name_1 = p.getName();
        return StringExtensions.toFirstUpper((String)_name_1);
    }

    public void aboutToExecuteStep(IExecutionEngine executionEngine, Step<?> step) {
        this.manageStep(step, true);
    }

    public void stepExecuted(IExecutionEngine engine, Step<?> step) {
        this.manageStep(step, false);
    }

    private void manageStep(final Step<?> step, final boolean add) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal(step, null);
        if (_notEquals) {
            Runnable _function = new Runnable(){

                @Override
                public void run() {
                    List _changes = AbstractTraceAddon.this.listenerAddon.getChanges((Object)AbstractTraceAddon.this);
                    AbstractTraceAddon.this.traceConstructor.addState(_changes);
                    if (add) {
                        AbstractTraceAddon.this.traceConstructor.addStep(step);
                    } else {
                        AbstractTraceAddon.this.traceConstructor.endStep(step);
                    }
                    AbstractTraceAddon.this.traceNotifier.notifyListener((ITraceListener)AbstractTraceAddon.this.traceExtractor);
                    AbstractTraceAddon.this.traceNotifier.notifyListener((ITraceListener)AbstractTraceAddon.this.traceExplorer);
                    AbstractTraceAddon.this.traceNotifier.notifyListeners();
                    AbstractTraceAddon.this.traceExplorer.updateCallStack(step);
                }
            };
            this.modifyTrace(_function);
        }
    }

    public void engineAboutToStart(IExecutionEngine engine) {
        boolean _equals = Objects.equal((Object)this._executionContext, null);
        if (_equals) {
            ITraceConstructor _constructTraceConstructor;
            BatchModelChangeListener _batchModelChangeListener;
            boolean _notEquals;
            IExecutionContext _executionContext;
            this._executionContext = _executionContext = engine.getExecutionContext();
            Resource modelResource = this._executionContext.getResourceModel();
            ResourceSetImpl rs = new ResourceSetImpl();
            TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((ResourceSet)rs);
            this.needTransaction = _notEquals = !Objects.equal((Object)ed, null);
            IExecutionWorkspace _workspace = this._executionContext.getWorkspace();
            IPath _executionPath = _workspace.getExecutionPath();
            String _string = _executionPath.toString();
            String _plus = String.valueOf(_string) + "/execution.trace";
            URI traceModelURI = URI.createPlatformResourceURI((String)_plus, (boolean)false);
            Resource traceResource = rs.createResource(traceModelURI);
            IExecutionContext _executionContext_1 = engine.getExecutionContext();
            Resource _resourceModel = _executionContext_1.getResourceModel();
            Set _relatedResources = EMFResource.getRelatedResources((Resource)_resourceModel);
            this.listenerAddon = _batchModelChangeListener = new BatchModelChangeListener(_relatedResources);
            this.listenerAddon.registerObserver((Object)this);
            final LaunchConfiguration launchConfiguration = engine.extractLaunchConfiguration();
            HashBiMap exeToTraced = HashBiMap.create();
            this.traceConstructor = _constructTraceConstructor = this.constructTraceConstructor(modelResource, traceResource, (Map<EObject, TracedObject<?>>)exeToTraced);
            Runnable _function = new Runnable(){

                @Override
                public void run() {
                    AbstractTraceAddon.this.traceConstructor.initTrace(launchConfiguration);
                }
            };
            this.modifyTrace(_function);
            EList _contents = traceResource.getContents();
            EObject root = (EObject)IterableExtensions.head((Iterable)_contents);
            if (root instanceof Trace) {
                BatchModelChangeListener _batchModelChangeListener_1;
                GenericTraceExtractor _genericTraceExtractor;
                GenericTraceExplorer _genericTraceExplorer;
                this.trace = (Trace)root;
                BiMap _inverse = exeToTraced.inverse();
                IStateManager<State<?, ?>> stateManager = this.constructStateManager(modelResource, (Map<TracedObject<?>, EObject>)_inverse);
                this.traceExplorer = _genericTraceExplorer = new GenericTraceExplorer(this.trace, stateManager);
                this.traceExtractor = _genericTraceExtractor = new GenericTraceExtractor(this.trace);
                Set _relatedResources_1 = EMFResource.getRelatedResources((Resource)traceResource);
                this.traceListener = _batchModelChangeListener_1 = new BatchModelChangeListener(_relatedResources_1);
                GenericTraceNotifier _genericTraceNotifier = new GenericTraceNotifier(this.traceListener);
                this.traceNotifier = _genericTraceNotifier;
                this.traceNotifier.addListener(this.traceExtractor);
                this.traceNotifier.addListener(this.traceExplorer);
            }
        }
    }

    private void modifyTrace(final Runnable r, String message) {
        try {
            if (this.needTransaction) {
                boolean _not;
                Resource _resourceModel = this._executionContext.getResourceModel();
                TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((Resource)_resourceModel);
                final HashSet catchedException = new HashSet();
                RecordingCommand command = new RecordingCommand(ed, message){

                    protected void doExecute() {
                        try {
                            r.run();
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Throwable) {
                                Throwable t = _t;
                                catchedException.add(t);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                };
                CommandExecution.execute((TransactionalEditingDomain)ed, (RecordingCommand)command);
                boolean _isEmpty = catchedException.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    throw (Throwable)IterableExtensions.head(catchedException);
                }
            } else {
                r.run();
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void modifyTrace(Runnable r) {
        this.modifyTrace(r, "");
    }

    public List<String> validate(List<IEngineAddon> otherAddons) {
        ArrayList<String> errors = new ArrayList<String>();
        boolean found = false;
        String addonName = "";
        for (IEngineAddon iEngineAddon : otherAddons) {
            String _name;
            if (!(iEngineAddon instanceof AbstractTraceAddon) || iEngineAddon == this) continue;
            found = true;
            addonName = _name = EngineAddonSpecificationExtensionPoint.getName((IEngineAddon)iEngineAddon);
        }
        if (found) {
            String thisName = EngineAddonSpecificationExtensionPoint.getName((IEngineAddon)this);
            errors.add(String.valueOf(thisName) + " can't run with " + addonName);
        }
        return errors;
    }

    public Trace<?, ?, ?> getTrace() {
        return this.trace;
    }
}

