/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.inject.Singleton;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.xbase.lib.Exceptions;

@Singleton
public class UriExtensions {
    public URI toUri(String pathWithScheme) {
        java.net.URI javaNetUri = java.net.URI.create(pathWithScheme);
        String path = this.toPath(javaNetUri);
        return URI.createURI((String)path);
    }

    public String toPath(URI uri) {
        return this.toPath(java.net.URI.create(uri.toString()));
    }

    public String toPath(java.net.URI uri) {
        try {
            Path path = Paths.get(uri);
            return path.toUri().toString();
        }
        catch (Throwable _t) {
            if (_t instanceof FileSystemNotFoundException) {
                FileSystemNotFoundException e = (FileSystemNotFoundException)_t;
                return uri.toString();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

