/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.symbol;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.ReferenceAcceptor;
import org.eclipse.xtext.findReferences.TargetURICollector;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.ide.server.DocumentExtensions;
import org.eclipse.xtext.ide.util.CancelIndicatorProgressMonitor;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class DocumentSymbolService {
    @Inject
    @Extension
    private DocumentExtensions _documentExtensions;
    @Inject
    @Extension
    private EObjectAtOffsetHelper _eObjectAtOffsetHelper;
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    private IReferenceFinder referenceFinder;
    @Inject
    private TargetURICollector targetURICollector;
    @Inject
    private Provider<TargetURIs> targetURIProvider;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;

    public List<? extends Location> getDefinitions(XtextResource resource, int offset, IReferenceFinder.IResourceAccess resourceAccess, CancelIndicator cancelIndicator) {
        EObject element = this._eObjectAtOffsetHelper.resolveElementAt(resource, offset);
        if (element == null) {
            return CollectionLiterals.emptyList();
        }
        ArrayList locations = CollectionLiterals.newArrayList((Object[])new Location[0]);
        TargetURIs targetURIs = this.collectTargetURIs(element);
        for (URI targetURI : targetURIs) {
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            Procedures.Procedure1 _function = obj -> {
                Location _newLocation = this._documentExtensions.newLocation((EObject)obj);
                locations.add(_newLocation);
            };
            this.doRead(resourceAccess, targetURI, (Procedures.Procedure1<? super EObject>)_function);
        }
        return locations;
    }

    public List<? extends Location> getReferences(XtextResource resource, int offset, IReferenceFinder.IResourceAccess resourceAccess, IResourceDescriptions indexData, CancelIndicator cancelIndicator) {
        EObject element = this._eObjectAtOffsetHelper.resolveElementAt(resource, offset);
        if (element == null) {
            return CollectionLiterals.emptyList();
        }
        ArrayList locations = CollectionLiterals.newArrayList((Object[])new Location[0]);
        TargetURIs targetURIs = this.collectTargetURIs(element);
        IAcceptor _function = reference -> {
            Procedures.Procedure1 _function_1 = obj -> {
                Location _newLocation = this._documentExtensions.newLocation((EObject)obj, (EStructuralFeature)reference.getEReference(), reference.getIndexInList());
                locations.add(_newLocation);
            };
            this.doRead(resourceAccess, reference.getSourceEObjectUri(), (Procedures.Procedure1<? super EObject>)_function_1);
        };
        ReferenceAcceptor _referenceAcceptor = new ReferenceAcceptor(this.resourceServiceProviderRegistry, _function);
        CancelIndicatorProgressMonitor _cancelIndicatorProgressMonitor = new CancelIndicatorProgressMonitor(cancelIndicator);
        this.referenceFinder.findAllReferences(targetURIs, resourceAccess, indexData, (IReferenceFinder.Acceptor)_referenceAcceptor, (IProgressMonitor)_cancelIndicatorProgressMonitor);
        return locations;
    }

    protected TargetURIs collectTargetURIs(EObject targetObject) {
        TargetURIs targetURIs = (TargetURIs)this.targetURIProvider.get();
        this.targetURICollector.add(targetObject, targetURIs);
        return targetURIs;
    }

    public List<? extends SymbolInformation> getSymbols(XtextResource resource, CancelIndicator cancelIndicator) {
        LinkedHashMap symbols = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[0]);
        TreeIterator contents = EcoreUtil.getAllProperContents((Resource)resource, (boolean)true);
        while (contents.hasNext()) {
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            Object _next = contents.next();
            EObject obj = (EObject)_next;
            SymbolInformation symbol = this.createSymbol(obj);
            if (symbol == null) continue;
            symbols.put(obj, symbol);
            EObject container = this.getContainer(obj);
            SymbolInformation containerSymbol = (SymbolInformation)symbols.get(container);
            String _name = null;
            if (containerSymbol != null) {
                _name = containerSymbol.getName();
            }
            symbol.setContainerName(_name);
        }
        return IterableExtensions.toList(symbols.values());
    }

    protected EObject getContainer(EObject obj) {
        return obj.eContainer();
    }

    protected SymbolInformation createSymbol(EObject object) {
        String symbolName = this.getSymbolName(object);
        if (symbolName == null) {
            return null;
        }
        SymbolInformation symbol = new SymbolInformation();
        symbol.setName(symbolName);
        symbol.setKind(this.getSymbolKind(object));
        symbol.setLocation(this._documentExtensions.newLocation(object));
        return symbol;
    }

    protected String getSymbolName(EObject object) {
        return this.getSymbolName(this._iQualifiedNameProvider.getFullyQualifiedName(object));
    }

    protected SymbolKind getSymbolKind(EObject object) {
        return this.getSymbolKind(object.eClass());
    }

    public List<? extends SymbolInformation> getSymbols(IResourceDescription resourceDescription, String query, IReferenceFinder.IResourceAccess resourceAccess, CancelIndicator cancelIndicator) {
        LinkedList symbols = CollectionLiterals.newLinkedList((Object[])new SymbolInformation[0]);
        Iterable _exportedObjects = resourceDescription.getExportedObjects();
        for (IEObjectDescription description : _exportedObjects) {
            SymbolInformation symbol;
            this.operationCanceledManager.checkCanceled(cancelIndicator);
            boolean _filter = this.filter(description, query);
            if (!_filter || (symbol = this.createSymbol(description)) == null) continue;
            symbols.add(symbol);
            Procedures.Procedure1 _function = obj -> symbol.setLocation(this._documentExtensions.newLocation((EObject)obj));
            this.doRead(resourceAccess, description.getEObjectURI(), (Procedures.Procedure1<? super EObject>)_function);
        }
        return symbols;
    }

    protected boolean filter(IEObjectDescription description, String query) {
        return description.getQualifiedName().toLowerCase().toString().contains(query.toLowerCase());
    }

    protected SymbolInformation createSymbol(IEObjectDescription description) {
        String symbolName = this.getSymbolName(description);
        if (symbolName == null) {
            return null;
        }
        SymbolInformation symbol = new SymbolInformation();
        symbol.setName(symbolName);
        symbol.setKind(this.getSymbolKind(description));
        return symbol;
    }

    protected String getSymbolName(IEObjectDescription description) {
        return this.getSymbolName(description.getQualifiedName());
    }

    protected SymbolKind getSymbolKind(IEObjectDescription description) {
        return this.getSymbolKind(description.getEClass());
    }

    protected String getSymbolName(QualifiedName qualifiedName) {
        String _string = null;
        if (qualifiedName != null) {
            _string = qualifiedName.toString();
        }
        return _string;
    }

    protected SymbolKind getSymbolKind(EClass type) {
        return SymbolKind.Property;
    }

    protected void doRead(IReferenceFinder.IResourceAccess resourceAccess, URI objectURI, Procedures.Procedure1<? super EObject> acceptor) {
        IUnitOfWork _function = resourceSet -> {
            EObject object = resourceSet.getEObject(objectURI, true);
            if (object != null) {
                acceptor.apply((Object)object);
            }
            return null;
        };
        resourceAccess.readOnly(objectURI, _function);
    }
}

