/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.business.api.refresh.DiagramCreationUtil;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DView;
import org.osgi.framework.Version;

public class FontStyleForDNodeListElementMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    private static final Version MIGRATION_VERSION = new Version("10.0.0.201412231738");

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            EClass fontStyleClass = NotationPackage.eINSTANCE.getFontStyle();
            LinkedHashSet allViewsToUpdate = Sets.newLinkedHashSet();
            for (DView dView : dAnalysis.getOwnedViews()) {
                for (DDiagram dDiagram : Iterables.filter((Iterable)new DViewQuery(dView).getLoadedRepresentations(), DDiagram.class)) {
                    DiagramCreationUtil diagramCreationUtil = new DiagramCreationUtil(dDiagram);
                    if (!diagramCreationUtil.findAssociatedGMFDiagram()) continue;
                    Diagram gmfDiagram = diagramCreationUtil.getAssociatedGMFDiagram();
                    TreeIterator childIterator = gmfDiagram.eAllContents();
                    while (childIterator.hasNext()) {
                        EObject child = (EObject)childIterator.next();
                        if (!(child instanceof View) || !(((View)child).getElement() instanceof DNodeListElement)) continue;
                        View view = (View)child;
                        Style style = view.getStyle(fontStyleClass);
                        if (style == null) {
                            allViewsToUpdate.add(view);
                        }
                        childIterator.prune();
                    }
                }
            }
            for (View viewToUpdate : allViewsToUpdate) {
                FontStyle style = (FontStyle)fontStyleClass.getEPackage().getEFactoryInstance().create(fontStyleClass);
                viewToUpdate.getStyles().add((Object)style);
            }
        }
    }
}

