/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.dialect;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.business.internal.contribution.ReuseHelper;
import org.eclipse.sirius.description.contribution.Contribution;
import org.eclipse.sirius.description.contribution.ContributionPackage;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.emf.AllContents;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class TableContributionsFinder
implements Function<Iterable<EObject>, Iterable<Contribution>> {
    private final TableDescription mainDescription;

    public TableContributionsFinder(TableDescription mainDescription) {
        this.mainDescription = mainDescription;
    }

    public Iterable<Contribution> apply(Iterable<EObject> from) {
        LinkedHashSet<EObject> sortedRepresentations = this.getRelevantRepresentations(this.getAllRepresentations(from));
        ArrayList reversed = Lists.newArrayList(sortedRepresentations);
        Collections.reverse(reversed);
        ArrayList result = Lists.newArrayList();
        for (EObject root : reversed) {
            Iterables.addAll((Collection)result, (Iterable)Iterables.filter((Iterable)AllContents.of((EObject)root, (EClass)ContributionPackage.eINSTANCE.getContribution(), (boolean)true), Contribution.class));
        }
        return result;
    }

    private LinkedHashSet<EObject> getRelevantRepresentations(Set<EObject> allRepresentations) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        boolean changed = result.add(this.mainDescription);
        while (changed) {
            changed = false;
            for (RepresentationDescription r1 : Iterables.filter((Iterable)Lists.newArrayList((Iterable)result), RepresentationDescription.class)) {
                for (RepresentationDescription r2 : Iterables.filter(allRepresentations, RepresentationDescription.class)) {
                    if (r1 == r2 || !this.reuses(r1, r2)) continue;
                    boolean bl = changed = changed || result.add(r2);
                }
            }
            for (RepresentationExtensionDescription ext : Iterables.filter(allRepresentations, RepresentationExtensionDescription.class)) {
                for (RepresentationDescription r : Iterables.filter((Iterable)Lists.newArrayList((Iterable)result), RepresentationDescription.class)) {
                    if (!this.isExtending(ext, r)) continue;
                    boolean bl = changed = changed || result.add(ext);
                }
            }
        }
        return result;
    }

    private boolean reuses(RepresentationDescription user, RepresentationDescription used) {
        return new ReuseHelper().reuses((EObject)user, (EObject)used);
    }

    private boolean isExtending(RepresentationExtensionDescription extension, RepresentationDescription extended) {
        String targetSiriusURI = this.getTargetSiriusURI(extended);
        String targetRepresentationName = extended.getName();
        return Objects.equal((Object)extension.getViewpointURI(), (Object)targetSiriusURI) && Objects.equal((Object)extension.getRepresentationName(), (Object)targetRepresentationName);
    }

    private String getTargetSiriusURI(RepresentationDescription target) {
        Viewpoint vp;
        String uri;
        Option parentVp = new EObjectQuery((EObject)target).getFirstAncestorOfType(DescriptionPackage.eINSTANCE.getViewpoint());
        if (parentVp.some() && (uri = this.getSiriusURI(vp = (Viewpoint)parentVp.get())) != null) {
            return uri;
        }
        return null;
    }

    protected String getSiriusURI(Viewpoint vp) {
        Option uri = new ViewpointQuery(vp).getViewpointURI();
        if (uri.some()) {
            return ((URI)uri.get()).toString();
        }
        return null;
    }

    private Set<EObject> getAllRepresentations(Iterable<EObject> from) {
        HashSet result = Sets.newHashSet();
        for (EObject eObject : from) {
            Iterables.addAll((Collection)result, (Iterable)Iterables.filter((Iterable)AllContents.of((EObject)eObject, (boolean)true), (Predicate)Predicates.or((Predicate)Predicates.instanceOf(RepresentationDescription.class), (Predicate)Predicates.instanceOf(RepresentationExtensionDescription.class))));
        }
        return result;
    }
}

